/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.service.impl;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.dictonary.DicUtils;
import com.els.base.mould.his.entity.MouldAdjustHis;
import com.els.base.mould.his.service.MouldAdjustHisService;
import com.els.base.mould.master.dao.MouldMapper;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldCalculateLifeTimeService;
import com.els.base.mould.master.service.MouldMaterialService;
import com.els.base.mould.master.service.MouldService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMouldService")
public class MouldServiceImpl
implements MouldService {
    @Resource
    private MouldMapper mouldMapper;
    @Resource
    private MouldAdjustHisService mouldAdjustHisService;
    @Resource
    private MouldMaterialService mouldMaterialService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CompanyService companyService;
    private static final String MOULD_TEMP_CODE = "MOULD_TEMP_CODE";
    private static final String SYSTEM_PROFILE = "system_profile";
    private static final String INITIALIZE_TIME = "mould_initialize_time";
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    @CacheEvict(value={"mould"}, allEntries=true)
    public void addObj(Mould t) {
        this.mouldMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"mould"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"mould"}, allEntries=true)
    public void modifyObj(Mould t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"mould"}, keyGenerator="redisKeyGenerator")
    public Mould queryObjById(String id) {
        return this.mouldMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"mould"}, keyGenerator="redisKeyGenerator")
    public List<Mould> queryAllObjByExample(MouldExample example) {
        return this.mouldMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"mould"}, keyGenerator="redisKeyGenerator")
    public PageView<Mould> queryObjByPage(MouldExample example) {
        PageView<Mould> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"mould"}, allEntries=true)
    public void deleteMoulds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u5220\u9664\u6a21\u5177!");
        }
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)ids);
        Mould mould = new Mould();
        mould.setIsEnable(Constant.NO_INT);
        mould.setUpdateTime(new Date());
        this.mouldMapper.updateByExampleSelective(mould, example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"mould"}, allEntries=true)
    public void scrapMoulds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u62a5\u5e9f\u6a21\u5177!");
        }
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)ids).andMouldStatusEqualTo(Constant.NO_INT);
        if (this.mouldMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6a21\u5177\u4e2d\u5305\u542b\u5df2\u62a5\u5e9f\u7684\u6a21\u5177,\u65e0\u6cd5\u91cd\u590d\u62a5\u5e9f!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        Mould mould = new Mould();
        mould.setMouldStatus(Constant.NO_INT);
        mould.setUpdateTime(new Date());
        this.mouldMapper.updateByExampleSelective(mould, example);
        List<Mould> mouldList = this.queryAllObjByExample(example);
        this.addToMouldAdjustHis(mouldList);
    }

    private void addToMouldAdjustHis(List<Mould> mouldList) {
        if (null == mouldList) {
            return;
        }
        for (Mould mould : mouldList) {
            MouldAdjustHis his = new MouldAdjustHis();
            his.setAdjustBillNo(mould.getMouldTemporaryCode());
            his.setProjectId(mould.getProjectId());
            his.setPurCompanyId(mould.getPurCompanyId());
            his.setPurCompanySrmCode(mould.getPurCompanySrmCode());
            his.setPurCompanyName(mould.getPurCompanyName());
            his.setPurCompanyFullName(mould.getPurCompanyFullName());
            his.setSupCompanyId(mould.getSupCompanyId());
            his.setSupCompanySrmCode(mould.getSupCompanySrmCode());
            his.setSupCompanySapCode(mould.getSupCompanySapCode());
            his.setSupCompanyName(mould.getSupCompanyName());
            his.setSupCompanyFullName(mould.getSupCompanyFullName());
            his.setMouldCode(mould.getMouldTemporaryCode());
            his.setMouldDesc(mould.getMouldDesc());
            his.setMouldNo(mould.getMouldCode());
            his.setMouldMaterial(mould.getMouldMaterial());
            his.setHisUpdateTime(new Date());
            his.setChangeType(3);
            his.setBelongedYear(mould.getBelongedYear());
            his.setMouldPropertyRightState(mould.getMouldPropertyRightState());
            his.setManufacturer(mould.getManufacturer());
            his.setAssetContractNumber(mould.getAssetContractNumber());
            his.setMouldLifetime(mould.getMouldLifetime());
            his.setMouldAscription(mould.getMouldAscription());
            his.setLeadingOfficial(mould.getLeadingOfficial());
            his.setPurRemark(mould.getRemark());
            his.setCreateTime(new Date());
            this.mouldAdjustHisService.addObj(his);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"mould"}, allEntries=true)
    public void calculateMouldLifeTime() {
        MouldExample example = new MouldExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andMouldStatusEqualTo(Constant.YES_INT).andSupCompanyIdIsNotNull().andMouldCodeIsNotNull();
        List<Mould> mouldList = this.queryAllObjByExample(example);
        if (null == mouldList) {
            return;
        }
        MouldCalculateLifeTimeService mouldCalculateLifeTimeService = (MouldCalculateLifeTimeService)SpringContextHolder.getOneBean(MouldCalculateLifeTimeService.class);
        mouldCalculateLifeTimeService.calculate(mouldList);
        Date date = DateUtils.addDays((Date)new Date(), (int)-1);
        String formatDate = formatter.format(date);
        DicGroupItem item = DicUtils.getDicGroupItemByCode(SYSTEM_PROFILE, INITIALIZE_TIME);
        item.setValue(formatDate);
        this.dicGroupItemService.modifyObj(item);
    }

    @Override
    public Date getMouldLastCalculateTime() {
        Date lastCalculateTime = null;
        DicGroupItem item = DicUtils.getDicGroupItemByCode(SYSTEM_PROFILE, INITIALIZE_TIME);
        if (null == item) {
            throw new CommonException("\u3010\u6a21\u5177\u4e3b\u6570\u636e\u5bff\u547d\u8ba1\u7b97\u4e0a\u6b21\u622a\u6b62\u65e5\u671f,\u521d\u59cb\u5316\u4e0a\u6b21\u622a\u6b62\u65f6\u95f4\u3011\u67e5\u8be2\u5b57\u5178\u8fd4\u56de\u4e3a\u7a7a!");
        }
        String time = item.getValue();
        if (StringUtils.isEmpty((String)time)) {
            throw new CommonException("\u3010\u6a21\u5177\u4e3b\u6570\u636e\u5bff\u547d\u8ba1\u7b97\u4e0a\u6b21\u622a\u6b62\u65e5\u671f,\u521d\u59cb\u5316\u4e0a\u6b21\u622a\u6b62\u65f6\u95f4\u3011\u67e5\u8be2\u5230\u7684\u521d\u59cb\u5316\u65f6\u95f4\u4e3a\u7a7a,\u8bf7\u5148\u521d\u59cb\u5316\u5b57\u5178\u6570\u636e!");
        }
        try {
            lastCalculateTime = formatter.parse(time);
        }
        catch (ParseException e) {
            throw new CommonException("\u3010\u6a21\u5177\u4e3b\u6570\u636e\u5bff\u547d\u8ba1\u7b97\u4e0a\u6b21\u622a\u6b62\u65e5\u671f,\u521d\u59cb\u5316\u4e0a\u6b21\u622a\u6b62\u65f6\u95f4\u3011\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38,\u5b57\u5178\u8bbe\u7f6e\u7684\u521d\u59cb\u5316\u65f6\u95f4\u4e3a {}", time);
        }
        return lastCalculateTime;
    }

    @Override
    @Transactional
    @CacheEvict(value={"mould"}, allEntries=true)
    public void uploadExcelForCreateMould(List<Mould> mouldList, Project project, Company purCompany) {
        if (CollectionUtils.isEmpty(mouldList)) {
            return;
        }
        ArrayList<String> mouldCodeList = new ArrayList<String>();
        for (Mould mould : mouldList) {
            this.isIegalData(mould);
            if (StringUtils.isNotBlank((String)mould.getMouldCode())) {
                mould.setMouldCode(mould.getMouldCode().replaceAll("\\s*", ""));
                mouldCodeList.add(mould.getMouldCode());
            }
            if (!StringUtils.isNotBlank((String)mould.getSupCompanySapCode())) continue;
            this.isExistCompany(mould.getSupCompanySapCode());
        }
        if (CollectionUtils.isNotEmpty(mouldCodeList)) {
            this.isExistMouldCode(mouldCodeList);
        }
        for (Mould mould : mouldList) {
            this.completeMouldData(mould, project, purCompany);
        }
        this.mouldMapper.insertBatch(mouldList);
    }

    public void isExistCompany(String supCompanySapCode) {
        CompanyExample example = new CompanyExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCompanySapCodeEqualTo(supCompanySapCode);
        List list = this.companyService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u60a8\u6240\u586b\u7684\u4f9b\u5e94\u5546SAP\u7f16\u7801:" + supCompanySapCode + ",\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5!");
        }
    }

    public void isExistMouldCode(List<String> mouldCodeList) {
        MouldExample example = new MouldExample();
        example.createCriteria().andMouldCodeIn((List)mouldCodeList).andIsEnableEqualTo(Constant.YES_INT);
        if (this.mouldMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u8981\u5bfc\u5165\u7684\u6a21\u5177\u4e2d\u5df2\u6709\u90e8\u5206\u6a21\u5177\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d,\u8bf7\u68c0\u67e5\u6570\u636e!");
        }
    }

    private void isIegalData(Mould mould) {
        Assert.isNotBlank(mould.getMouldDesc(), "\u6a21\u5177\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank(mould.getMouldModel(), "\u673a\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank(mould.getAssetContractNumber(), "\u8d44\u4ea7/\u5408\u540c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank(mould.getBelongedYear(), "\u6240\u5c5e\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank(mould.getMouldSerialNumber(), "\u6a21\u5177\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotNull(mould.getMouldLifetime(), "\u6a21\u5177\u5bff\u547d\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    private void completeMouldData(Mould mould, Project project, Company purCompany) {
        mould.setId(UUIDGenerator.generateUUID());
        mould.setProjectId(project.getId());
        mould.setPurCompanyId(purCompany.getId());
        mould.setPurCompanySrmCode(purCompany.getCompanyCode());
        mould.setPurCompanyFullName(purCompany.getCompanyFullName());
        mould.setPurCompanyName(purCompany.getCompanyName());
        String tempMouldCode = this.generateCodeService.getNextCode(MOULD_TEMP_CODE);
        mould.setMouldTemporaryCode(tempMouldCode);
        mould.setMouldStatus(Constant.YES_INT);
        mould.setIsEnable(Constant.YES_INT);
        mould.setCreateTime(new Date());
    }

    @Override
    @Transactional
    @CacheEvict(value={"mould"}, allEntries=true)
    public void scrapExcelMoulds(List<Mould> mouldList) {
        if (CollectionUtils.isEmpty(mouldList)) {
            return;
        }
        for (Mould mould : mouldList) {
            if (StringUtils.isEmpty((String)mould.getMouldCode()) && StringUtils.isEmpty((String)mould.getMouldTemporaryCode())) {
                throw new CommonException("\u4e34\u65f6\u6a21\u5177\u7f16\u7801\u201d\u3001\u201c\u6a21\u5177\u7f16\u53f7\u201d\u81f3\u5c11\u9700\u8981\u8f93\u5165\u4e00\u4e2a\u7f16\u7801\uff01");
            }
            MouldExample example = new MouldExample();
            MouldExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT);
            if (StringUtils.isNotBlank((String)mould.getMouldTemporaryCode()) && StringUtils.isNotBlank((String)mould.getMouldCode())) {
                criteria.andMouldCodeEqualTo(mould.getMouldCode()).andMouldTemporaryCodeEqualTo(mould.getMouldTemporaryCode());
            }
            if (StringUtils.isNotBlank((String)mould.getMouldCode()) && StringUtils.isBlank((String)mould.getMouldTemporaryCode())) {
                criteria.andMouldCodeEqualTo(mould.getMouldCode());
            }
            if (StringUtils.isNotBlank((String)mould.getMouldTemporaryCode()) && StringUtils.isBlank((String)mould.getMouldCode())) {
                criteria.andMouldTemporaryCodeEqualTo(mould.getMouldTemporaryCode());
            }
            if (this.mouldMapper.countByExample(example) > 0) {
                Mould moulds = new Mould();
                moulds.setMouldStatus(Constant.NO_INT);
                moulds.setUpdateTime(new Date());
                this.mouldMapper.updateByExampleSelective(moulds, example);
                List<Mould> mouldlists = this.queryAllObjByExample(example);
                this.addToMouldAdjustHis(mouldlists);
                continue;
            }
            throw new CommonException("EXCEL\u4e2d\u7684\u90e8\u5206\u6a21\u5177\u7f16\u53f7\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u62a5\u5e9f\u64cd\u4f5c\uff01");
        }
    }
}

