CREATE TABLE  "T_BASE_PUR_ORDER_CHANGE" (
"ID" VARCHAR2(32) NOT NULL ,
"COMPANY_ID" VARCHAR2(32) NULL ,
"PROJECT_ID" VARCHAR2(32) NULL ,
"SUPPLIER_CODE" VARCHAR2(255) NULL ,
"ORDER_NO" VARCHAR2(255) NULL ,
"ORDER_ITEM_NO" VARCHAR2(255) NULL ,
"MATERIAL_CODE" VARCHAR2(255) NULL ,
"MATERIAL_DESC" VARCHAR2(255) NULL ,
"QUANTITY" DECIMAL NULL ,
"CANCELL_APPLY_NUM" DECIMAL NULL ,
"UNIT" VARCHAR2(255) NULL ,
"NO_TAX_PRICE" DECIMAL NULL ,
"PRICE_UNIT" VARCHAR2(255) NULL ,
"PRICE" DECIMAL NULL ,
"AMOUNT" DECIMAL NULL ,
"CURRENCY" VARCHAR2(255) NULL ,
"VOUCHER_DATE" DATE NULL ,
"DELIVERY_DATE" DATE NULL ,
"APPLY_DATE" DATE NULL ,
"STATUS" VARCHAR2(255) NULL ,
PRIMARY KEY ("ID")
)
NOCOMPRESS
;

COMMENT ON TABLE  "T_BASE_PUR_ORDER_CHANGE" IS '订单变更申请';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."COMPANY_ID" IS 'companyId';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."SUPPLIER_CODE" IS '供应商编码';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."ORDER_NO" IS '采购订单号';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."ORDER_ITEM_NO" IS '采购订单行项目';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."MATERIAL_CODE" IS '物料编码';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."MATERIAL_DESC" IS '物料描述';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."QUANTITY" IS '订单数量';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."CANCELL_APPLY_NUM" IS '申请取消（数量）';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."UNIT" IS '单位';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."NO_TAX_PRICE" IS '净价';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."PRICE_UNIT" IS '价格单位';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."PRICE" IS '单价';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."AMOUNT" IS '金额';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."CURRENCY" IS '币别';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."VOUCHER_DATE" IS '凭证日期';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."DELIVERY_DATE" IS '交货日期';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."APPLY_DATE" IS '申请日期';

COMMENT ON COLUMN  "T_BASE_PUR_ORDER_CHANGE"."STATUS" IS '状态:new为新的变更申请、close为更改订单';
