/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.web.controller.project;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.Assert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u9879\u76ee")
@Controller
@RequestMapping(value={"project"})
public class ProjectController {
    @Resource
    protected ProjectService projectService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u9879\u76ee")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Project project) {
        this.projectService.addObj(project);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u9879\u76ee")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Project project) {
        Assert.isNotBlank(project.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "material_id_is_not_null");
        this.projectService.modifyObj(project);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u9879\u76ee")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.projectService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u9879\u76ee")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Project>> findByPage(@ApiParam(value="\u5206\u9875\u7d22\u5f15", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String sSearch) {
        ProjectExample example = new ProjectExample();
        example.setPageView(new PageView<Project>(pageNo, pageSize));
        if (StringUtils.isNotBlank((String)sSearch)) {
            // empty if block
        }
        PageView pageData = this.projectService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

