/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryPackage;
import com.els.base.purchase.service.DeliveryOrderService;
import com.els.base.purchase.service.DeliveryPackageService;
import com.els.base.purchase.utils.DeliveryStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u9001\u8d27\u5305\u88c5")
@Controller
@RequestMapping(value={"deliveryPackage"})
public class DeliveryPackageController {
    @Resource
    protected DeliveryPackageService deliveryPackageService;
    @Resource
    protected DeliveryOrderService deliveryOrderService;

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u6216\u8005\u4fee\u6539\u9001\u8d27\u5305\u88c5:\u5165\u53c2\uff1a\u5bf9\u8c61\u6570\u7ec4\uff08\u5bf9\u8c61\u5b57\u6bb5\u53c2\u8003DeliveryPackage\uff09")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<DeliveryPackage> deliveryPackageList) {
        if (CollectionUtils.isEmpty(deliveryPackageList)) {
            throw new CommonException("\u63d0\u4ea4\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58");
        }
        DeliveryOrder deliveryOrder = (DeliveryOrder)this.deliveryOrderService.queryObjById(deliveryPackageList.get(0).getDeliveryOrderId());
        if (!DeliveryStatusEnum.UN_SENT.getValue().equals(deliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u53ea\u80fd\u672a\u53d1\u8d27\u7684\u5355\u636e\u624d\u80fd\u88ab\u4fee\u6539");
        }
        Company company = CompanyUtils.currentCompany();
        for (DeliveryPackage deliveryPackage : deliveryPackageList) {
            deliveryPackage.setProjectId(ProjectUtils.getProjectId());
            deliveryPackage.setCompanyId(company.getId());
            deliveryPackage.setCompanyCode(company.getCompanyCode());
            deliveryPackage.setCompanyName(company.getCompanyName());
            deliveryPackage.setUserId(SpringSecurityUtils.getLoginUserId());
            deliveryPackage.setUserName(SpringSecurityUtils.getLoginUserName());
        }
        this.deliveryPackageService.save(deliveryPackageList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u9001\u8d27\u5355\u884cId\u67e5\u8be2\u9001\u8d27\u5305\u88c5\uff1a\u5165\u53c2\uff1a\u9001\u8d27\u5355\u884cId")
    @RequestMapping(value={"service/findByDeliveryOrderItemId"})
    @ResponseBody
    public ResponseResult<List<DeliveryPackage>> findByDeliveryOrderItemId(@ApiParam(value="\u9001\u8d27\u5355\u884cId") @RequestParam(required=true) String deliveryOrderItemId) {
        if (StringUtils.isBlank((String)deliveryOrderItemId)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        return ResponseResult.success(this.deliveryPackageService.queryByDeliveryOrderItemId(deliveryOrderItemId));
    }
}

