/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.mould.notice.entity.MouldNoticeMaterial;
import com.els.base.mould.notice.entity.MouldNoticeMaterialExample;
import com.els.base.mould.notice.service.MouldNoticeMaterialService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8d44\u4ea7\u7ba1\u7406-\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355-\u7269\u6599\u4fe1\u606f")
@Controller
@RequestMapping(value={"mouldNoticeMaterial"})
public class MouldNoticeMaterialController {
    @Resource
    protected MouldNoticeMaterialService mouldNoticeMaterialService;

    @Transactional
    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8d44\u4ea7\u7ba1\u7406-\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355-\u7269\u6599\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<MouldNoticeMaterial> data) {
        if (CollectionUtils.isEmpty(data)) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u7269\u6599\u4fe1\u606f!");
        }
        for (MouldNoticeMaterial material : data) {
            Assert.isNotBlank(material.getId(), "id\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u6570\u636e");
            this.mouldNoticeMaterialService.modifyObj(material);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u4ea7\u7ba1\u7406-\u5f00\u6a21\u53d8\u66f4\u901a\u77e5\u5355-\u7269\u6599\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldNoticeMaterial", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MouldNoticeMaterial>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldNoticeMaterialExample example = new MouldNoticeMaterialExample();
        example.setPageView(new PageView<MouldNoticeMaterial>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.mouldNoticeMaterialService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

