/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.material.dao.SupplierMaterialMapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.entity.SupplierMaterialExample;
import com.els.base.material.service.MaterialCodeService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.service.SupplierMaterialService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="supplierMaterialService")
public class SupplierMaterialServiceImpl
implements SupplierMaterialService {
    @Resource
    private SupplierMaterialMapper supplierMaterialMapper;
    @Resource
    private MaterialService materialService;
    @Resource
    private CompanyService companyService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    protected MaterialCodeService materialCodeService;

    @Override
    @CacheEvict(value={"supplierMaterial"}, allEntries=true)
    public void addObj(SupplierMaterial t) {
        this.check(t);
        SupplierMaterialExample example = new SupplierMaterialExample();
        example.createCriteria().andCompanyIdEqualTo(t.getCompanyId()).andSupplierCodeEqualTo(t.getSupplierCode()).andCompanySapCodeEqualTo(t.getCompanySapCode()).andMaterialCodeEqualTo(t.getMaterialCode()).andMaterialVersionEqualTo(t.getMaterialVersion());
        if (this.supplierMaterialMapper.countByExample(example) > 0) {
            throw new CommonException("\u5f53\u524d\u5ba2\u6237\u7269\u6599\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u7ef4\u62a4.", "base_is_exists", "\u5f53\u524d\u5ba2\u6237\u7269\u6599\u7f16\u7801");
        }
        t = this.updatePurCompanyInfo(t.getMaterialCode(), t);
        t = this.setDefaultValue(t);
        this.supplierMaterialMapper.insertSelective(t);
    }

    private SupplierMaterial setDefaultValue(SupplierMaterial t) {
        BigDecimal height = t.getHeight() == null ? BigDecimal.ZERO : t.getHeight();
        BigDecimal width = t.getWidth() == null ? BigDecimal.ZERO : t.getWidth();
        BigDecimal length = t.getLength() == null ? BigDecimal.ZERO : t.getLength();
        BigDecimal netWeight = t.getNetWeight() == null ? BigDecimal.ZERO : t.getNetWeight();
        BigDecimal grossWeight = t.getGrossWeight() == null ? BigDecimal.ZERO : t.getGrossWeight();
        t.setHeight(height);
        t.setWidth(width);
        t.setLength(length);
        t.setNetWeight(netWeight);
        t.setGrossWeight(grossWeight);
        return t;
    }

    private SupplierMaterial updatePurCompanyInfo(String materialCode, SupplierMaterial t) {
        Material material = this.getMaterialId(materialCode);
        t.setMaterialId(material.getId());
        t.setMaterialDesc(material.getDescription());
        t.setMatreialName(material.getMaterialName());
        Company purCompany = (Company)this.companyService.queryObjById(material.getCompanyId());
        t.setPurCompanyName(purCompany.getCompanyFullName());
        t.setPurCompanyId(purCompany.getId());
        t.setPurCompanyCode(purCompany.getCompanyCode());
        return t;
    }

    private Material getMaterialId(String materialCode) {
        MaterialExample example = new MaterialExample();
        example.createCriteria().andMaterialCodeEqualTo(materialCode);
        List materialList = this.materialService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(materialList)) {
            throw new CommonException("\u7269\u6599\u4e3b\u6570\u636e\u4e2d\u6ca1\u6709\u627e\u5230\u7269\u6599\u53f7\u4e3a" + materialCode + "\u7684\u7269\u6599", "do_not_exists", "\u7269\u6599\u53f7\u4e3a" + materialCode + "\u7684\u7269\u6599");
        }
        return (Material)materialList.get(0);
    }

    @Override
    @CacheEvict(value={"supplierMaterial"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supplierMaterialMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"supplierMaterial"}, allEntries=true)
    public void modifyObj(SupplierMaterial t) {
        this.check(t);
        SupplierMaterialExample example = new SupplierMaterialExample();
        example.createCriteria().andCompanyIdEqualTo(t.getCompanyId()).andSupplierCodeEqualTo(t.getSupplierCode()).andCompanySapCodeEqualTo(t.getCompanySapCode()).andMaterialCodeEqualTo(t.getMaterialCode()).andMaterialVersionEqualTo(t.getMaterialVersion()).andIdNotEqualTo(t.getId());
        if (this.supplierMaterialMapper.countByExample(example) > 0) {
            throw new CommonException("\u5f53\u524d\u5ba2\u6237\u7269\u6599\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u7ef4\u62a4.", "base_is_exists", "\u5f53\u524d\u5ba2\u6237\u7269\u6599\u7f16\u7801");
        }
        t = this.updatePurCompanyInfo(t.getMaterialCode(), t);
        t = this.setDefaultValue(t);
        this.supplierMaterialMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"supplierMaterial"}, keyGenerator="redisKeyGenerator")
    public SupplierMaterial queryObjById(String id) {
        return this.supplierMaterialMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"supplierMaterial"}, keyGenerator="redisKeyGenerator")
    public List<SupplierMaterial> queryAllObjByExample(SupplierMaterialExample example) {
        return this.supplierMaterialMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"supplierMaterial"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierMaterial> queryObjByPage(SupplierMaterialExample example) {
        PageView<SupplierMaterial> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierMaterialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"supplierMaterial"}, allEntries=true)
    public void importSupplierMaterial(List<SupplierMaterial> list, String projectId, String companyId, String userName) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (SupplierMaterial supplierMaterial : list) {
            this.check(supplierMaterial);
            Company purCompany = this.checkPurCompanyCodeIsExits(supplierMaterial.getPurCompanyCode());
            Company superCompany = this.checkSupplierCodeIsExits(companyId, purCompany.getId(), supplierMaterial.getSupplierCode());
            Material m = this.getMaterialId(supplierMaterial.getMaterialCode());
            SupplierMaterialExample example = new SupplierMaterialExample();
            example.createCriteria().andCompanyIdEqualTo(superCompany.getId()).andSupplierCodeEqualTo(superCompany.getCompanyCode()).andCompanySapCodeEqualTo(supplierMaterial.getCompanySapCode()).andMaterialCodeEqualTo(supplierMaterial.getMaterialCode()).andMaterialVersionEqualTo(supplierMaterial.getMaterialVersion());
            List<SupplierMaterial> supplierMaterialList = this.supplierMaterialMapper.selectByExample(example);
            supplierMaterial.setPurCompanyId(purCompany.getId());
            supplierMaterial.setPurCompanyCode(purCompany.getCompanyCode());
            supplierMaterial.setPurCompanyName(purCompany.getCompanyFullName());
            supplierMaterial.setCompanyId(superCompany.getId());
            supplierMaterial.setSupplierCode(superCompany.getCompanyCode());
            supplierMaterial.setProjectId(projectId);
            supplierMaterial.setCompanyId(companyId);
            supplierMaterial.setMaterialId(m.getId());
            supplierMaterial.setMaterialDesc(m.getDescription());
            supplierMaterial.setMaterialCode(m.getMaterialCode());
            supplierMaterial.setLastUpdateTime(new Date());
            supplierMaterial.setLastUpdateUser(userName);
            if (CollectionUtils.isEmpty(supplierMaterialList)) {
                supplierMaterial.setCreateTime(new Date());
                supplierMaterial.setCreateUser(userName);
                this.supplierMaterialMapper.insertSelective(supplierMaterial);
                continue;
            }
            supplierMaterial.setId(supplierMaterialList.get(0).getId());
            this.supplierMaterialMapper.updateByPrimaryKeySelective(supplierMaterial);
        }
    }

    private Company checkPurCompanyCodeIsExits(String purCompanyCode) {
        if (StringUtils.isBlank((String)purCompanyCode)) {
            throw new CommonException("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5bf9\u5ba2\u6237\u7f16\u7801\u662f\u5426\u586b\u5bf9\uff0c\u8c22\u8c22\uff01");
        }
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyCodeEqualTo(purCompanyCode);
        List list = this.companyService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u5ba2\u6237\u7f16\u7801\u662f\u5426\u586b\u5bf9\uff0c\u8c22\u8c22\uff01");
        }
        Company company = (Company)list.get(0);
        return company;
    }

    private Company checkSupplierCodeIsExits(String companyId, String purCompanyId, String superCompanyCode) {
        if (StringUtils.isBlank((String)superCompanyCode)) {
            throw new CommonException("\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5bf9\u4f9b\u5e94\u5546SRM\u7f16\u7801\u662f\u5426\u586b\u5bf9\uff0c\u8c22\u8c22\uff01");
        }
        Company superCompany = (Company)this.companyService.queryObjById(companyId);
        if (!superCompanyCode.equals(superCompany.getCompanyCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0e\u767b\u9646\u4eba\u7684\u516c\u53f8SRM\u7f16\u7801\u4e0d\u4e00\u81f4\uff0c\u4e0d\u53ef\u5bfc\u5165\uff0c\u8c22\u8c22\uff01");
        }
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyCodeEqualTo(superCompanyCode);
        List<Company> list = this.companyService.queryAllSupplerCompanies(purCompanyId, example);
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u8d35\u53f8\u5f53\u524d\u4e0d\u662f\u534e\u9633\u901a\u7528\u7535\u5b50\u6709\u9650\u516c\u53f8\u7684\u5408\u6cd5\u4f9b\u5e94\u5546\uff0c\u4e0d\u53ef\u5bfc\u5165\uff0c\u8c22\u8c22\uff01");
        }
        for (Company company : list) {
            if (!company.getCompanyCode().equals(superCompanyCode)) continue;
            return company;
        }
        return null;
    }

    private void check(SupplierMaterial supplierMaterial) {
        String errMsg;
        DicGroupItem dicGroupItem;
        if (StringUtils.isBlank((String)supplierMaterial.getCompanySapCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)supplierMaterial.getMaterialCode())) {
            throw new CommonException("\u5ba2\u6237\u7269\u6599\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)supplierMaterial.getSupplierMaterial())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7269\u6599\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)supplierMaterial.getMaterialVersion())) {
            throw new CommonException("\u534e\u9633\u7269\u6599\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (supplierMaterial.getMaterialVersion().length() > 2) {
            throw new CommonException("\u534e\u9633\u7269\u6599\u7248\u672c\u53ea\u80fd\u662f2\u4e2a\u5b57\u7b26\u957f\u5ea6\uff0c\u8bf7\u66f4\u6b63\u540e\u91cd\u65b0\u8f93\u5165\uff0c\u8c22\u8c22\uff01");
        }
        if (SupplierMaterialServiceImpl.isContainChinese(supplierMaterial.getMaterialVersion()).booleanValue()) {
            throw new CommonException("\u534e\u9633\u7269\u6599\u7f16\u7801\u53ea\u80fd\u662f2\u4e2a\u5b57\u7b26\u957f\u5ea6\uff0c\u4e14\u4e0d\u53ef\u662f\u4e2d\u6587\uff0c\u8bf7\u66f4\u6b63\u540e\u91cd\u65b0\u8f93\u5165\uff0c\u8c22\u8c22\uff01");
        }
        if (StringUtils.isBlank((String)supplierMaterial.getBrand())) {
            throw new CommonException("\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)supplierMaterial.getProductArea())) {
            throw new CommonException("\u4ea7\u5730\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (supplierMaterial.getSupplierMaterial().matches("\\s*(\\S+\\s+)+\\S+\\s*")) {
            throw new CommonException("\u7269\u6599\u7f16\u7801\u4e2d\uff0c\u4e0d\u80fd\u6709\u7a7a\u683c\uff0c\u5efa\u8bae\u7528\u4e0b\u5212\u7ebf\u66ff\u4ee3\u3002");
        }
        if (StringUtils.isBlank((String)supplierMaterial.getPrintSize())) {
            throw new CommonException("\u4e8c\u7ef4\u7801\u6253\u5370\u89c4\u683c\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8c22\u8c22\uff01");
        }
        if (!"70*45".equals(supplierMaterial.getPrintSize()) && !"80*80".equals(supplierMaterial.getPrintSize())) {
            throw new CommonException("\u4e8c\u7ef4\u7801\u6253\u5370\u89c4\u683c\u53ea\u80fd\u662f70*45\u621680*80\uff0c\u8bf7\u66f4\u6b63\uff0c\u8c22\u8c22\uff01");
        }
        if (StringUtils.isNotBlank((String)supplierMaterial.getMsdRank())) {
            dicGroupItem = this.dicGroupItemService.queryItems("msdRank", supplierMaterial.getMsdRank());
            errMsg = String.format("MSL\u7b49\u7ea7[%s],\u5728\u7cfb\u7edf\u5b57\u5178\u7ec4\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u518d\u5bfc\u5165\uff0c\u8c22\u8c22\uff01", supplierMaterial.getMsdRank());
            Assert.isNotNull(dicGroupItem, errMsg);
        }
        if (StringUtils.isNotBlank((String)supplierMaterial.getEsdRank())) {
            dicGroupItem = this.dicGroupItemService.queryItems("esdRank", supplierMaterial.getEsdRank());
            errMsg = String.format("ESD\u7b49\u7ea7[%s],\u5728\u7cfb\u7edf\u5b57\u5178\u7ec4\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u518d\u5bfc\u5165\uff0c\u8c22\u8c22\uff01", supplierMaterial.getEsdRank());
            Assert.isNotNull(dicGroupItem, errMsg);
        }
    }

    public static Boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        if (m.find()) {
            return true;
        }
        return false;
    }
}

