/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.delivery;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.delivery.CreateCommand;
import com.els.base.purchase.command.order.ModifyOrderItemForDeliveryCmd;
import com.els.base.purchase.entity.DeliveryOrder;
import com.els.base.purchase.entity.DeliveryOrderItem;
import com.els.base.purchase.entity.DeliveryOrderItemExample;
import com.els.base.purchase.entity.DeliveryPackage;
import com.els.base.purchase.entity.DeliveryPackageExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.DeliveryStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ModifyCommand
extends AbstractOrderCommand<String> {
    protected DeliveryOrder deliveryOrder;

    public ModifyCommand(DeliveryOrder deliveryOrder) {
        this.deliveryOrder = deliveryOrder;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        DeliveryOrder prevousDeliveryOrder = (DeliveryOrder)this.context.getDeliveryOrderService().queryObjById(this.deliveryOrder.getId());
        this.valid(prevousDeliveryOrder, this.deliveryOrder);
        List<DeliveryOrderItem> deliveryOrderItemList = context.getDeliveryOrderItemService().queryByDeliveryOrderId(this.deliveryOrder.getId());
        deliveryOrderItemList.stream().forEach(item -> {
            ModifyOrderItemForDeliveryCmd cmd = new ModifyOrderItemForDeliveryCmd(item.getPurOrderItemId(), "DO_DELETE", item.getDeliveryQuantity());
            this.context.invoke(cmd);
        });
        context.getDeliveryOrderService().deleteObjById(this.deliveryOrder.getId());
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderIdEqualTo(this.deliveryOrder.getId());
        context.getDeliveryOrderItemService().deleteByExample(example);
        DeliveryPackageExample deliveryPackageExample = new DeliveryPackageExample();
        deliveryPackageExample.createCriteria().andDeliveryOrderIdEqualTo(this.deliveryOrder.getId());
        context.getDeliveryPackageService().deleteByExample(deliveryPackageExample);
        CreateCommand command = new CreateCommand(this.deliveryOrder);
        return context.invoke(command);
    }

    private void modifyPurOrderByDeliveryOrder(DeliveryOrder deliveryOrder) {
        DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
        deliveryOrderItemExample.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrder.getId());
        List<DeliveryOrderItem> prevousItems = this.context.getDeliveryOrderItemService().queryAllObjByExample(deliveryOrderItemExample);
        this.modifyExistedPurOrder(this.getExistItems(prevousItems, deliveryOrder.getItems()));
        this.modifyNewPurOrderItem(this.getNewItems(prevousItems, deliveryOrder.getItems()));
        this.deleteOldPurOrderItem(this.getDeleteItems(prevousItems, deliveryOrder.getItems()));
    }

    private List<DeliveryOrderItem> getDeleteItems(List<DeliveryOrderItem> prevousItems, List<DeliveryOrderItem> currentItems) {
        ArrayList<String> currentItemIdss = new ArrayList<String>(prevousItems.size());
        for (DeliveryOrderItem item : currentItems) {
            currentItemIdss.add(item.getPurOrderItemId());
        }
        ArrayList<DeliveryOrderItem> deleteItemList = new ArrayList<DeliveryOrderItem>();
        for (DeliveryOrderItem item : prevousItems) {
            String purOrderItemId = item.getPurOrderItemId();
            if (currentItemIdss.contains(purOrderItemId)) continue;
            deleteItemList.add(item);
        }
        return deleteItemList;
    }

    private List<DeliveryOrderItem> getNewItems(List<DeliveryOrderItem> prevousItems, List<DeliveryOrderItem> currentItems) {
        if (CollectionUtils.isEmpty(currentItems)) {
            return null;
        }
        if (CollectionUtils.isEmpty(prevousItems)) {
            return currentItems;
        }
        ArrayList<String> prevousItemIds = new ArrayList<String>(prevousItems.size());
        for (DeliveryOrderItem item : prevousItems) {
            prevousItemIds.add(item.getPurOrderItemId());
        }
        ArrayList<DeliveryOrderItem> newItemList = new ArrayList<DeliveryOrderItem>();
        for (DeliveryOrderItem item : currentItems) {
            String purOrderItemId = item.getPurOrderItemId();
            if (purOrderItemId != null && prevousItemIds.contains(purOrderItemId)) continue;
            newItemList.add(item);
        }
        return newItemList;
    }

    private List<DeliveryOrderItem> getExistItems(List<DeliveryOrderItem> prevousItems, List<DeliveryOrderItem> currentItems) {
        if (CollectionUtils.isEmpty(currentItems)) {
            return null;
        }
        if (CollectionUtils.isEmpty(prevousItems)) {
            return null;
        }
        ArrayList<String> prevousItemIds = new ArrayList<String>(prevousItems.size());
        for (DeliveryOrderItem item : prevousItems) {
            prevousItemIds.add(item.getPurOrderItemId());
        }
        ArrayList<DeliveryOrderItem> existList = new ArrayList<DeliveryOrderItem>();
        for (DeliveryOrderItem item : currentItems) {
            String purOrderItemId = item.getPurOrderItemId();
            if (purOrderItemId == null || !prevousItemIds.contains(purOrderItemId)) continue;
            existList.add(item);
        }
        return existList;
    }

    private void deleteOldPurOrderItem(List<DeliveryOrderItem> itemsDelted) {
        if (CollectionUtils.isEmpty(itemsDelted)) {
            return;
        }
        for (DeliveryOrderItem item : itemsDelted) {
            ModifyOrderItemForDeliveryCmd cmd = new ModifyOrderItemForDeliveryCmd(item.getPurOrderItemId(), "DO_DELETE", item.getDeliveryQuantity());
            this.context.invoke(cmd);
        }
    }

    private void modifyNewPurOrderItem(List<DeliveryOrderItem> itemsNew) {
        if (CollectionUtils.isEmpty(itemsNew)) {
            return;
        }
        for (DeliveryOrderItem item : itemsNew) {
            ModifyOrderItemForDeliveryCmd cmd = new ModifyOrderItemForDeliveryCmd(item.getPurOrderItemId(), "DO_ADD", item.getDeliveryQuantity());
            this.context.invoke(cmd);
        }
    }

    private void modifyExistedPurOrder(List<DeliveryOrderItem> existList) {
        if (CollectionUtils.isEmpty(existList)) {
            return;
        }
        for (DeliveryOrderItem currentItem : existList) {
            DeliveryOrderItem prevouse = null;
            if (StringUtils.isNotBlank((String)currentItem.getId())) {
                prevouse = (DeliveryOrderItem)this.context.getDeliveryOrderItemService().queryObjById(currentItem.getId());
            } else if (StringUtils.isNotBlank((String)currentItem.getPurOrderNo()) && StringUtils.isNotBlank((String)currentItem.getPurOrderItemNo())) {
                prevouse = this.getPrevousDeliveryItem(this.deliveryOrder.getId(), currentItem.getPurOrderNo(), currentItem.getPurOrderItemNo());
            } else {
                throw new CommonException("\u4fee\u6539\u7684\u65e7\u9001\u8d27\u5355\u884c\u6570\u636e\u4e0d\u5168");
            }
            Assert.isNotBlank(currentItem.getId(), "\u6570\u636e\u5df2\u7ecf\u88ab\u6539\u52a8\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            String purchaseOrderItemId = currentItem.getPurOrderItemId();
            SupplierOrderItem item = (SupplierOrderItem)this.context.getSupplierOrderItemService().queryObjById(purchaseOrderItemId);
            BigDecimal changQuantity = null;
            BigDecimal canDeliveryQuantity = null;
            changQuantity = currentItem.getDeliveryQuantity().subtract(prevouse.getDeliveryQuantity());
            canDeliveryQuantity = item.getDeliveryAmount().add(prevouse.getDeliveryQuantity());
            if (currentItem.getDeliveryQuantity().compareTo(canDeliveryQuantity) > 0) {
                throw new CommonException("\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u53d1\u8d27\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01", "delivery_gt_candelivery", "\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01");
            }
            ModifyOrderItemForDeliveryCmd cmd = new ModifyOrderItemForDeliveryCmd(purchaseOrderItemId, "DO_MODIFY", changQuantity);
            this.context.invoke(cmd);
        }
    }

    private DeliveryOrderItem getPrevousDeliveryItem(String deliveryOrderId, String purOrderNo, String purOrderItemNo) {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrderId).andPurOrderNoEqualTo(purOrderNo).andPurOrderItemNoEqualTo(purOrderItemNo);
        List list = this.context.getDeliveryOrderItemService().queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return (DeliveryOrderItem)list.get(0);
    }

    private void filtePackageList(DeliveryOrderItem deliveryOrderItem) {
        if (CollectionUtils.isEmpty(deliveryOrderItem.getDeliveryPackageLists())) {
            return;
        }
        ArrayList<DeliveryPackage> removedPackageList = new ArrayList<DeliveryPackage>();
        for (DeliveryPackage deliveryPackage2 : deliveryOrderItem.getDeliveryPackageLists()) {
            deliveryPackage2.setUserId(this.deliveryOrder.getUserId());
            deliveryPackage2.setUserName(this.deliveryOrder.getUserName());
            deliveryPackage2.setProjectId(this.deliveryOrder.getProjectId());
            deliveryPackage2.setCompanyId(this.deliveryOrder.getCompanyId());
            deliveryPackage2.setDeliveryOrderId(this.deliveryOrder.getId());
            deliveryPackage2.setDeliveryOrderNo(this.deliveryOrder.getDeliveryOrderNo());
            deliveryPackage2.setDeliveryOrderItemId(deliveryOrderItem.getId());
            deliveryPackage2.setDeliveryOrderItemNo(deliveryOrderItem.getDeliveryOrderItemNo());
            deliveryPackage2.setCompanyCode(this.deliveryOrder.getCompanyCode());
            deliveryPackage2.setCompanyName(this.deliveryOrder.getCompanyName());
            deliveryPackage2.setMaterialId(deliveryOrderItem.getMaterialId());
            deliveryPackage2.setMaterialNo(deliveryOrderItem.getMaterialNo());
            deliveryPackage2.setMaterialDesc(deliveryOrderItem.getMaterialDesc());
            if (deliveryPackage2.getTotalQuantity() != null && deliveryPackage2.getTotalQuantity() != 0) continue;
            removedPackageList.add(deliveryPackage2);
        }
        deliveryOrderItem.getDeliveryPackageLists().removeAll(removedPackageList);
        if (CollectionUtils.isNotEmpty(deliveryOrderItem.getDeliveryPackageLists())) {
            deliveryOrderItem.setPackQuantity(String.valueOf(deliveryOrderItem.getDeliveryPackageLists().size()));
        }
    }

    private void init(DeliveryOrder deliveryOrder) {
        HashSet<String> purOrderNoList = new HashSet<String>();
        int deliveryOrderItemNo = 1;
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            purOrderNoList.add(deliveryOrderItem.getPurOrderNo());
            deliveryOrderItem.setType(deliveryOrder.getType());
            deliveryOrderItem.setDeliveryOrderItemNo(String.valueOf(deliveryOrderItemNo++));
            deliveryOrderItem.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
            deliveryOrderItem.setDeliveryOrderId(deliveryOrder.getId());
            deliveryOrderItem.setProjectId(deliveryOrder.getProjectId());
            deliveryOrderItem.setCompanyId(deliveryOrder.getCompanyId());
            deliveryOrderItem.setUserId(deliveryOrder.getUserId());
            deliveryOrderItem.setUserName(deliveryOrder.getUserName());
            if (!StringUtils.isBlank((String)deliveryOrderItem.getPackQuantity())) continue;
            deliveryOrderItem.setPackQuantity("0");
        }
        String purOrderNoStr = StringUtils.join(purOrderNoList, (String)",");
        if (StringUtils.isNotBlank((String)purOrderNoStr) && purOrderNoStr.getBytes().length > 1000) {
            throw new CommonException("\u9001\u8d27\u5355\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u5355\u5173\u8054\u8fc7\u591a\u7684\u91c7\u8d2d\u8ba2\u5355\u53f7\uff0c\u6700\u591a100\u4e2a\u4e0d\u540c\u7684\u7684\u91c7\u8d2d\u8ba2\u5355");
        }
        deliveryOrder.setPurchaseOrderNo(purOrderNoStr);
        deliveryOrder.setLastUpdateTime(new Date());
        if (this.getSupUser() != null) {
            deliveryOrder.setLastUpdateUser(this.getSupUser().getId());
        }
    }

    protected void valid(DeliveryOrder prevousDeliveryOrder, DeliveryOrder deliveryOrder) {
        Assert.isNotNull(deliveryOrder, "\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(deliveryOrder.getItems(), "\u884c\u6570\u636e\u4e0d\u5b58\u5728");
        if (DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(prevousDeliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u9001\u8d27\u5355\u5df2\u7ecf\u6536\u8d27\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (DeliveryStatusEnum.ONWAY.getValue().equals(prevousDeliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u9001\u8d27\u5355\u5df2\u7ecf\u53d1\u8d27\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (deliveryOrder.getInvoiceNo() != null && deliveryOrder.getInvoiceNo().length() > 255 || deliveryOrder.getDriverName() != null && deliveryOrder.getDriverName().length() > 255 || deliveryOrder.getIdCard() != null && deliveryOrder.getIdCard().length() > 255 || deliveryOrder.getCar() != null && deliveryOrder.getCar().length() > 255) {
            throw new CommonException("\u9001\u8d27\u5355\u5934\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            Assert.isNotBlank(deliveryOrderItem.getPurOrderItemId(), "\u53c2\u6570\u5f02\u5e38\uff0c\u9001\u8d27\u5355\u884c\u4e2d\uff0c\u7f3a\u5c11\u91c7\u8d2d\u8ba2\u5355\u884cid");
            if (deliveryOrderItem.getChineseName() != null && deliveryOrderItem.getChineseName().length() > 255 || deliveryOrderItem.getRemark() != null && deliveryOrderItem.getRemark().length() > 255 || deliveryOrderItem.getBrand() != null && deliveryOrderItem.getBrand().length() > 255 || deliveryOrderItem.getSourceArea() != null && deliveryOrderItem.getSourceArea().length() > 255 || deliveryOrderItem.getModel() != null && deliveryOrderItem.getModel().length() > 255 || deliveryOrderItem.getCaseNo() != null && deliveryOrderItem.getCaseNo().length() > 30) {
                throw new CommonException("\u9001\u8d27\u5355\u884c\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
            }
            if (deliveryOrderItem.getDeliveryQuantity().compareTo(deliveryOrderItem.getCanDeliveryQuantity()) < 1) continue;
            throw new CommonException("\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u53d1\u8d27\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01", "delivery_gt_candelivery", "\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01");
        }
    }
}

