/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.mould.notice.dao.MouldNoticeItemMapper;
import com.els.base.mould.notice.entity.MouldNoticeItem;
import com.els.base.mould.notice.entity.MouldNoticeItemExample;
import com.els.base.mould.notice.service.MouldNoticeItemService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultMouldNoticeItemService")
public class MouldNoticeItemServiceImpl
implements MouldNoticeItemService {
    @Resource
    protected MouldNoticeItemMapper mouldNoticeItemMapper;

    @Override
    @CacheEvict(value={"mouldNoticeItem"}, allEntries=true)
    public void addObj(MouldNoticeItem t) {
        this.mouldNoticeItemMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"mouldNoticeItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldNoticeItemMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"mouldNoticeItem"}, allEntries=true)
    public void modifyObj(MouldNoticeItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mouldNoticeItemMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"mouldNoticeItem"}, keyGenerator="redisKeyGenerator")
    public MouldNoticeItem queryObjById(String id) {
        return this.mouldNoticeItemMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"mouldNoticeItem"}, keyGenerator="redisKeyGenerator")
    public List<MouldNoticeItem> queryAllObjByExample(MouldNoticeItemExample example) {
        return this.mouldNoticeItemMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"mouldNoticeItem"}, keyGenerator="redisKeyGenerator")
    public PageView<MouldNoticeItem> queryObjByPage(MouldNoticeItemExample example) {
        PageView<MouldNoticeItem> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldNoticeItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"mouldNoticeItem"}, allEntries=true)
    public void deleteByNoticeId(String noticeId) {
        MouldNoticeItemExample example = new MouldNoticeItemExample();
        example.createCriteria().andMouldNoticeIdEqualTo(noticeId);
        this.mouldNoticeItemMapper.deleteByExample(example);
    }
}

