/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.CreateOrderCommand;
import com.els.base.purchase.command.order.ModifyOrderCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.utils.PurchaseOrderItemChangeStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ImportOrderCommand
extends AbstractOrderCommand<String> {
    private List<PurchaseOrder> orderList;

    public ImportOrderCommand(List<PurchaseOrder> orderList) {
        this.orderList = orderList;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        Assert.isNotEmpty(this.orderList, "\u5bfc\u5165\u7684\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        for (PurchaseOrder order : this.orderList) {
            AbstractOrderCommand command = null;
            if (!this.isOrderExist(order)) {
                command = new CreateOrderCommand(order);
            } else {
                this.initOrder(order);
                command = new ModifyOrderCommand(order);
                ((ModifyOrderCommand)command).setCause("\u5bfc\u5165\u53d8\u66f4\u7684\u8ba2\u5355");
            }
            command.copyProperties(this);
            context.invoke(command);
        }
        return null;
    }

    private void cleanOrderItem(PurchaseOrderItem item) {
        item.setOnwayQuantity(null);
        item.setReceivedQuantity(null);
        item.setFreezeQuantity(null);
    }

    private void initOrder(PurchaseOrder purchaseOrder) {
        this.initOrderItem(purchaseOrder);
        purchaseOrder.setOrderStatus(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
        purchaseOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue());
        if (purchaseOrder.getDeliveryStatus() == null) {
            purchaseOrder.setDeliveryStatus(PurchaseOrderUtils.isAllItemFinish(purchaseOrder.getItems()));
        }
        if (purchaseOrder.getIsEnable() == null) {
            purchaseOrder.setIsEnable(PurchaseOrderUtils.isAllItemEnable(purchaseOrder.getItems()));
        }
    }

    private void initOrderItem(PurchaseOrder order) {
        if (CollectionUtils.isEmpty(order.getItems())) {
            return;
        }
        for (PurchaseOrderItem item : order.getItems()) {
            item.setOrderNo(order.getOrderNo());
            PurchaseOrderItem tmpOrderItem = this.context.getPurchaseOrderItemService().queryByOrderItemNo(item.getOrderNo(), item.getOrderItemNo());
            if (tmpOrderItem == null) continue;
            this.cleanOrderItem(item);
            item.setUpdateTime(new Date());
            item.setIsUpdated(Constant.YES_INT);
            if (tmpOrderItem.getHaveChange() == null) {
                tmpOrderItem.setHaveChange(PurchaseOrderItemChangeStatusEnum.OLD_ITEM.getValue());
            }
            BigDecimal canDeliveryQuantity = item.getQuantity().subtract(tmpOrderItem.getOnwayQuantity()).subtract(tmpOrderItem.getReceivedQuantity()).subtract(tmpOrderItem.getFreezeQuantity());
            item.setDeliveryAmount(canDeliveryQuantity);
            if ("Y".equals(item.getFinishFlag())) continue;
            if (item.getQuantity().compareTo(tmpOrderItem.getReceivedQuantity()) <= 0) {
                item.setFinishFlag("Y");
                continue;
            }
            item.setFinishFlag("N");
        }
    }

    private boolean isOrderExist(PurchaseOrder order) {
        if (StringUtils.isNotBlank((String)order.getId())) {
            return this.context.getPurchaseOrderService().queryObjById(order.getId()) != null;
        }
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.createCriteria().andOrderNoEqualTo(order.getOrderNo()).andSupCompanyIdEqualTo(order.getSupCompanyId()).andProjectIdEqualTo(order.getProjectId());
        List orderListTemp = this.context.getPurchaseOrderService().queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(orderListTemp)) {
            return false;
        }
        if (orderListTemp.size() > 1) {
            throw new CommonException(String.format("\u8ba2\u5355[%s]\u5728\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u91cd\u590d\u60c5\u51b5", order.getOrderNo()));
        }
        order.setId(((PurchaseOrder)orderListTemp.get(0)).getId());
        return true;
    }
}

