/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.utils;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.utils.SpringContextHolder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class SysUtil {
    private static final Logger logger = LoggerFactory.getLogger(SysUtil.class);

    public static String getNextLogisticsNumber() {
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String newNo = generateCodeService.getNextCode("LOGISTIC_NO_GENERATOR");
        return newNo;
    }

    public static String removeZero(String val) {
        if (StringUtils.isBlank((String)val)) {
            return val;
        }
        int len = val.length();
        int index = 0;
        char[] strs = val.toCharArray();
        for (int i = 0; i < len; ++i) {
            if ('0' == strs[i]) continue;
            index = i;
            break;
        }
        return val.substring(index, len);
    }

    public static String getNextFileName() {
        String rid = "";
        rid = "f" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd").substring(2, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd").length());
        Random random = new Random();
        int rannum = (int)(random.nextDouble() * 90000.0) + 10000;
        return rid + rannum;
    }

    public static BigDecimal getCanDeliveryAmount(BigDecimal quantity, BigDecimal onwayQuantity, BigDecimal receivedQuantity, BigDecimal freezeQuantity) {
        BigDecimal canDeliveryAmount = BigDecimal.ZERO;
        quantity = quantity == null ? BigDecimal.ZERO : quantity;
        onwayQuantity = onwayQuantity == null ? BigDecimal.ZERO : onwayQuantity;
        receivedQuantity = receivedQuantity == null ? BigDecimal.ZERO : receivedQuantity;
        freezeQuantity = freezeQuantity == null ? BigDecimal.ZERO : freezeQuantity;
        canDeliveryAmount = quantity.subtract(onwayQuantity).subtract(receivedQuantity).subtract(freezeQuantity);
        logger.info("----------quantity--------[" + quantity + "]-----onwayQuantity------[" + onwayQuantity + "]--------canDeliveryAmount----[" + canDeliveryAmount + "]-------freezeQuantity----[" + freezeQuantity + "]-----");
        return canDeliveryAmount;
    }

    public static void purhcaseTosSupplier(PurchaseOrder purchaseOrder, SupplierOrder supplierOrder) {
        BeanUtils.copyProperties((Object)purchaseOrder, (Object)supplierOrder);
        supplierOrder.setUserId(purchaseOrder.getSupUserId());
        supplierOrder.setUserName(purchaseOrder.getSupUserName());
        supplierOrder.setCompanyId(purchaseOrder.getSupCompanyId());
        supplierOrder.setCompanySapCode(purchaseOrder.getSupCompanySapCode());
        supplierOrder.setCompanyName(purchaseOrder.getSupCompanyName());
        supplierOrder.setPurUserId(purchaseOrder.getUserId());
        supplierOrder.setPurUserName(purchaseOrder.getUserName());
        supplierOrder.setPurCompanyId(purchaseOrder.getCompanyId());
        supplierOrder.setPurCompanyCode(purchaseOrder.getCompanyCode());
        supplierOrder.setPurCompanyName(purchaseOrder.getCompanyName());
        Date date = new Date();
        supplierOrder.setCreateTime(date);
        supplierOrder.setLastUpdateTime(date);
        ArrayList<SupplierOrderItem> supplierOrderItems = new ArrayList<SupplierOrderItem>();
        List<PurchaseOrderItem> purchaseOrderItems = purchaseOrder.getItems();
        for (PurchaseOrderItem purchaseOrderItem : purchaseOrderItems) {
            SupplierOrderItem supplierOrderItem = new SupplierOrderItem();
            BeanUtils.copyProperties((Object)purchaseOrderItem, (Object)supplierOrderItem);
            supplierOrderItem.setUserId(supplierOrder.getUserId());
            supplierOrderItem.setUserName(supplierOrder.getUserName());
            supplierOrderItem.setCompanyId(supplierOrder.getCompanyId());
            supplierOrderItem.setCompanyName(supplierOrder.getCompanyName());
            supplierOrderItem.setPurUserId(supplierOrder.getPurUserId());
            supplierOrderItem.setPurUserName(supplierOrder.getPurUserName());
            supplierOrderItem.setPurCompanyId(supplierOrder.getPurCompanyId());
            supplierOrderItem.setPurCompanyName(supplierOrder.getPurCompanyName());
            supplierOrderItem.setSapSupCompanyCode(supplierOrder.getCompanySapCode());
            supplierOrderItem.setUpdateTime(date);
            supplierOrderItems.add(supplierOrderItem);
        }
        supplierOrder.setItems(supplierOrderItems);
    }

    public static boolean isReturnNewRecord() {
        Properties properties = (Properties)SpringContextHolder.getBean((String)"sysConfig");
        if (properties != null) {
            String isReturnNewRecord = properties.getProperty("order.isReturnNewRecord", "true");
            return Boolean.valueOf(isReturnNewRecord);
        }
        return true;
    }
}

