/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.entity.PurchaseOrderChange;
import com.els.base.purchase.entity.PurchaseOrderChangeExample;
import com.els.base.purchase.service.PurchaseOrderChangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8ba2\u5355\u53d8\u66f4\u7533\u8bf7")
@Controller
@RequestMapping(value={"purchaseOrderChange"})
public class PurchaseOrderChangeController {
    @Resource
    protected PurchaseOrderChangeService purchaseOrderChangeService;
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8ba2\u5355\u53d8\u66f4\u7533\u8bf7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurchaseOrderChange purchaseOrderChange) {
        this.purchaseOrderChangeService.addObj(purchaseOrderChange);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8ba2\u5355\u53d8\u66f4\u7533\u8bf7")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseOrderChange purchaseOrderChange) {
        if (StringUtils.isBlank((String)purchaseOrderChange.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.purchaseOrderChangeService.modifyObj(purchaseOrderChange);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u64cd\u4f5c\u8ba2\u5355\u53d8\u66f4\u7533\u8bf7")
    @RequestMapping(value={"service/oper"})
    @ResponseBody
    public ResponseResult<String> oper(@RequestBody List<PurchaseOrderChange> purchaseOrderChange) {
        this.purchaseOrderChangeService.importFromSap(purchaseOrderChange);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8ba2\u5355\u53d8\u66f4\u7533\u8bf7")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.purchaseOrderChangeService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u53d8\u66f4\u7533\u8bf7(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderChange", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderChange>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), null);
        if (CollectionUtils.isEmpty(companyList)) {
            throw new CommonException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5206\u914d\u4f9b\u5e94\u5546");
        }
        ArrayList<String> companyCodeList = new ArrayList<String>();
        for (Company company : companyList) {
            if (!StringUtils.isNotBlank((String)company.getCompanySapCode())) continue;
            companyCodeList.add(company.getCompanySapCode());
        }
        ArrayList<String> confirmStatus = new ArrayList<String>();
        confirmStatus.add("0");
        confirmStatus.add("1");
        confirmStatus.add("2");
        PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
        PurchaseOrderChangeExample.Criteria criteria = example.createCriteria().andCompanySapCodeIn(companyCodeList).andProjectIdEqualTo(ProjectUtils.getProjectId()).andConfirmStatusIn(confirmStatus).andStatusNotEqualTo("CLOSE");
        example.setPageView(new PageView<PurchaseOrderChange>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.purchaseOrderChangeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u53d8\u66f4\u7533\u8bf7\u786e\u8ba4")
    @RequestMapping(value={"service/supplierChangeApplyConfirm"})
    @ResponseBody
    public ResponseResult<String> supplierChangeApplyConfirm(@RequestBody List<PurchaseOrderChange> purchaseOrderChangeList) {
        if (CollectionUtils.isEmpty(purchaseOrderChangeList)) {
            throw new CommonException("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e");
        }
        for (int i = 0; i < purchaseOrderChangeList.size(); ++i) {
            String id = purchaseOrderChangeList.get(i).getId();
            PurchaseOrderChange queryObjById = (PurchaseOrderChange)this.purchaseOrderChangeService.queryObjById(id);
            if (queryObjById == null || !queryObjById.getConfirmStatus().equals("2")) continue;
            throw new CommonException("\u8be5\u53d8\u66f4\u7533\u8bf7\u5df2\u518d\u6b21\u53d1\u9001\uff0c\u6b64\u6b21\u64cd\u4f5c\u7684\u6570\u636e\u4e3a\u65e7\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u786e\u8ba4\u7684\u6570\u636e\u3002", "old_data", "\u8be5\u53d8\u66f4\u7533\u8bf7\u5df2\u518d\u6b21\u53d1\u9001\uff0c");
        }
        for (PurchaseOrderChange purchaseOrderChange : purchaseOrderChangeList) {
            if (purchaseOrderChange.getRemark() != null && purchaseOrderChange.getRemark().length() > 255) {
                throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
            }
            purchaseOrderChange.setConfirmStatus("1");
            this.purchaseOrderChangeService.modifyObj(purchaseOrderChange);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u53d8\u66f4\u7533\u8bf7(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderChange", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findChangeOrderOfSupplier"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderChange>> findChangeOrderOfSupplier(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        Company currentCompany = CompanyUtils.currentCompany();
        PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
        ArrayList<String> confirmStatus = new ArrayList<String>();
        confirmStatus.add("0");
        confirmStatus.add("1");
        confirmStatus.add("2");
        PurchaseOrderChangeExample.Criteria criteria = example.createCriteria().andCompanySapCodeEqualTo(currentCompany.getCompanySapCode()).andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andConfirmStatusIn(confirmStatus).andStatusNotEqualTo("CLOSE");
        example.setPageView(new PageView<PurchaseOrderChange>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.purchaseOrderChangeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

