/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.command.OrderComandInvoker;
import com.els.base.purchase.command.order.CreateOrderItemCommand;
import com.els.base.purchase.command.order.ModifyOrderItemCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ModifyOrderCommand
extends AbstractOrderCommand<String> {
    private PurchaseOrder order;
    private String cause = "";

    public ModifyOrderCommand(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public String execute(OrderComandInvoker context) {
        this.valid(this.order);
        this.backupOrder();
        for (int i = 0; CollectionUtils.isNotEmpty(this.order.getItems()) && i < this.order.getItems().size(); ++i) {
            PurchaseOrderItem item = this.order.getItems().get(i);
            AbstractOrderCommand orderItemCommand = null;
            orderItemCommand = StringUtils.isNotBlank((String)item.getId()) ? new ModifyOrderItemCommand(item, this.order) : new CreateOrderItemCommand(item, this.order);
            orderItemCommand.copyProperties(this);
            context.invoke(orderItemCommand);
        }
        this.clearOrder(this.order);
        this.context.getPurchaseOrderService().modifyObj(this.order);
        return null;
    }

    private void valid(PurchaseOrder order) {
        Assert.isNotNull(order, "\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkOrderExist(order);
        if (CollectionUtils.isEmpty(order.getItems())) {
            return;
        }
        for (PurchaseOrderItem orderItem : order.getItems()) {
            Assert.isNotBlank(orderItem.getOrderItemNo(), "\u8ba2\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
            orderItem.setOrderNo(order.getOrderNo());
            if (this.isExistItem(orderItem, order)) continue;
            this.validOrderItem(orderItem);
        }
    }

    private void backupOrder() {
        String orderHisId = this.context.getPurchaseOrderService().insertHis(this.order.getId(), this.getCause());
        this.context.getPurchaseOrderItemService().insertHisByOrderId(orderHisId, this.order.getId(), this.getCause());
    }

    private void validOrderItem(PurchaseOrderItem orderItem) {
        Assert.isNotBlank(orderItem.getOrderItemNo(), "\u91c7\u8d2d\u5355\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(orderItem.getIsEnable(), "\u8ba2\u5355\u884c\u662f\u5426\u53ef\u7528\u7684\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(orderItem.getMaterialCode(), "\u91c7\u8d2d\u5355\u884c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(orderItem.getQuantity(), "\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void checkOrderExist(PurchaseOrder order) {
        if (StringUtils.isBlank((String)order.getId()) && StringUtils.isBlank((String)order.getOrderNo())) {
            throw new CommonException("\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PurchaseOrder tmpOrder = null;
        if (StringUtils.isNotBlank((String)order.getId())) {
            tmpOrder = (PurchaseOrder)this.context.getPurchaseOrderService().queryObjById(order.getId());
        } else {
            String projectId = this.getPurCompany().getProjectId();
            tmpOrder = this.context.getPurchaseOrderService().queryByOrderNo(projectId, order.getOrderNo());
        }
        Assert.isNotNull(tmpOrder, String.format("\u8be5\u8ba2\u5355[%s]\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728", order.getOrderNo()));
        order.setId(tmpOrder.getId());
        order.setOrderNo(tmpOrder.getOrderNo());
    }

    private void clearOrder(PurchaseOrder order) {
        order.setProjectId(null);
        order.setOrderNo(null);
        order.setCompanyId(null);
        order.setCompanyCode(null);
        order.setCompanyName(null);
        order.setPurSapCompanyCode(null);
        order.setSupCompanyId(null);
        order.setSupCompanyName(null);
        order.setSupCompanySapCode(null);
    }

    private boolean isExistItem(PurchaseOrderItem item, PurchaseOrder order) {
        if (StringUtils.isNotBlank((String)item.getId())) {
            PurchaseOrderItem tmpItem = (PurchaseOrderItem)this.context.getPurchaseOrderItemService().queryObjById(item.getId());
            if (StringUtils.isBlank((String)tmpItem.getId()) || !tmpItem.getOrderId().equals(order.getId())) {
                throw new CommonException(String.format("\u8ba2\u5355\u884c\u6570\u636e\u5f02\u5e38\uff0c\u8ba2\u5355\u884c[%s]", item.getId()));
            }
            return true;
        }
        PurchaseOrderItem tmpItem = this.context.getPurchaseOrderItemService().queryByOrderItemNo(order.getOrderNo(), item.getOrderItemNo());
        if (tmpItem == null) {
            return false;
        }
        item.setOrderItemNo(tmpItem.getOrderItemNo());
        item.setId(tmpItem.getId());
        return true;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }
}

