/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.command;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.MouldMaterial;
import com.els.base.mould.master.vo.MouldVO;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ModifyMouldCmd
extends AbstractMouldCommand<String> {
    private MouldVO mouldVo;

    public ModifyMouldCmd(MouldVO mouldVo) {
        this.mouldVo = mouldVo;
    }

    @Override
    public String execute(MouldInvorker moudlInvorker) {
        Assert.isNotNull(this.mouldVo, "\u4f20\u9012\u7684\u6a21\u5177\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u6a21\u5177\u4fe1\u606f!");
        if (CollectionUtils.isEmpty(this.mouldVo.getMouldMaterialList())) {
            throw new CommonException("\u4f20\u9012\u7684\u6a21\u5177\u7269\u6599\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4fee\u6539\u6a21\u5177\u7269\u6599\u4fe1\u606f!");
        }
        this.verificatData(this.mouldVo);
        this.mouldVo.setUpdateTime(new Date());
        moudlInvorker.getMouldService().modifyObj(this.mouldVo);
        moudlInvorker.getMouldMaterialService().deleteByMouldId(this.mouldVo.getId());
        List<MouldMaterial> mouldMaterialList = this.mouldVo.getMouldMaterialList();
        this.completeMouldData(this.mouldVo);
        for (MouldMaterial mouldMaterial : mouldMaterialList) {
            moudlInvorker.getMouldMaterialService().addObj(mouldMaterial);
        }
        return null;
    }

    private void completeMouldData(MouldVO mouldVo) {
        for (MouldMaterial mouldMaterial : mouldVo.getMouldMaterialList()) {
            mouldMaterial.setMouldId(mouldVo.getId());
            mouldMaterial.setProjectId(ProjectUtils.getProjectId());
            mouldMaterial.setCreateTime(new Date());
        }
    }

    private void verificatData(MouldVO mouldVo) {
        Assert.isNotBlank(mouldVo.getId(), "\u6a21\u5177id\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank(mouldVo.getMouldDesc(), "\u6a21\u5177\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
        List<MouldMaterial> mouldMaterialList = mouldVo.getMouldMaterialList();
        for (MouldMaterial mouldMaterial : mouldMaterialList) {
            Assert.isNotBlank(mouldMaterial.getMaterialCode(), "\u6a21\u5177\u7269\u6599\u660e\u7ec6\u4e2d\u7684\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotBlank(mouldMaterial.getMaterialDesc(), "\u6a21\u5177\u7269\u6599\u660e\u7ec6\u4e2d\u7684\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotNull(mouldMaterial.getIsCalculated(), "\u6a21\u5177\u7269\u6599\u660e\u7ec6\u4e2d\u7684\u662f\u5426\u6838\u7b97\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

