/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.utils;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.query.QueryConditionEnum;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaUtils {
    private static final Logger logger = LoggerFactory.getLogger(CriteriaUtils.class);

    public static void addExample(IExample example, QueryParamWapper wapper) {
        if (wapper == null) {
            return;
        }
        try {
            if (CollectionUtils.isNotEmpty(wapper.getQueryParams())) {
                Object invokeMethod = ReflectUtils.invokeMethod((Object)example, (String)"getOredCriteria", null);
                List orCriterias = (List)invokeMethod;
                if (CollectionUtils.isEmpty((Collection)orCriterias)) {
                    ReflectUtils.invokeMethod((Object)example, (String)"createCriteria", null);
                    orCriterias = (List)invokeMethod;
                }
                for (int i = 0; i < orCriterias.size(); ++i) {
                    CriteriaUtils.addCriterion(orCriterias.get(i), wapper);
                }
            }
            if (StringUtils.isNotBlank((String)wapper.getOrderBy())) {
                ReflectUtils.invokeMethod((Object)example, (String)"setOrderByClause", (Object[])new Object[]{wapper.getOrderBy()});
            }
        }
        catch (Exception exception) {
            throw new CommonException("\u67e5\u8be2\u6761\u4ef6\u751f\u6210\u5931\u8d25", exception);
        }
    }

    public static <Criteria> Criteria addCriterion(Criteria criteria, QueryParamWapper wapper) {
        if (wapper == null || CollectionUtils.isEmpty(wapper.getQueryParams())) {
            return criteria;
        }
        return CriteriaUtils.addCriterion(criteria, wapper.getQueryParams());
    }

    public static <Criteria> Criteria addCriterion(Criteria criteria, List<QueryParam> queryParams) {
        Class<?> criClass = criteria.getClass();
        if (!criClass.getCanonicalName().contains("Criteria")) {
            throw new IllegalArgumentException("\u8fd9\u4e2a\u65b9\u6cd5\u53ea\u9002\u5408 Example\u7684 Criteria");
        }
        if (CollectionUtils.isEmpty(queryParams)) {
            return criteria;
        }
        for (QueryParam queryParam : queryParams) {
            if (StringUtils.isBlank((String)queryParam.getProperty())) {
                throw new CommonException("\u67e5\u8be2\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null");
            }
            if (StringUtils.isBlank((String)queryParam.getCondition())) {
                throw new CommonException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null");
            }
            Method method = CriteriaUtils.findMethod(criClass, queryParam);
            if (method == null) {
                throw new CommonException("\u67e5\u8be2\u6761\u4ef6[" + queryParam.getCriteriaMethod() + "]\u4e0d\u5b58\u5728", "do_not_exists");
            }
            try {
                criteria = CriteriaUtils.invokeCriteriaMethod(criteria, method, queryParam);
            }
            catch (Exception e) {
                String errMsg = MessageFormat.format("\u67e5\u8be2\u6761\u4ef6\u751f\u6210\u5931\u8d25:{0}", e.getMessage());
                throw new CommonException(errMsg, e);
            }
        }
        return criteria;
    }

    private static Method findMethod(Class<? extends Object> criClass, QueryParam queryParam) {
        Method[] methods;
        for (Method tempMethod : methods = criClass.getMethods()) {
            if (!tempMethod.getName().equals(queryParam.getCriteriaMethod())) continue;
            if (tempMethod.getParameterTypes().length > 1) {
                logger.warn("\u4e0d\u652f\u6301\u591a\u4e2a\u53c2\u6570\u7684criteria \u65b9\u6cd5[{}]\u8c03\u7528", (Object)tempMethod.getName());
                continue;
            }
            return tempMethod;
        }
        return null;
    }

    private static <Criteria> Criteria invokeCriteriaMethod(Criteria criteria, Method method, QueryParam queryParam) throws Exception {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes != null && paramTypes.length > 1) {
            throw new CommonException("\u67e5\u8be2\u6761\u4ef6\u4e2d\uff0c\u4e0d\u652f\u6301\u53c2\u6570\u591a\u4e8e1\u4e2a");
        }
        if (paramTypes == null || paramTypes.length == 0) {
            return (Criteria)method.invoke(criteria, new Object[0]);
        }
        if (queryParam.getValue() == null) {
            throw new CommonException("\u67e5\u8be2\u6761\u4ef6\u4e2d\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", "query_condition_cannot_be_empty");
        }
        Class<?> paramType = paramTypes[0];
        if (paramType.equals(String.class)) {
            return CriteriaUtils.invokeCriteriaMethodAsString(criteria, method, queryParam);
        }
        if (paramType.equals(List.class)) {
            return CriteriaUtils.invokeCriteriaMethodAsList(criteria, method, queryParam);
        }
        if (paramType.equals(Date.class)) {
            return CriteriaUtils.invokeCriteriaMethodAsDate(criteria, method, queryParam);
        }
        return (Criteria)method.invoke(criteria, JsonUtils.convertValue((String)queryParam.getValue(), paramType));
    }

    private static <Criteria> Criteria invokeCriteriaMethodAsDate(Criteria criteria, Method method, QueryParam queryParam) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String dateStr = queryParam.getValue();
        if (StringUtils.isBlank((String)dateStr) || !StringUtils.isNumeric((String)dateStr)) {
            throw new CommonException("\u65f6\u95f4\u53c2\u6570\u9700\u8981\u4f20\u65f6\u95f4\u6233", "query_condition_cannot_be_empty");
        }
        Date lastDate = new Date(Long.valueOf(dateStr.trim()));
        if (queryParam.getFullCondition().equals("lessThanOrEqualTo")) {
            lastDate = DateUtils.addDays((Date)lastDate, (int)1);
            lastDate = DateUtils.addSeconds((Date)lastDate, (int)-1);
        }
        return (Criteria)method.invoke(criteria, lastDate);
    }

    private static <Criteria> Criteria invokeCriteriaMethodAsList(Criteria criteria, Method method, QueryParam queryParam) throws JsonParseException, JsonMappingException, IOException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List paramList = (List)JsonUtils.convertValue((String)queryParam.getValue(), List.class);
        if (CollectionUtils.isEmpty((Collection)paramList)) {
            return criteria;
        }
        return (Criteria)method.invoke(criteria, paramList);
    }

    private static <Criteria> Criteria invokeCriteriaMethodAsString(Criteria criteria, Method method, QueryParam queryParam) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (queryParam.getValue().getBytes().length > 2000) {
            throw new CommonException("\u67e5\u8be2\u6761\u4ef6\u7684\u503c\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        String value = queryParam.getValue();
        if (queryParam.getCondition().equals(QueryConditionEnum.LIKE.getShortName()) && !value.startsWith("%") && !value.endsWith("%")) {
            value = MessageFormat.format("%{0}%", value);
        }
        return (Criteria)method.invoke(criteria, value);
    }
}

