/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.material.service.MaterialService;
import com.els.base.material.service.SupplierMaterialService;
import com.els.base.purchase.command.AbstractOrderCommand;
import com.els.base.purchase.service.DeliveryOrderItemService;
import com.els.base.purchase.service.DeliveryOrderService;
import com.els.base.purchase.service.DeliveryPackageService;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.utils.uuid.UUIDGenerator;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="orderComandInvoker")
public class OrderComandInvoker {
    private static Logger logger = LoggerFactory.getLogger(OrderComandInvoker.class);
    @Resource
    protected DeliveryOrderService deliveryOrderService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected SupplierOrderService supplierOrderService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected SupplierMaterialService supplierMaterialService;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected PurchaseOrderService purchaseOrderService;
    @Resource
    protected DeliveryPackageService deliveryPackageService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    private CompanyPurRefService companyPurRefService;

    @Transactional
    public <Result> Result invoke(AbstractOrderCommand<Result> command) {
        String key = UUIDGenerator.generateUUID();
        long t1 = System.currentTimeMillis();
        logger.info("\u5f00\u59cb\u6267\u884c\u547d\u4ee4[{}],\u547d\u4ee4Key[{}]", command.getClass(), (Object)key);
        command.setContext(this);
        Result result = command.execute(this);
        logger.info("\u7ed3\u675f\u6267\u884c\u547d\u4ee4[{}]\uff0c\u547d\u4ee4key[{}],\u8017\u65f6[{}]ms", new Object[]{command.getClass(), key, System.currentTimeMillis() - t1});
        return result;
    }

    public CompanyUserRefService getCompanyUserRefService() {
        return this.companyUserRefService;
    }

    public DeliveryOrderService getDeliveryOrderService() {
        return this.deliveryOrderService;
    }

    public SupplierOrderItemService getSupplierOrderItemService() {
        return this.supplierOrderItemService;
    }

    public PurchaseOrderItemService getPurchaseOrderItemService() {
        return this.purchaseOrderItemService;
    }

    public SupplierOrderService getSupplierOrderService() {
        return this.supplierOrderService;
    }

    public GenerateCodeService getGenerateCodeService() {
        return this.generateCodeService;
    }

    public SupplierMaterialService getSupplierMaterialService() {
        return this.supplierMaterialService;
    }

    public MaterialService getMaterialService() {
        return this.materialService;
    }

    public DeliveryOrderItemService getDeliveryOrderItemService() {
        return this.deliveryOrderItemService;
    }

    public PurchaseOrderService getPurchaseOrderService() {
        return this.purchaseOrderService;
    }

    public DeliveryPackageService getDeliveryPackageService() {
        return this.deliveryPackageService;
    }

    public CompanyPurRefService getCompanyPurRefService() {
        return this.companyPurRefService;
    }
}

