/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.entity;

import com.els.base.core.utils.ResponseCode;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

@ApiModel(value="\u54cd\u5e94\u4fe1\u606f")
public class ResponseResult<T>
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(ResponseResult.class);
    private static final long serialVersionUID = 6382523290069620956L;
    @ApiModelProperty(value="\u54cd\u5e94\u7801\uff0c\u8868\u793a\u8bf7\u6c42\u7684\u72b6\u6001\u3002200\u8868\u793a\u6210\u529f\uff0c\u5176\u4ed6\u8868\u793a\u5931\u8d25")
    private String code;
    @ApiModelProperty(value="\u54cd\u5e94\u63cf\u8ff0")
    private String msg;
    @ApiModelProperty(value="\u8fd4\u56de\u6570\u636e")
    private T data;
    @JsonIgnore
    @ApiModelProperty(value="\u56fd\u9645\u5316\u4ee3\u7801")
    private String i18nCode;
    @JsonIgnore
    @ApiModelProperty(value="\u56fd\u9645\u5316\u8f93\u5165\u53c2\u6570")
    private Object[] i18nArgs;

    public ResponseResult() {
    }

    public ResponseResult(String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public ResponseResult<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        if (StringUtils.isBlank((String)this.getI18nCode())) {
            return this.msg;
        }
        Locale locale = LocaleContextHolder.getLocale();
        if (locale == null) {
            return this.msg;
        }
        String i18nMsg = null;
        try {
            i18nMsg = SpringContextHolder.getApplicationContext().getMessage(this.i18nCode, this.getI18nArgs(), locale);
        }
        catch (Exception e) {
            logger.warn("get i18n msg for code[" + this.i18nCode + "] failed");
        }
        return StringUtils.isBlank((String)i18nMsg) || this.getI18nCode().equals(i18nMsg) ? this.msg : i18nMsg;
    }

    public ResponseResult<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public ResponseResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String getI18nCode() {
        return this.i18nCode;
    }

    public Object[] getI18nArgs() {
        return this.i18nArgs;
    }

    public void setI18nArgs(Object[] i18nArgs) {
        this.i18nArgs = i18nArgs;
    }

    public ResponseResult<T> setI18nCode(String i18nCode) {
        this.i18nCode = i18nCode;
        return this;
    }

    public static ResponseResult<String> success() {
        return ResponseResult.success("");
    }

    public static <T> ResponseResult<T> success(T data) {
        return new ResponseResult<T>().setCode(ResponseCode.Success.getCode()).setI18nCode(ResponseCode.Success.getKey()).setMsg(ResponseCode.Success.getMsg()).setData(data);
    }

    public static ResponseResult<String> fail(ResponseCode code) {
        return ResponseResult.fail(code, "");
    }

    public static <T> ResponseResult<T> fail(ResponseCode code, T data) {
        return new ResponseResult<T>().setCode(code.getCode()).setI18nCode(code.getKey()).setMsg(code.getMsg()).setData(data);
    }
}

