/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyPlanReceiveQuantityCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    public static Logger logger = LoggerFactory.getLogger(ModifyPlanReceiveQuantityCmd.class);
    private String planItemId;
    private BigDecimal quantity;

    public ModifyPlanReceiveQuantityCmd(String planItemId, BigDecimal quantity) {
        Assert.isNotBlank((String)planItemId, (String)"\u9001\u8d27\u901a\u77e5\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)quantity, (String)"\u9001\u8d27\u901a\u77e5\u5230\u7684\u64cd\u4f5c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        this.planItemId = planItemId;
        this.quantity = quantity;
    }

    @Override
    public String execute(ICommandInvoker context) {
        logger.info("EVENT=\u4fee\u6539\u8ba2\u5355\u7684\u6536\u8d27\u8d27\u6570|orderItemId={}|\u53d8\u66f4\u6570\u91cf={}", (Object)this.planItemId, (Object)this.quantity);
        PurDeliveryPlanItem purPlanItem = (PurDeliveryPlanItem)ContextUtils.getPurDeliveryPlanItemService().queryObjById(this.planItemId);
        Assert.isNotNull((Object)purPlanItem, (String)"\u9001\u8d27\u901a\u77e5\u5355\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        SupDeliveryPlanItem supPlanItem = (SupDeliveryPlanItem)ContextUtils.getSupDeliveryPlanItemService().queryObjById(this.planItemId);
        Assert.isNotNull((Object)purPlanItem, (String)"\u9001\u8d27\u901a\u77e5\u5355\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        this.subtractQuantity(purPlanItem, supPlanItem, this.quantity);
        return null;
    }

    private void subtractQuantity(PurDeliveryPlanItem purPlanItem, SupDeliveryPlanItem supPlanItem, BigDecimal quantity) {
        ContextUtils.getPurDeliveryPlanItemService().addReceiveQuantity(purPlanItem.getId(), quantity);
        ContextUtils.getSupDeliveryPlanItemService().addReceiveQuantity(supPlanItem.getId(), quantity);
    }

    private Integer getIsCanDelivery(SupDeliveryPlanItem supPlanItem, BigDecimal supCanDeliveryQuantity) {
        Integer isCanDelivery = null;
        if (supPlanItem.getIsJit().equals(Constant.YES_INT) && DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue().equals(supPlanItem.getUsedStatus())) {
            return null;
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) >= 0 && Constant.YES_INT.equals(supPlanItem.getIsCanDelivery())) {
            isCanDelivery = Constant.NO_INT;
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) < 0 && Constant.NO_INT.equals(supPlanItem.getIsCanDelivery())) {
            isCanDelivery = Constant.YES_INT;
        }
        logger.info(String.format("EVENT=\u53d8\u66f4\u9001\u8d27\u901a\u77e5\u5355\u53ef\u53d1\u8d27\u6807\u8bb0|ID=%s|orderNo=%s|orderItemNo=%s|\u662f\u5426\u53ef\u53d1\u8d27=%d", supPlanItem.getId(), supPlanItem.getPurOrderNo(), supPlanItem.getPurOrderItemNo(), isCanDelivery));
        return isCanDelivery;
    }

    private String getUsedStatus(SupDeliveryPlanItem supPlanItem, BigDecimal supCanDeliveryQuantity) {
        String usedStatus = null;
        if (supPlanItem.getIsJit().equals(Constant.YES_INT) && DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue().equals(supPlanItem.getUsedStatus())) {
            return null;
        }
        if (supCanDeliveryQuantity.compareTo(supPlanItem.getDeliveryQuantity()) == 0 && !DeliveryPlanUesdStatusEnum.UN_USED.getValue().equals(supPlanItem.getUsedStatus())) {
            usedStatus = DeliveryPlanUesdStatusEnum.UN_USED.getValue();
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) >= 0 && !DeliveryPlanUesdStatusEnum.ALL_USED.getValue().equals(supPlanItem.getUsedStatus())) {
            usedStatus = DeliveryPlanUesdStatusEnum.ALL_USED.getValue();
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) < 0 && supCanDeliveryQuantity.compareTo(supPlanItem.getDeliveryQuantity()) < 0 && !DeliveryPlanUesdStatusEnum.PART_USED.getValue().equals(supPlanItem.getUsedStatus())) {
            usedStatus = DeliveryPlanUesdStatusEnum.PART_USED.getValue();
        }
        logger.info(String.format("EVENT=\u53d8\u66f4\u9001\u8d27\u901a\u77e5\u5355\u662f\u5426\u53d1\u8d27\u6807\u8bb0|ID=%s|orderNo=%s|orderItemNo=%s|\u662f\u5426\u5df2\u53d1\u8d27\u72b6\u6001=%s", supPlanItem.getId(), supPlanItem.getPurOrderNo(), supPlanItem.getPurOrderItemNo(), usedStatus));
        return usedStatus;
    }

    private void updatePlanItem(String planItemId, Integer isCanDelivery) {
        PurDeliveryPlanItem tempPurPlanItem = new PurDeliveryPlanItem();
        tempPurPlanItem.setId(planItemId);
        tempPurPlanItem.setIsCanDelivery(isCanDelivery);
        ContextUtils.getPurDeliveryPlanItemService().modifyObj(tempPurPlanItem);
        SupDeliveryPlanItem tempSupPlanItem = new SupDeliveryPlanItem();
        tempSupPlanItem.setId(planItemId);
        tempSupPlanItem.setIsCanDelivery(isCanDelivery);
        ContextUtils.getSupDeliveryPlanItemService().modifyObj(tempSupPlanItem);
    }
}

