/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.plan.dao.JITDemandMergeMapper;
import com.els.base.plan.entity.JITDemandMerge;
import com.els.base.plan.entity.JITDemandMergeExample;
import com.els.base.plan.service.JITDemandMergeService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultJITDemandMergeService")
public class JITDemandMergeServiceImpl
implements JITDemandMergeService {
    @Resource
    protected JITDemandMergeMapper jITDemandMergeMapper;

    @CacheEvict(value={"jITDemandMerge"}, allEntries=true)
    public void addObj(JITDemandMerge t) {
        this.jITDemandMergeMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"jITDemandMerge"}, allEntries=true)
    public void addAll(List<JITDemandMerge> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        System.err.println(list.toString());
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.jITDemandMergeMapper.insertBatch(list);
    }

    @CacheEvict(value={"jITDemandMerge"}, allEntries=true)
    public void deleteObjById(String id) {
        this.jITDemandMergeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"jITDemandMerge"}, allEntries=true)
    public void modifyObj(JITDemandMerge t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.jITDemandMergeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"jITDemandMerge"}, keyGenerator="redisKeyGenerator")
    public JITDemandMerge queryObjById(String id) {
        return this.jITDemandMergeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"jITDemandMerge"}, keyGenerator="redisKeyGenerator")
    public List<JITDemandMerge> queryAllObjByExample(JITDemandMergeExample example) {
        return this.jITDemandMergeMapper.selectByExample(example);
    }

    @Cacheable(value={"jITDemandMerge"}, keyGenerator="redisKeyGenerator")
    public PageView<JITDemandMerge> queryObjByPage(JITDemandMergeExample example) {
        PageView<JITDemandMerge> pageView = example.getPageView();
        pageView.setQueryResult(this.jITDemandMergeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"jITDemandMerge"}, allEntries=true)
    public void deleteObjByExample(JITDemandMergeExample example) {
        this.jITDemandMergeMapper.deleteByExample(example);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"jITDemandMerge"}, allEntries=true)
    public void modifyObjByList(List<JITDemandMerge> lists) {
        JITDemandMergeExample example = new JITDemandMergeExample();
        example.createCriteria().andFactoryCodeEqualTo(lists.get(0).getFactoryCode());
        this.jITDemandMergeMapper.deleteByExample(example);
        this.addAll(lists);
    }

    @CacheEvict(value={"jITDemandMerge"}, allEntries=true)
    public void deleteByExample(JITDemandMergeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.jITDemandMergeMapper.deleteByExample(example);
    }
}

