/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.bom;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.entity.PurOrderItemBom;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CreatePurBomCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrder order;

    public CreatePurBomCommand(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Assert.isNotNull((Object)this.order, (String)"\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty(this.order.getBomList())) {
            return null;
        }
        this.valid(this.order);
        List<PurchaseOrderItem> items = this.order.getItems();
        for (PurOrderItemBom bom : this.order.getBomList()) {
            bom.setOrderId(this.order.getId());
            PurchaseOrderItem purOrderItem = items.stream().filter(item -> item.getOrderNo().equals(bom.getOrderNo()) && item.getOrderItemNo().equals(bom.getOrderItemNo())).findAny().orElse(null);
            if (purOrderItem == null) continue;
            bom.setOrderItemId(purOrderItem.getId());
            bom.setMaterialCode(StringUtils.defaultIfBlank((String)bom.getMaterialCode(), (String)purOrderItem.getMaterialCode()));
            bom.setMaterialDesc(StringUtils.defaultIfBlank((String)bom.getMaterialDesc(), (String)purOrderItem.getMaterialName()));
        }
        ContextUtils.getPurOrderItemBomService().addAll(this.order.getBomList());
        return null;
    }

    private void valid(PurchaseOrder order) {
        Assert.isNotBlank((String)order.getId(), (String)"\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        order.getBomList().forEach(bom -> {
            Assert.isNotBlank((String)bom.getOrderNo(), (String)"bom\u4e2d\u7684\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)bom.getOrderItemNo(), (String)"\u8ba2\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }
}

