/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.change;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderChange;
import com.els.base.purchase.entity.PurchaseOrderChangeExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class BatchCreateChangeCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private String orderId;
    private List<PurchaseOrderChange> changeList;

    public BatchCreateChangeCmd(String id) {
        this.orderId = id;
    }

    public BatchCreateChangeCmd(String id, List<PurchaseOrderChange> changeList) {
        this.changeList = changeList;
        this.orderId = id;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Assert.isNotBlank((String)this.orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty(this.changeList)) {
            return null;
        }
        PurchaseOrder order = (PurchaseOrder)ContextUtils.getPurchaseOrderService().queryObjById(this.orderId);
        if (PurchaseOrderSendStatusEnum.NOTSEND.getValue().equals(order.getOrderSendStatus())) {
            return null;
        }
        List<SupplierOrderItem> supItemList = ContextUtils.getSupplierOrderItemService().queryByOrderIdList(Arrays.asList(this.orderId));
        if (CollectionUtils.isEmpty(supItemList)) {
            return null;
        }
        this.deleteChange(this.orderId);
        ContextUtils.getPurchaseOrderChangeService().addAll(this.changeList);
        return null;
    }

    private void deleteChange(String orderId) {
        PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
        example.createCriteria().andOrderIdEqualTo(orderId);
        ContextUtils.getPurchaseOrderChangeService().deleteByExample(example);
    }
}

