/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.plan.command.nonejit.pur.NoneJitPlanCreateCmd;
import com.els.base.plan.command.nonejit.pur.NoneJitPlanResetCmd;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.purchase.command.order.UpdateReceiveQuantityCommand;
import com.els.base.purchase.command.order.pur.CreateOrderCommand;
import com.els.base.purchase.command.order.pur.IsAllOrderItemHandledCommand;
import com.els.base.purchase.command.order.pur.ModifyOrderCommand;
import com.els.base.purchase.command.order.pur.SendOrderCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ImportOrderCommand
extends AbstractCommand<List<PurchaseOrder>> {
    private static final long serialVersionUID = 1L;
    private List<PurchaseOrder> orderList;

    public ImportOrderCommand(List<PurchaseOrder> orderList) {
        this.orderList = orderList;
    }

    @Override
    public List<PurchaseOrder> execute(ICommandInvoker context) {
        Assert.isNotEmpty(this.orderList, (String)"\u5bfc\u5165\u7684\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<PurchaseOrder> newOrderList = new ArrayList<PurchaseOrder>(this.orderList.size());
        for (PurchaseOrder order : this.orderList) {
            AbstractCommand createDeliveryPlanCmd;
            UpdateReceiveQuantityCommand updateReceiveQuantityCommand;
            AbstractCommand command;
            PurchaseOrder existOrder = this.queryExistOrder(order);
            if (existOrder == null) {
                command = new CreateOrderCommand(order);
                command.copyProperties(this);
                order = context.invoke(command);
                updateReceiveQuantityCommand = new UpdateReceiveQuantityCommand(order.getItems());
                context.invoke(updateReceiveQuantityCommand);
                if (!"Y".equals(order.getReturnFlag())) {
                    createDeliveryPlanCmd = new NoneJitPlanCreateCmd(order);
                    createDeliveryPlanCmd.copyProperties(this);
                    context.invoke(createDeliveryPlanCmd);
                }
                this.sendToSup(order);
            } else {
                order.setId(existOrder.getId());
                command = new ModifyOrderCommand(order);
                ((ModifyOrderCommand)command).setCause("\u5bfc\u5165\u53d8\u66f4\u7684\u8ba2\u5355");
                command.copyProperties(this);
                order = (PurchaseOrder)context.invoke(command);
                updateReceiveQuantityCommand = new UpdateReceiveQuantityCommand(order.getItems());
                context.invoke(updateReceiveQuantityCommand);
                if (!"Y".equals(order.getReturnFlag())) {
                    createDeliveryPlanCmd = new NoneJitPlanResetCmd(order);
                    createDeliveryPlanCmd.copyProperties(this);
                    context.invoke(createDeliveryPlanCmd);
                    if (!existOrder.getPurPlanerId().equals(order.getPurPlanerId())) {
                        this.updatePlaner(order);
                    }
                }
                if (this.isAllHandled(order.getId())) {
                    this.sendToSup(order);
                }
            }
            newOrderList.add(order);
        }
        return newOrderList;
    }

    private void updatePlaner(PurchaseOrder order) {
        PurDeliveryPlanItemExample purDeliveryPlanItemExample = new PurDeliveryPlanItemExample();
        purDeliveryPlanItemExample.createCriteria().andPurOrderIdEqualTo(order.getId());
        PurDeliveryPlanItem planItem = new PurDeliveryPlanItem();
        planItem.setPurPlanerId(order.getPurPlanerId());
        planItem.setPurUserId(order.getPurPlanerId());
        planItem.setPurUserName(order.getPurPlanerName());
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(planItem, purDeliveryPlanItemExample);
        SupDeliveryPlanItemExample supDeliveryPlanItemExample = new SupDeliveryPlanItemExample();
        supDeliveryPlanItemExample.createCriteria().andPurOrderIdEqualTo(order.getId());
        SupDeliveryPlanItem supPlanItem = new SupDeliveryPlanItem();
        supPlanItem.setPurPlanerId(order.getPurPlanerId());
        supPlanItem.setPurUserId(order.getPurPlanerId());
        supPlanItem.setPurUserName(order.getPurPlanerName());
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(supPlanItem, supDeliveryPlanItemExample);
    }

    private boolean isAllHandled(String orderId) {
        IsAllOrderItemHandledCommand allOrderItemHandledCommand = new IsAllOrderItemHandledCommand(orderId);
        allOrderItemHandledCommand.copyProperties(this);
        boolean isAllHandled = this.context.invoke(allOrderItemHandledCommand);
        return isAllHandled;
    }

    private void sendToSup(PurchaseOrder order) {
        SendOrderCommand sendOrderCommand = new SendOrderCommand(order);
        sendOrderCommand.copyProperties(this);
        this.context.invoke(sendOrderCommand);
    }

    private PurchaseOrder queryExistOrder(PurchaseOrder order) {
        if (StringUtils.isNotBlank((String)order.getId())) {
            return (PurchaseOrder)ContextUtils.getPurchaseOrderService().queryObjById(order.getId());
        }
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.createCriteria().andOrderNoEqualTo(order.getOrderNo()).andSupCompanyIdEqualTo(order.getSupCompanyId()).andProjectIdEqualTo(order.getProjectId());
        List orderListTemp = ContextUtils.getPurchaseOrderService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)orderListTemp)) {
            return null;
        }
        if (orderListTemp.size() > 1) {
            throw new CommonException(String.format("\u8ba2\u5355[%s]\u5728\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u91cd\u590d\u60c5\u51b5", order.getOrderNo()));
        }
        return (PurchaseOrder)orderListTemp.get(0);
    }
}

