/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.utils.PurchaseOrderUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class NoneJitPlanCreateCmd
extends AbstractCommand<List<PurDeliveryPlanItem>> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrder order;

    public NoneJitPlanCreateCmd(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public List<PurDeliveryPlanItem> execute(ICommandInvoker context) {
        this.valid(this.order);
        if ("Y".equals(this.order.getReturnFlag())) {
            return null;
        }
        List<PurDeliveryPlanItem> planItemList = this.order.getItems().stream().filter(item -> Constant.YES_INT.equals(item.getIsEnable()) && "N".equals(item.getFinishFlag()) && !Constant.YES_INT.equals(item.getIsJit()) && !"Y".equals(item.getReturnFlag()) && (StringUtils.isBlank((String)item.getOrderNoType()) || !PurchaseOrderUtils.ORDER_TYPE_OEM.contains(item.getOrderNoType()))).map(orderItem -> DeliveryPlanUtils.buildPlanItem(orderItem, this.order)).collect(Collectors.toList());
        ContextUtils.getPurDeliveryPlanItemService().addAll(planItemList);
        return planItemList;
    }

    private void valid(PurchaseOrder order) {
        Assert.isNotNull((Object)order, (String)"\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(order.getItems(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        for (PurchaseOrderItem item : order.getItems()) {
            Assert.isNotBlank((String)item.getId(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)item.getDeliveredDate(), (String)"\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getFactory(), (String)"\u8ba2\u5355\u884c\u5de5\u5382\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)item.getQuantity());
        }
    }
}

