/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.command.nonejit.sup.NoneJitPlanSendToPurCmd;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.plan.utils.PlanDataSourceEnum;
import com.els.base.purchase.command.log.CreateOperationLogCommand;
import com.els.base.purchase.command.order.pur.IsAllOrderItemHandledCommand;
import com.els.base.purchase.command.order.pur.SendOrderCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.IsRefuseStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderChangeUtils;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderOperationTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ConfirmOrderItemPriceCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<String> orderItemIdList;

    public ConfirmOrderItemPriceCommand(List<String> orderItemIdList) {
        this.orderItemIdList = orderItemIdList;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Assert.isNotEmpty(this.orderItemIdList, (String)"\u8ba2\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.orderItemIdList = this.orderItemIdList.stream().distinct().collect(Collectors.toList());
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andIdIn((List)this.orderItemIdList);
        List purOrderItemList = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        for (PurchaseOrderItem purchaseOrderItem : purOrderItemList) {
            if (Constant.YES_INT.equals(purchaseOrderItem.getIsRefusePrice())) continue;
            throw new CommonException(String.format("\u8ba2\u5355\u884c [%s][%s]\u6ca1\u6709\u62d2\u7edd\u4ef7\u683c\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u6682\u4f30\u4ef7", purchaseOrderItem.getOrderNo(), purchaseOrderItem.getOrderItemNo()));
        }
        Map orderIdAndOrderItemListMap = purOrderItemList.stream().collect(Collectors.groupingBy(PurchaseOrderItem::getOrderId, Collectors.toList()));
        for (String orderId : orderIdAndOrderItemListMap.keySet()) {
            List<PurchaseOrderItem> itemList = orderIdAndOrderItemListMap.get(orderId);
            this.confirmOrderItem(itemList);
            if (!this.isAllItemNoRefuse(orderId)) continue;
            this.confirmOrRefuseOrder(orderId);
            SendOrderCommand command = new SendOrderCommand(orderId);
            command.copyProperties(this);
            context.invoke(command);
        }
        CreateOperationLogCommand createOperationLogCommand = new CreateOperationLogCommand(PurchaseOrderOperationTypeEnum.CONFIRM_TEMP_PRICE);
        createOperationLogCommand.setPurOrderItemList(purOrderItemList);
        createOperationLogCommand.copyProperties(this);
        this.context.invoke(createOperationLogCommand);
        return null;
    }

    private void confirmOrRefuseOrder(String orderId) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderIdEqualTo(orderId).andOrderStatusNotEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        List itemList = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        PurchaseOrder purOrder = new PurchaseOrder();
        purOrder.setId(orderId);
        purOrder.setPurUserId(this.getPurUser().getId());
        purOrder.setPurUserName(this.getPurUser().getNickName());
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            purOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        } else {
            purOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        }
        ContextUtils.getPurchaseOrderService().modifyObj(purOrder);
    }

    private void confirmOrder(String orderId) {
        PurchaseOrder purOrder = new PurchaseOrder();
        purOrder.setId(orderId);
        purOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        purOrder.setPurUserId(this.getPurUser().getId());
        purOrder.setPurUserName(this.getPurUser().getNickName());
        ContextUtils.getPurchaseOrderService().modifyObj(purOrder);
        SendOrderCommand command = new SendOrderCommand(orderId);
        command.copyProperties(this);
        this.context.invoke(command);
    }

    private void sendOrderToSup(String orderId) {
        PurchaseOrder purOrder = new PurchaseOrder();
        purOrder.setId(orderId);
        purOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue());
        purOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        purOrder.setPurUserId(this.getPurUser().getId());
        purOrder.setPurUserName(this.getPurUser().getNickName());
        ContextUtils.getPurchaseOrderService().modifyObj(purOrder);
        SupplierOrder supplierOrder = new SupplierOrder();
        supplierOrder.setId(orderId);
        supplierOrder.setOrderSendStatus(purOrder.getOrderSendStatus());
        supplierOrder.setOrderStatus(purOrder.getOrderStatus());
        supplierOrder.setPurUserId(this.getPurUser().getId());
        supplierOrder.setPurUserName(this.getPurUser().getNickName());
        ContextUtils.getSupplierOrderService().modifyObj(supplierOrder);
        SendOrderCommand command = new SendOrderCommand(orderId);
        command.copyProperties(this);
        this.context.invoke(command);
    }

    private void confirmOrderItem(List<PurchaseOrderItem> itemList) {
        for (PurchaseOrderItem purchaseOrderItem : itemList) {
            PurchaseOrderItem temp = new PurchaseOrderItem();
            temp.setId(purchaseOrderItem.getId());
            temp.setIsOfficialPrice(Constant.NO_INT);
            temp.setIsRefusePrice(IsRefuseStatusEnum.NO_REFUSE.getValue());
            if (IsRefuseStatusEnum.REFUSE.getValue().equals(purchaseOrderItem.getIsRefuseDeliveredDate()) || IsRefuseStatusEnum.REFUSE.getValue().equals(purchaseOrderItem.getIsRefuseQuantity())) {
                temp.setOrderStatus(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
            } else {
                temp.setOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
                this.confirmPlan(purchaseOrderItem);
            }
            ContextUtils.getPurchaseOrderItemService().modifyObj(temp);
        }
        List changeList = itemList.stream().map(item -> {
            SupplierOrderItem supItem = new SupplierOrderItem();
            supItem.setIsOfficialPrice(Constant.YES_INT);
            item.setIsOfficialPrice(Constant.NO_INT);
            return PurchaseOrderChangeUtils.buildChangeForIsOfficialPrice(item, supItem);
        }).collect(Collectors.toList());
        ContextUtils.getPurchaseOrderChangeService().addAll(changeList);
    }

    private void confirmPlan(PurchaseOrderItem purchaseOrderItem) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPurOrderItemIdEqualTo(purchaseOrderItem.getId()).andIsJitEqualTo(Constant.NO_INT).andIsCanDeliveryEqualTo(Constant.YES_INT).andSupConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        List list = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (SupDeliveryPlanItem supDeliveryPlanItem : list) {
            supDeliveryPlanItem.setChangeStatus(PlanChangeStatusEnum.SUP_CONFIRM.getValue());
        }
        NoneJitPlanSendToPurCmd command = new NoneJitPlanSendToPurCmd(list, PlanDataSourceEnum.UI);
        command.copyProperties(command);
        User supUser = new User();
        supUser.setId(purchaseOrderItem.getSupUserId());
        supUser.setNickName(purchaseOrderItem.getSupUserName());
        command.setSupUser(supUser);
        this.context.invoke(command);
    }

    private boolean isAllItemNoRefuse(String orderId) {
        IsAllOrderItemHandledCommand command = new IsAllOrderItemHandledCommand(orderId);
        command.copyProperties(this);
        return this.context.invoke(command);
    }
}

