/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.IsRefuseStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderChangeUtils;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;

public class ModifyOrderItemCommand
extends AbstractCommand<PurchaseOrderItem> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrderItem item;
    private SupplierOrderItem supItem;

    public ModifyOrderItemCommand(PurchaseOrderItem item, SupplierOrderItem supItem) {
        this.item = item;
        this.supItem = supItem;
    }

    @Override
    public PurchaseOrderItem execute(ICommandInvoker context) {
        this.valid();
        this.initOrderItem(this.item);
        this.clearOrderItem(this.item);
        this.item.setIsUpdated(Constant.YES_INT);
        ContextUtils.getPurchaseOrderItemService().modifyObj(this.item);
        return (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(this.item.getId());
    }

    private void valid() {
        Assert.isNotBlank((String)this.item.getId(), (String)"\u91c7\u8d2d\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void initOrderItem(PurchaseOrderItem newItem) {
        newItem.setUpdateTime(new Date());
        if (this.supItem == null) {
            newItem.setHaveChange(ChangeTypeEnum.ADD_ITEM.getValue());
        } else if (CollectionUtils.isNotEmpty(PurchaseOrderChangeUtils.compareItemForMainProperty(newItem, this.supItem))) {
            newItem.setHaveChange(ChangeTypeEnum.MODIFY_ITEM.getValue());
            newItem.setIsUpdated(Constant.YES_INT);
        } else {
            newItem.setHaveChange(ChangeTypeEnum.OLD_ITEM.getValue());
        }
        PurchaseOrderItem curOrderItem = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(newItem.getId());
        if (ChangeTypeEnum.MODIFY_ITEM.getValue().equals(newItem.getHaveChange())) {
            newItem.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            newItem.setIsRefuseDeliveredDate(IsRefuseStatusEnum.NO_REFUSE.getValue());
            newItem.setIsRefusePrice(IsRefuseStatusEnum.NO_REFUSE.getValue());
            newItem.setIsRefuseQuantity(IsRefuseStatusEnum.NO_REFUSE.getValue());
        }
        if (newItem.getTaxTotalPrice() != null) {
            newItem.setAvailableApplyMoney(newItem.getTaxTotalPrice().subtract(curOrderItem.getAlreadyApplyMoney()));
        }
        newItem.setFreezeQuantity(curOrderItem.getFreezeQuantity());
        if (Constant.NO_INT.equals(newItem.getIsEnable()) || "Y".equals(newItem.getFinishFlag()) || "Y".equals(newItem.getReturnFlag()) || BigDecimal.ZERO.compareTo(newItem.getCanDeliveryQuantity()) >= 0) {
            newItem.setIsCanDelivery(Constant.NO_INT);
        }
    }

    private void clearOrderItem(PurchaseOrderItem item) {
        item.setProjectId(null);
        item.setPurCompanyId(null);
        item.setPurCompanyName(null);
        item.setPurCompanySrmCode(null);
        item.setPurCompanySapCode(null);
        item.setSupCompanySapCode(null);
        item.setSupCompanyId(null);
        item.setSupCompanyName(null);
        item.setOrderNo(null);
        item.setOrderId(null);
    }
}

