/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.dao.DeliveryOrderMapper;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.service.DeliveryPackageService;
import com.els.base.material.entity.SupplierMaterial;
import com.els.base.material.utils.MaterailUtils;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryOrderService")
public class DeliveryOrderServiceImpl
implements DeliveryOrderService {
    @Resource
    protected DeliveryOrderMapper deliveryOrderMapper;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected DeliveryPackageService deliveryPackageService;

    @CacheEvict(value={"deliveryOrder", "deliveryOrderItem"}, allEntries=true)
    public void addObj(DeliveryOrder deliveryOrder) {
        this.deliveryOrderMapper.insertSelective(deliveryOrder);
    }

    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void modifyObj(DeliveryOrder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.deliveryOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public DeliveryOrder queryObjById(String id) {
        return this.deliveryOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrder> queryAllObjByExample(DeliveryOrderExample example) {
        return this.deliveryOrderMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrder> queryObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"deliveryOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrder> queryHisObjByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    public PageView<DeliveryOrder> queryDeliveryOrderByPage(DeliveryOrderExample example) {
        PageView<DeliveryOrder> pageView = example.getPageView();
        pageView = this.queryObjByPage(example);
        if (CollectionUtils.isEmpty((Collection)pageView.getQueryResult())) {
            return new PageView(1, pageView.getPageSize());
        }
        for (DeliveryOrder deliveryOrder : pageView.getQueryResult()) {
            List<DeliveryOrderItem> itemList = this.deliveryOrderItemService.queryByDeliveryOrderId(deliveryOrder.getId());
            if (CollectionUtils.isEmpty(itemList)) continue;
            deliveryOrder.setItems(itemList);
        }
        return pageView;
    }

    private void setSupplierMaterialCode(DeliveryOrderItem deliveryOrderItem) {
        SupplierMaterial supplierMaterial = MaterailUtils.querySupplierMaterial((String)deliveryOrderItem.getCompanyId(), (String)deliveryOrderItem.getCompanyCode(), (String)deliveryOrderItem.getMaterialNo(), null);
        if (supplierMaterial == null) {
            return;
        }
        deliveryOrderItem.setSupplierMaterialName(supplierMaterial.getSupplierMaterialDesc());
        deliveryOrderItem.setSupplierMaterialNumber(supplierMaterial.getSupplierMaterial());
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    @Transactional
    public void modifyAndAddHis(DeliveryOrder deliveryOrder, String string) {
        Assert.isNotNull((Object)deliveryOrder, (String)"\u9001\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)deliveryOrder.getId(), (String)"\u9001\u8d27\u5355id\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Date date = new Date();
        this.deliveryOrderMapper.insertHis(UUIDGenerator.generateUUID(), deliveryOrder.getId(), "\u53d1\u9001\u53d1\u8d27\u5355", date);
        this.modifyObj(deliveryOrder);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    @Transactional
    public void deleteAndAddHis(String deliveryOrderId, String string) {
        Assert.isNotBlank((String)deliveryOrderId, (String)"\u9001\u8d27\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Date date = new Date();
        this.deliveryOrderMapper.insertHis(UUIDGenerator.generateUUID(), deliveryOrderId, "\u53d1\u9001\u53d1\u8d27\u5355", date);
        this.deliveryOrderMapper.deleteByPrimaryKey(deliveryOrderId);
    }

    @Override
    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void modifyByExample(DeliveryOrder deliveryOrder, DeliveryOrderExample example) {
        this.deliveryOrderMapper.updateByExampleSelective(deliveryOrder, example);
    }

    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void deleteByExample(DeliveryOrderExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deliveryOrderMapper.deleteByExample(example);
    }

    @CacheEvict(value={"deliveryOrder"}, allEntries=true)
    public void addAll(List<DeliveryOrder> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.deliveryOrderMapper.insertBatch(list);
    }
}

