/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.plan.dao.PurDeliveryPlanItemMapper;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.service.PurDeliveryPlanItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeliveryPlanItemService")
public class PurDeliveryPlanItemServiceImpl
implements PurDeliveryPlanItemService {
    @Resource
    protected PurDeliveryPlanItemMapper deliveryPlanItemMapper;

    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void addObj(PurDeliveryPlanItem t) {
        this.deliveryPlanItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void addAll(List<PurDeliveryPlanItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deliveryPlanItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryPlanItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void modifyObj(PurDeliveryPlanItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.deliveryPlanItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public PurDeliveryPlanItem queryObjById(String id) {
        return this.deliveryPlanItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public List<PurDeliveryPlanItem> queryAllObjByExample(PurDeliveryPlanItemExample example) {
        return this.deliveryPlanItemMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurDeliveryPlanItem> queryObjByPage(PurDeliveryPlanItemExample example) {
        PageView<PurDeliveryPlanItem> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryPlanItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"deliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public List<PurDeliveryPlanItem> queryByOrderId(String purOrderId) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        example.setOrderByClause("PUR_ORDER_ITEM_NO ASC, DELIVERY_DATE ASC");
        return this.deliveryPlanItemMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void deleteByOrderId(String orderId) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderIdEqualTo(orderId);
        this.deliveryPlanItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void modifyByExample(PurDeliveryPlanItem item, PurDeliveryPlanItemExample example) {
        this.deliveryPlanItemMapper.updateByExampleSelective(item, example);
    }

    @Override
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void confirmAllPlan(String orderId) {
        this.deliveryPlanItemMapper.updateConfirmStatusAndDeliveryDate(orderId, new Date());
    }

    @Override
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void deleteByExample(PurDeliveryPlanItemExample example) {
        this.deliveryPlanItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void confirmAllPlanByOrderItem(String orderItemId) {
        this.deliveryPlanItemMapper.updateConfirmStatusAndDeliveryDateByOrderItemId(orderItemId, new Date());
    }

    @Override
    @Cacheable(value={"deliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public List<PurDeliveryPlanItem> queryByOrderItemId(String orderItemId) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderItemIdEqualTo(orderItemId);
        return this.deliveryPlanItemMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void addBySupDeliveryPlanItem(String orderItemId) {
        Assert.isNotBlank((String)orderItemId, (String)"\u8ba2\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        this.deliveryPlanItemMapper.insertBatchBySupDeliveryPlanItem(orderItemId);
    }

    @Override
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void addOnwayQuantity(String planItemId, BigDecimal quantity) {
        int result = this.deliveryPlanItemMapper.addOnwayQuantity(planItemId, quantity);
        if (result <= 0) {
            throw new CommonException("\u8ba1\u5212\u7684\u5728\u9014\u6570\u91cf\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
    }

    @Override
    @Cacheable(value={"deliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public BigDecimal calculateCanDeliveryQuantity(String planItemId) {
        PurDeliveryPlanItem plan = this.deliveryPlanItemMapper.selectByPrimaryKey(planItemId);
        BigDecimal onwayQuantity = plan.getOnwayQuantity();
        BigDecimal receiveQuantity = plan.getReceivedQuantity();
        if (onwayQuantity == null) {
            onwayQuantity = BigDecimal.ZERO;
        }
        if (receiveQuantity == null) {
            receiveQuantity = BigDecimal.ZERO;
        }
        return plan.getDeliveryQuantity().subtract(onwayQuantity).subtract(receiveQuantity);
    }

    @Override
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void addReceiveQuantity(String planItemId, BigDecimal quantity) {
        this.deliveryPlanItemMapper.addReceiveQuantity(planItemId, quantity);
    }

    @Override
    @CacheEvict(value={"deliveryPlanItem"}, allEntries=true)
    public void updateConsumeMunber(String planId, BigDecimal quantity) {
        this.deliveryPlanItemMapper.updateConsumeMunber(planId, quantity);
    }

    @Override
    @Cacheable(value={"deliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurDeliveryPlanItem> queryClosePlanByPage(PurDeliveryPlanItemExample example) {
        PageView<PurDeliveryPlanItem> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryPlanItemMapper.selectByCloseByPage(example));
        return pageView;
    }
}

