/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class RefuseOrderItemCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private SupplierOrderItem supplierOrderItem;
    private SupplierOrder supplierOrder;

    public RefuseOrderItemCommand(SupplierOrderItem supplierOrderItem, SupplierOrder supplierOrder) {
        this.supplierOrderItem = supplierOrderItem;
        this.supplierOrder = supplierOrder;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.supplierOrderItem);
        Date refuseDate = new Date();
        this.supplierOrderItem.setUpdateTime(new Date());
        this.supplierOrderItem.setSupUserId(this.getSupUser().getId());
        this.supplierOrderItem.setSupUserName(this.getSupUser().getNickName());
        this.supplierOrderItem.setUpdateTime(refuseDate);
        this.supplierOrderItem.setHaveChange(ChangeTypeEnum.OLD_ITEM.getValue());
        if (StringUtils.isBlank((String)this.supplierOrderItem.getSupRemark())) {
            this.supplierOrderItem.setSupRemark("");
        }
        ContextUtils.getSupplierOrderItemService().modifyObj(this.supplierOrderItem);
        PurchaseOrderItem recordItem = new PurchaseOrderItem();
        recordItem.setSupRemark(this.supplierOrderItem.getSupRemark());
        recordItem.setOrderStatus(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
        recordItem.setSupUserId(this.getSupUser().getId());
        recordItem.setSupUserName(this.getSupUser().getNickName());
        recordItem.setUpdateTime(refuseDate);
        recordItem.setId(this.supplierOrderItem.getId());
        recordItem.setIsRefuseDeliveredDate(this.supplierOrderItem.getIsRefuseDeliveredDate());
        recordItem.setIsRefusePrice(this.supplierOrderItem.getIsRefusePrice());
        recordItem.setIsRefuseQuantity(this.supplierOrderItem.getIsRefuseQuantity());
        recordItem.setPurUserId(this.supplierOrder.getPurUserId());
        recordItem.setPurUserName(this.supplierOrder.getPurUserName());
        recordItem.setHaveChange(ChangeTypeEnum.OLD_ITEM.getValue());
        if (StringUtils.isBlank((String)this.supplierOrderItem.getSupRemark())) {
            recordItem.setSupRemark("");
        } else {
            recordItem.setSupRemark(this.supplierOrderItem.getSupRemark());
        }
        ContextUtils.getPurchaseOrderItemService().modifyObj(recordItem);
        return null;
    }

    private void valid(SupplierOrderItem supplierOrderItem) {
        Assert.isNotNull((Object)supplierOrderItem);
        Assert.isNotBlank((String)supplierOrderItem.getId(), (String)"\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supplierOrderItem.getOrderNo(), (String)"\u8ba2\u5355\u884c\u4e2d\uff0c\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supplierOrderItem.getId(), (String)"\u8ba2\u5355\u884c\u4e2d\uff0c\u8ba2\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (Constant.YES_INT.equals(supplierOrderItem.getIsRefuseQuantity()) && Constant.YES_INT.equals(supplierOrderItem.getIsRefuseDeliveredDate())) {
            throw new CommonException(String.format("\u8ba2\u5355\u884c [%s] \u5df2\u62d2\u7edd\u6570\u91cf\uff0c\u4ea4\u671f\u65e0\u6cd5\u786e\u8ba4\u3002\u4e0d\u9700\u8981\u518d\u62d2\u7edd\u4ea4\u671f", supplierOrderItem.getOrderItemNo()));
        }
        if (Constant.NO_INT.equals(supplierOrderItem.getIsEnable()) && PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(supplierOrderItem.getOrderStatus())) {
            if (Constant.YES_INT.equals(supplierOrderItem.getIsRefuseDeliveredDate())) {
                throw new CommonException(String.format("\u8ba2\u5355\u884c [%s] \u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u4e0d\u80fd\u62d2\u7edd\u4ea4\u671f", supplierOrderItem.getOrderItemNo()));
            }
            if (Constant.YES_INT.equals(supplierOrderItem.getIsRefusePrice())) {
                throw new CommonException(String.format("\u8ba2\u5355\u884c [%s] \u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u4e0d\u80fd\u62d2\u7edd\u4ef7\u683c", supplierOrderItem.getOrderItemNo()));
            }
            if (Constant.YES_INT.equals(supplierOrderItem.getIsRefuseQuantity())) {
                throw new CommonException(String.format("\u8ba2\u5355\u884c [%s] \u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u4e0d\u80fd\u62d2\u7edd\u6570\u91cf", supplierOrderItem.getOrderItemNo()));
            }
        }
        if ("Y".equals(supplierOrderItem.getFinishFlag()) && PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(supplierOrderItem.getOrderStatus())) {
            if (Constant.YES_INT.equals(supplierOrderItem.getIsRefuseDeliveredDate())) {
                throw new CommonException(String.format("\u8ba2\u5355\u884c [%s] \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u4e0d\u80fd\u62d2\u7edd\u4ea4\u671f", supplierOrderItem.getOrderItemNo()));
            }
            if (Constant.YES_INT.equals(supplierOrderItem.getIsRefusePrice())) {
                throw new CommonException(String.format("\u8ba2\u5355\u884c [%s] \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u4e0d\u80fd\u62d2\u7edd\u4ef7\u683c", supplierOrderItem.getOrderItemNo()));
            }
            if (Constant.YES_INT.equals(supplierOrderItem.getIsRefuseQuantity())) {
                throw new CommonException(String.format("\u8ba2\u5355\u884c [%s] \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u4e0d\u80fd\u62d2\u7edd\u6570\u91cf", supplierOrderItem.getOrderItemNo()));
            }
        }
    }
}

