/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;
import org.springframework.util.StringUtils;

public class BarCodeImage {
    public static File generateFile(String msg, String path) {
        File file = new File(path);
        try {
            BarCodeImage.generate(msg, new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public static byte[] generate(String msg) {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        BarCodeImage.generate(msg, ous);
        return ous.toByteArray();
    }

    public static void generate(String msg, OutputStream ous) {
        if (StringUtils.isEmpty((Object)msg) || ous == null) {
            return;
        }
        Code39Bean bean = new Code39Bean();
        int dpi = 150;
        double moduleWidth = UnitConv.in2mm((double)0.006666666828095913);
        bean.setModuleWidth(moduleWidth);
        bean.setWideFactor(3.0);
        bean.doQuietZone(false);
        String format = "image/png";
        try {
            BitmapCanvasProvider canvas = new BitmapCanvasProvider(ous, format, 150, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvas, msg);
            canvas.finish();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeBar(String imgPath) {
        BufferedImage image = null;
        Result result = null;
        try {
            image = ImageIO.read(new File(imgPath));
            if (image == null) {
                System.out.println("the decode image may be not exit.");
            }
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            result = new MultiFormatReader().decode(bitmap, null);
            return result.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String msg = "6923450657713";
        String imgPath = "D:/test/fdsafdsa.png";
        BarCodeImage.encodeBar(msg, 105, 50, imgPath);
        System.out.println("\u751f\u6210\u6761\u5f62\u7801\u6210\u529f");
        System.out.println(BarCodeImage.decodeBar(imgPath));
    }

    public static void encodeBar(String contents, int width, int height, String imgPath) {
        int codeWidth = 98;
        codeWidth = Math.max(codeWidth, width);
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(contents, BarcodeFormat.CODE_128, codeWidth, height, null);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)new FileOutputStream(imgPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

