/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.purchase.command.order.pur.ConfirmOrderItemPriceCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.ExcelFileDataUtils;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.liby.organization.utils.UserOrganizationUtils;
import com.google.common.collect.Lists;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u8ba2\u5355\u884c")
@Controller
@RequestMapping(value={"purchaseOrderItem"})
public class PurchaseOrderItemController {
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected PurchaseOrderService purchaseOrderService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u786e\u8ba4\u4ef7\u683c\u7684\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/confirmOrderItemForPrice"})
    @ResponseBody
    public ResponseResult<String> confirmOrderItemPrice(@RequestBody List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, (String)"\u8ba2\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        ConfirmOrderItemPriceCommand cmd = new ConfirmOrderItemPriceCommand(orderItemIdList);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u9700\u8981\u786e\u8ba4\u4ef7\u683c\u7684\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findTodoItemForPrice"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findTodoItemForPrice(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsRefusePriceEqualTo(Constant.YES_INT).andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62d2\u7edd\u6570\u91cf\u7684\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findTodoItemForQuantity"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findTodoItemForQuantity(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        example.createCriteria().andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsRefuseQuantityEqualTo(Constant.YES_INT);
        example.or().andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsRefuseDeliveredDateNotEqualTo(Constant.YES_INT).andIsRefusePriceNotEqualTo(Constant.YES_INT).andIsRefuseQuantityNotEqualTo(Constant.YES_INT).andOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u91c7\u8d2d\u8ba2\u5355\u53f7\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findByPurchaseOrder"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findByPurchaseOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7") String orderId) {
        if (StringUtils.isBlank((String)orderId)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u91c7\u8d2d\u8ba2\u5355\u53f7"});
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderIdEqualTo(orderId);
        criteria.andIsEnableNotEqualTo(0);
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        PageView pageData = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7id\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\u5386\u53f2")
    @RequestMapping(value={"service/findItemHisById"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findItemHisById(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7") String orderNo, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u884c\u53f7") String orderItemNo) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        if (StringUtils.isBlank((String)orderNo)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoEqualTo(orderNo);
        criteria.andOrderItemNoEqualTo(orderItemNo);
        example.setOrderByClause("version DESC,UPDATE_TIME DESC");
        PageView<PurchaseOrderItem> pageData = this.purchaseOrderItemService.queryHisAllObjByExample(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u901a\u7528\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=true) QueryParamWapper wapper) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        PageView pageData = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4e0b\u53d1\u7684\u8ba1\u5212\u5458\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\u660e\u7ec6")
    @RequestMapping(value={"service/findForPlaner"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findForPlaner(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        List companySapCodeList = UserOrganizationUtils.getUserCompanyCode((String)SpringSecurityUtils.getLoginUserId());
        if (CollectionUtils.isEmpty((Collection)companySapCodeList)) {
            return ResponseResult.success((Object)new PageView());
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        List group = Lists.partition((List)companySapCodeList, (int)999);
        for (List list : group) {
            example.or().andPurCompanySapCodeIn(list);
        }
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        PageView page = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        if (CollectionUtils.isEmpty((Collection)page.getQueryResult())) {
            return ResponseResult.success((Object)page);
        }
        page.getQueryResult().forEach(orderItem -> {
            PurchaseOrder order = (PurchaseOrder)this.purchaseOrderService.queryObjById(orderItem.getOrderId());
            orderItem.setOrder(order);
        });
        return ResponseResult.success((Object)page);
    }

    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u5bfc\u51fa", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        List companySapCodeList = UserOrganizationUtils.getUserCompanyCode((String)SpringSecurityUtils.getLoginUserId());
        List<TitleAndModelKey> titleAndModelKeys = ExcelFileDataUtils.createTitleAndModelKeysForPur();
        if (CollectionUtils.isEmpty((Collection)companySapCodeList)) {
            FileData fileData = ExcelFileDataUtils.createExcelFileOutputStream(titleAndModelKeys, null, "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u6570\u636e", "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u6570\u636e", 0);
            return ResponseResult.success((Object)fileData);
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        if (CollectionUtils.isNotEmpty(ids)) {
            example.createCriteria().andIdIn((List)ids);
            List orderItemList = this.purchaseOrderItemService.queryAllObjByExample((IExample)example);
            List<Map<String, Object>> orderAndItemMap = this.transfer(orderItemList);
            FileData fileData = ExcelFileDataUtils.createExcelFileOutputStream(titleAndModelKeys, orderAndItemMap, "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u6570\u636e", "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u6570\u636e", 0);
            return ResponseResult.success((Object)fileData);
        }
        if (StringUtils.isNotBlank((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
        }
        if (CollectionUtils.isEmpty(example.getOredCriteria())) {
            throw new CommonException("\u8bf7\u6dfb\u52a0\u5bfc\u51fa\u7684\u8ba2\u5355\u884c\u67e5\u8be2\u6761\u4ef6");
        }
        example.clear();
        List group = Lists.partition((List)companySapCodeList, (int)999);
        for (List list : group) {
            example.or().andPurCompanySapCodeIn(list);
        }
        QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
        CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        List orderItemList = this.purchaseOrderItemService.queryAllObjByExample((IExample)example);
        List<Map<String, Object>> orderAndItemMap = this.transfer(orderItemList);
        FileData fileData = ExcelFileDataUtils.createExcelFileOutputStream(titleAndModelKeys, orderAndItemMap, "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u6570\u636e", "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u6570\u636e", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<Map<String, Object>> transfer(List<PurchaseOrderItem> orderItems) {
        List orderIdList = orderItems.stream().map(PurchaseOrderItem::getOrderId).collect(Collectors.toList());
        PurchaseOrderExample example = new PurchaseOrderExample();
        List group = Lists.partition(orderIdList, (int)999);
        for (List list : group) {
            example.or().andIdIn(list);
        }
        List orderList = this.purchaseOrderService.queryAllObjByExample((IExample)example);
        List<Map<String, Object>> orderAndItemMap = orderItems.stream().map(orderItem -> {
            HashMap<String, Serializable> orderAndItem = new HashMap<String, Serializable>();
            PurchaseOrder order = this.filterOrder(orderList, (PurchaseOrderItem)orderItem);
            orderAndItem.put("order", order);
            orderAndItem.put("orderItem", (Serializable)orderItem);
            return orderAndItem;
        }).collect(Collectors.toList());
        return orderAndItemMap;
    }

    private PurchaseOrder filterOrder(List<PurchaseOrder> orders, PurchaseOrderItem orderItem) {
        return orders.stream().filter(order -> order.getId().equals(orderItem.getOrderId())).findAny().orElseGet(null);
    }
}

