/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.command.CreateCommand;
import com.els.base.delivery.command.WriteBackToErpCommand;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.entity.DeliveryPackageExample;
import com.els.base.delivery.utils.DeliveryOperateEnum;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.plan.command.BatchModifyPlanIsCanDeliveryCmd;
import com.els.base.plan.command.ModifyPlanOnWayQuantityCmd;
import com.els.base.purchase.command.order.ModifyOrderItemOnWayQuantityCmd;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ModifyCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    protected DeliveryOrder deliveryOrder;

    public ModifyCommand(DeliveryOrder deliveryOrder) {
        this.deliveryOrder = deliveryOrder;
    }

    @Override
    public String execute(ICommandInvoker context) {
        DeliveryOrder prevousDeliveryOrder = (DeliveryOrder)ContextUtils.getDeliveryOrderService().queryObjById(this.deliveryOrder.getId());
        this.valid(prevousDeliveryOrder, this.deliveryOrder);
        List<DeliveryOrderItem> deliveryOrderItemList = ContextUtils.getDeliveryOrderItemService().queryByDeliveryOrderId(this.deliveryOrder.getId());
        deliveryOrderItemList.stream().forEach(item -> {
            context.invoke(new ModifyPlanOnWayQuantityCmd(item.getDeliveryPlanItemId(), DeliveryOperateEnum.DELIVERY_ORDER_DELETE, item.getDeliveryQuantity()));
            this.context.invoke(new ModifyOrderItemOnWayQuantityCmd(item.getPurOrderItemId(), DeliveryOperateEnum.DELIVERY_ORDER_DELETE, item.getDeliveryQuantity()));
        });
        List<String> planItemIdList = deliveryOrderItemList.stream().map(DeliveryOrderItem::getDeliveryPlanItemId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        context.invoke(new BatchModifyPlanIsCanDeliveryCmd(planItemIdList));
        ContextUtils.getDeliveryOrderService().deleteObjById(this.deliveryOrder.getId());
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderIdEqualTo(this.deliveryOrder.getId());
        ContextUtils.getDeliveryOrderItemService().deleteByExample(example);
        DeliveryPackageExample deliveryPackageExample = new DeliveryPackageExample();
        deliveryPackageExample.createCriteria().andDeliveryOrderIdEqualTo(this.deliveryOrder.getId());
        ContextUtils.getDeliveryPackageService().deleteByExample(deliveryPackageExample);
        CreateCommand command = new CreateCommand(this.deliveryOrder);
        String result = context.invoke(command);
        this.context.invoke(new WriteBackToErpCommand(this.deliveryOrder.getId()));
        return result;
    }

    protected void valid(DeliveryOrder prevousDeliveryOrder, DeliveryOrder deliveryOrder) {
        Assert.isNotNull((Object)deliveryOrder, (String)"\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(deliveryOrder.getItems(), (String)"\u884c\u6570\u636e\u4e0d\u5b58\u5728");
        if (DeliveryStatusEnum.TO_FACTORY.getValue().equals(prevousDeliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u9001\u8d27\u5355\u5df2\u7ecf\u5230\u5382\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(prevousDeliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u9001\u8d27\u5355\u5df2\u7ecf\u6536\u8d27\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (DeliveryStatusEnum.ONWAY.getValue().equals(prevousDeliveryOrder.getDeliveryStatus())) {
            throw new CommonException("\u9001\u8d27\u5355\u5df2\u7ecf\u53d1\u8d27\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (deliveryOrder.getInvoiceNo() != null && deliveryOrder.getInvoiceNo().length() > 255 || deliveryOrder.getDriverName() != null && deliveryOrder.getDriverName().length() > 255 || deliveryOrder.getIdCard() != null && deliveryOrder.getIdCard().length() > 255 || deliveryOrder.getCar() != null && deliveryOrder.getCar().length() > 255) {
            throw new CommonException("\u9001\u8d27\u5355\u5934\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            Assert.isNotBlank((String)deliveryOrderItem.getPurOrderItemId(), (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u9001\u8d27\u5355\u884c\u4e2d\uff0c\u7f3a\u5c11\u91c7\u8d2d\u8ba2\u5355\u884cid");
            if (deliveryOrderItem.getChineseName() != null && deliveryOrderItem.getChineseName().length() > 255 || deliveryOrderItem.getRemark() != null && deliveryOrderItem.getRemark().length() > 255 || deliveryOrderItem.getBrand() != null && deliveryOrderItem.getBrand().length() > 255 || deliveryOrderItem.getSourceArea() != null && deliveryOrderItem.getSourceArea().length() > 255 || deliveryOrderItem.getModel() != null && deliveryOrderItem.getModel().length() > 255 || deliveryOrderItem.getCaseNo() != null && deliveryOrderItem.getCaseNo().length() > 30) {
                throw new CommonException("\u9001\u8d27\u5355\u884c\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
            }
            if (deliveryOrderItem.getDeliveryQuantity().compareTo(deliveryOrderItem.getCanDeliveryQuantity()) < 1) continue;
            throw new CommonException("\u53d1\u8d27\u6570\u91cf\u5927\u4e8e\u53ef\u53d1\u8d27\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01", "delivery_gt_candelivery", new Object[]{"\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u53ef\u53d1\u8d27\u6570\u91cf\uff08\u6709\u53ef\u80fd\u662f\u8be5\u91c7\u8d2d\u8ba2\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u65b0\u8fdb\u5165\uff09\uff01"});
        }
    }
}

