/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.plan.command.nonejit.pur.NoneJitPlanSendToSupCmd;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.plan.utils.PlanDataSourceEnum;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;

public class ImportPlanItemCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<PurDeliveryPlanItem> list;

    public ImportPlanItemCmd(List<PurDeliveryPlanItem> list) {
        this.list = list;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Map<String, List<PurDeliveryPlanItem>> orderNoAndPlanList = this.list.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderNo));
        Set<String> orderNoList = orderNoAndPlanList.keySet();
        orderNoList.forEach(orderNo -> this.importPlanItemForOrder((String)orderNo, (List)orderNoAndPlanList.get(orderNo)));
        return null;
    }

    private void importPlanItemForOrder(String orderNo, List<PurDeliveryPlanItem> list) {
        Map<String, List<PurDeliveryPlanItem>> orderItemNoAndPlanList = list.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderItemNo));
        ArrayList<PurDeliveryPlanItem> itemList = new ArrayList<PurDeliveryPlanItem>();
        ArrayList<String> orderItemNoList = new ArrayList<String>();
        orderItemNoList.addAll(orderItemNoAndPlanList.keySet());
        orderItemNoList.sort(String::compareTo);
        for (String orderItemNo : orderItemNoList) {
            PurchaseOrderItem orderItem = this.queryItem(orderNo, orderItemNo);
            List<PurDeliveryPlanItem> purPlanItemList = orderItemNoAndPlanList.get(orderItemNo);
            this.validPlanItemList(orderItem, purPlanItemList);
            List<SupDeliveryPlanItem> supPlanItemList = this.queryPlanItem(orderNo, orderItemNo);
            Assert.isNotNull(supPlanItemList, (String)String.format("\u8ba2\u5355\u884c[%s][%s]\u6ca1\u6709\u8ba1\u5212", orderNo, orderItemNo));
            if (DeliveryPlanUtils.isEqualBewteenPurAndSup(purPlanItemList, supPlanItemList)) {
                List<PurDeliveryPlanItem> confirmList = this.getConfirmPlan(supPlanItemList, purPlanItemList);
                itemList.addAll(confirmList);
                continue;
            }
            List<PurDeliveryPlanItem> refusePlanList = this.getRefusePlan(supPlanItemList, purPlanItemList);
            refusePlanList.stream().forEach(p -> p.setPurOrderItemId(orderItem.getId()));
            itemList.addAll(refusePlanList);
        }
        NoneJitPlanSendToSupCmd sendToPurCmd = new NoneJitPlanSendToSupCmd(itemList, PlanDataSourceEnum.EXCEL);
        sendToPurCmd.copyProperties(this);
        this.context.invoke(sendToPurCmd);
    }

    private List<PurDeliveryPlanItem> getRefusePlan(List<SupDeliveryPlanItem> supPlanItemList, List<PurDeliveryPlanItem> purPlanItemList) {
        return purPlanItemList.stream().map(planItem -> {
            PurDeliveryPlanItem temp = new PurDeliveryPlanItem();
            BeanUtils.copyProperties(supPlanItemList.get(0), (Object)temp);
            temp.setDeliveryDate(planItem.getDeliveryDate());
            temp.setDeliveryQuantity(planItem.getDeliveryQuantity());
            temp.setChangeReason(planItem.getChangeReason());
            temp.setPurRemark(planItem.getPurRemark());
            temp.setChangeStatus(PlanChangeStatusEnum.PUR_CHANGE.getValue());
            temp.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            temp.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            temp.setPurRemark(planItem.getPurRemark());
            temp.setId(null);
            return temp;
        }).collect(Collectors.toList());
    }

    private List<PurDeliveryPlanItem> getConfirmPlan(List<SupDeliveryPlanItem> supPlanItemList, List<PurDeliveryPlanItem> purPlanItemList) {
        boolean isConfirm = supPlanItemList.stream().allMatch(supPlan -> PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(supPlan.getPurConfirmStatus()) && PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(supPlan.getSupConfirmStatus()));
        if (isConfirm) {
            return new ArrayList<PurDeliveryPlanItem>();
        }
        List<PurDeliveryPlanItem> confirmList = supPlanItemList.stream().map(supPlan -> {
            PurDeliveryPlanItem temp = new PurDeliveryPlanItem();
            BeanUtils.copyProperties((Object)supPlan, (Object)temp);
            temp.setChangeStatus(PlanChangeStatusEnum.PUR_CONFIRM.getValue());
            temp.setPurRemark(DeliveryPlanUtils.findPurPlan(supPlan, purPlanItemList).getPurRemark());
            return temp;
        }).collect(Collectors.toList());
        return confirmList;
    }

    private PurchaseOrderItem queryItem(String orderNo, String orderItemNo) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        PurchaseOrderItemExample.Criteria cri = example.createCriteria().andOrderNoEqualTo(orderNo).andOrderItemNoEqualTo(orderItemNo);
        if (this.getPurCompany() != null) {
            cri.andProjectIdEqualTo(this.getPurCompany().getProjectId());
        }
        List itemList = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)itemList, (String)String.format("\u8ba2\u5355\u884c\u9879\u76ee\u4e0d\u5b58\u5728[%s][%s]", orderNo, orderItemNo));
        return (PurchaseOrderItem)itemList.get(0);
    }

    private PurDeliveryPlanItem findPlan(SupDeliveryPlanItem purPlanItem, List<PurDeliveryPlanItem> planItemList) {
        String date = DateFormatUtils.format((Date)purPlanItem.getDeliveryDate(), (String)"yyyy-MM-dd");
        return planItemList.stream().filter(supPlanItem -> DateFormatUtils.format((Date)supPlanItem.getDeliveryDate(), (String)"yyyy-MM-dd").equals(date) && supPlanItem.getDeliveryQuantity().compareTo(purPlanItem.getDeliveryQuantity()) == 0 && supPlanItem.getPurOrderNo().equals(purPlanItem.getPurOrderNo()) && supPlanItem.getPurOrderItemNo().equals(purPlanItem.getPurOrderItemNo())).findAny().get();
    }

    private void validPlanItemList(PurchaseOrderItem orderItem, List<PurDeliveryPlanItem> purPlanItemList) {
        BigDecimal totalQuantity = purPlanItemList.stream().map(PurDeliveryPlanItem::getDeliveryQuantity).reduce(BigDecimal::add).get();
        if (orderItem.getCanDeliveryQuantity().compareTo(totalQuantity) > 0) {
            BigDecimal q = orderItem.getCanDeliveryQuantity().subtract(totalQuantity);
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf\u5f02\u5e38\uff0c\u5c11\u4e8e\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u76f8\u5dee[%s]", orderItem.getOrderNo(), orderItem.getOrderItemNo(), q.toString()));
        }
        if (orderItem.getCanDeliveryQuantity().compareTo(totalQuantity) < 0) {
            BigDecimal q = totalQuantity.subtract(orderItem.getCanDeliveryQuantity());
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf\u5f02\u5e38\uff0c\u5927\u4e8e\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u76f8\u5dee[%s]", orderItem.getOrderNo(), orderItem.getOrderItemNo(), q.toString()));
        }
    }

    private List<SupDeliveryPlanItem> queryPlanItem(String orderNo, String orderItemNo) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPurOrderNoEqualTo(orderNo).andPurOrderItemNoEqualTo(orderItemNo);
        return ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
    }
}

