/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.MaterialFile;
import com.els.base.material.service.MaterialFileService;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.purchase.entity.PurchaseOrderChange;
import com.els.base.purchase.entity.SupOrderItemBom;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.utils.SpringContextHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ViewSupOrderDetailCommand
extends AbstractCommand<SupplierOrder> {
    private static final long serialVersionUID = 1L;
    private String purOrderId;

    public ViewSupOrderDetailCommand(String purOrderId) {
        this.purOrderId = purOrderId;
    }

    @Override
    public SupplierOrder execute(ICommandInvoker context) {
        SupplierOrder supOrder = (SupplierOrder)ContextUtils.getSupplierOrderService().queryObjById(this.purOrderId);
        List<SupplierOrderItem> itemList = ContextUtils.getSupplierOrderItemService().queryByOrderIdList(Arrays.asList(this.purOrderId));
        supOrder.setItems(itemList);
        List<PurchaseOrderChange> changeList = ContextUtils.getPurchaseOrderChangeService().queryByOrderId(this.purOrderId);
        supOrder.setChangeList(changeList);
        List<SupDeliveryPlanItem> planItemList = ContextUtils.getSupDeliveryPlanItemService().queryByOrderId(this.purOrderId);
        planItemList = planItemList.stream().filter(plan -> Constant.NO_INT.equals(plan.getIsJit())).collect(Collectors.toList());
        supOrder.setPlanItemList(planItemList);
        List<SupOrderItemBom> bomList = ContextUtils.getSupOrderItemBomService().queryByOrderId(this.purOrderId);
        supOrder.setBomList(bomList);
        if (CollectionUtils.isNotEmpty(itemList)) {
            List materialCodeList = itemList.stream().map(SupplierOrderItem::getMaterialCode).collect(Collectors.toList());
            List materialFiles = ((MaterialFileService)SpringContextHolder.getOneBean(MaterialFileService.class)).queryByMaterialCodeList(materialCodeList);
            supOrder.setMaterialFileList(materialFiles);
        }
        return supOrder;
    }

    private Predicate<MaterialFile> removeDuplicate() {
        HashSet fileCodeSet = new HashSet();
        return materialFile -> fileCodeSet.add(materialFile.getFileCode());
    }
}

