/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.command.order.RemindOfPurchaseOrderCmd;
import com.els.base.purchase.dao.PurchaseOrderMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseOrderService")
public class PurchaseOrderServiceImpl
implements PurchaseOrderService {
    private static Logger logger = LoggerFactory.getLogger(PurchaseOrderServiceImpl.class);
    @Resource
    protected PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    protected OrderCommandInvoker invoker;

    @Transactional
    @CacheEvict(value={"purchaseOrder", "purchaseOrderItem"}, allEntries=true)
    public void addObj(PurchaseOrder purchaseOrder) {
        this.purchaseOrderMapper.insertSelective(purchaseOrder);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void modifyObj(PurchaseOrder t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        this.purchaseOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryObjById(String id) {
        return this.purchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrder> queryAllObjByExample(PurchaseOrderExample example) {
        return this.purchaseOrderMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectByExampleByPage(example);
        for (PurchaseOrder purchaseOrder : list) {
            Company company = (Company)this.companyService.queryObjById((Object)purchaseOrder.getSupCompanyId());
            if (company == null) continue;
            purchaseOrder.setSupCompanyShortName(company.getCompanyName());
        }
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryHisObjByPage(PurchaseOrderExample example) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void updateByPurcahseOrder(PurchaseOrder record, PurchaseOrderExample example) {
        this.purchaseOrderMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrder> queryObjNoItemsByPage(PurchaseOrderExample example, String purUserId, String materialCode, String brand) {
        PageView<PurchaseOrder> pageView = example.getPageView();
        List<PurchaseOrder> list = this.purchaseOrderMapper.selectForPurUserByExampleByPage(example, pageView, purUserId, materialCode, brand);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Cacheable(value={"purchaseOrder"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrder queryByOrderNo(String projectId, String orderNo) {
        PurchaseOrderExample example = new PurchaseOrderExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andOrderNoEqualTo(orderNo);
        List<PurchaseOrder> list = this.queryAllObjByExample(example);
        if (list != null && list.size() > 1) {
            throw new CommonException("\u51fa\u73b0\u91cd\u590d\u8ba2\u5355\u53f7\u7684\u95ee\u9898");
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public String insertHis(String orderId, String cause) {
        String uuid = UUIDGenerator.generateUUID();
        this.purchaseOrderMapper.insertHis(uuid, orderId, cause, new Date());
        return uuid;
    }

    @Override
    public void overduePush() {
        RemindOfPurchaseOrderCmd command = new RemindOfPurchaseOrderCmd();
        this.invoker.invoke(command);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void deleteByExample(PurchaseOrderExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseOrderMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseOrder"}, allEntries=true)
    public void addAll(List<PurchaseOrder> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.purchaseOrderMapper.insertBatch(list);
    }
}

