/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.dao.PurVoucherMapper;
import com.els.base.delivery.entity.PurVoucher;
import com.els.base.delivery.entity.PurVoucherExample;
import com.els.base.delivery.service.PurVoucherService;
import com.els.base.utils.uuid.UUIDGenerator;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurVoucherService")
public class PurVoucherServiceImpl
implements PurVoucherService {
    @Resource
    protected PurVoucherMapper purVoucherMapper;

    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void addObj(PurVoucher t) {
        this.purVoucherMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void addAll(List<PurVoucher> vouchers) {
        if (CollectionUtils.isEmpty(vouchers)) {
            return;
        }
        vouchers.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        List group = Lists.partition(vouchers, (int)30);
        for (List list : group) {
            this.purVoucherMapper.insertBatch(list);
        }
    }

    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purVoucherMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void modifyObj(PurVoucher t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purVoucherMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purVoucher"}, keyGenerator="redisKeyGenerator")
    public PurVoucher queryObjById(String id) {
        return this.purVoucherMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purVoucher"}, keyGenerator="redisKeyGenerator")
    public List<PurVoucher> queryAllObjByExample(PurVoucherExample example) {
        return this.purVoucherMapper.selectByExample(example);
    }

    @Cacheable(value={"purVoucher"}, keyGenerator="redisKeyGenerator")
    public PageView<PurVoucher> queryObjByPage(PurVoucherExample example) {
        PageView<PurVoucher> pageView = example.getPageView();
        pageView.setQueryResult(this.purVoucherMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void deleteByExample(PurVoucherExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purVoucherMapper.deleteByExample(example);
    }
}

