/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.JITSupRef;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.liby.quota.entity.SupplierQuota;
import com.els.liby.quota.entity.SupplierQuotaExample;
import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CompositeDataCommand
extends AbstractCommand<List<JITSupRef>> {
    private String materialCode;
    private String factoryCode;
    private String planId;

    public CompositeDataCommand(String materialCode, String factoryCode, String planId) {
        this.materialCode = materialCode;
        this.factoryCode = factoryCode;
        this.planId = planId;
    }

    @Override
    public List<JITSupRef> execute(ICommandInvoker context) {
        List<JITSupRef> jitSupRefLists = this.getJitSupRef();
        for (JITSupRef jitSupRef : jitSupRefLists) {
            this.getQuota(jitSupRef);
            this.getLastDistributeMunAndTime(jitSupRef);
        }
        return jitSupRefLists;
    }

    private void getLastDistributeMunAndTime(JITSupRef jitSupRef) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andMaterialNoEqualTo(jitSupRef.getMaterialCode()).andFactoryCodeEqualTo(jitSupRef.getFactoryCode()).andPurCompanySapCodeEqualTo(jitSupRef.getSupCompanySapCode());
        List lists = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (lists.size() > 0) {
            jitSupRef.setLastDistributeMun(((PurDeliveryPlanItem)lists.get(0)).getLastDistributeMun());
            jitSupRef.setLastDistributionTime(((PurDeliveryPlanItem)lists.get(0)).getLastDistributionTime());
        }
    }

    private void getQuota(JITSupRef jitSupRef) {
        SupplierQuotaExample example = new SupplierQuotaExample();
        example.createCriteria().andMaterialCodeEqualTo(jitSupRef.getMaterialCode()).andFactoryCodeEqualTo(jitSupRef.getFactoryCode()).andCompanyCodeEqualTo(jitSupRef.getSupCompanySapCode()).andIsEnableEqualTo(Constant.YES_INT);
        List lists = ContextUtils.getSupplierQuotaService().queryAllObjByExample((IExample)example);
        if (lists.size() > 0) {
            jitSupRef.setQuota(((SupplierQuota)lists.get(0)).getQuota());
        }
    }

    private List<JITSupRef> getJitSupRef() {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andMaterialCodeEqualTo(this.materialCode).andFactoryEqualTo(this.factoryCode).andIsCanDeliveryEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagNotEqualTo("Y");
        List orderItemList = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (PurchaseOrderItem orderItem : orderItemList) {
            String companySapCode2 = orderItem.getSupCompanySapCode();
            arrayListMultiMap.put((Object)companySapCode2, (Object)orderItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        List<JITSupRef> jitSupRefLists = keySet.stream().map(companySapCode -> this.initJitSupRef((ArrayListMultimap<String, PurchaseOrderItem>)arrayListMultiMap, (String)companySapCode)).collect(Collectors.toList());
        this.sortByDistributionDesc(jitSupRefLists);
        return jitSupRefLists;
    }

    private JITSupRef initJitSupRef(ArrayListMultimap<String, PurchaseOrderItem> arrayListMultiMap, String companySapCode) {
        JITSupRef jitSupRef = new JITSupRef();
        List lists = arrayListMultiMap.get((Object)companySapCode);
        jitSupRef.setSupCompanySapCode(companySapCode);
        jitSupRef.setSupCompanyId(((PurchaseOrderItem)lists.get(0)).getSupCompanyId());
        jitSupRef.setSupCompanyCode(((PurchaseOrderItem)lists.get(0)).getSupCompanySrmCode());
        jitSupRef.setSupCompanyName(((PurchaseOrderItem)lists.get(0)).getSupCompanyName());
        jitSupRef.setPurCompanyId(((PurchaseOrderItem)lists.get(0)).getPurCompanyId());
        jitSupRef.setPurCompanyCode(((PurchaseOrderItem)lists.get(0)).getPurCompanySrmCode());
        jitSupRef.setPurCompanySapCode(((PurchaseOrderItem)lists.get(0)).getPurCompanySapCode());
        jitSupRef.setPurCompanyName(((PurchaseOrderItem)lists.get(0)).getPurCompanyName());
        jitSupRef.setFactoryCode(((PurchaseOrderItem)lists.get(0)).getFactory());
        jitSupRef.setFactoryName(((PurchaseOrderItem)lists.get(0)).getFactoryName());
        jitSupRef.setMaterialCode(((PurchaseOrderItem)lists.get(0)).getMaterialCode());
        jitSupRef.setMaterialDescribe(((PurchaseOrderItem)lists.get(0)).getMaterialName());
        SupDeliveryPlanItem thisPlanItem = this.getthisDestaibuteMun(companySapCode);
        jitSupRef.setThisDestaibuteMun(thisPlanItem.getDeliveryQuantity());
        jitSupRef.setPurRemarks(thisPlanItem.getPurRemark());
        jitSupRef.setCumulativeUndistributeMun(this.getCumulativeUndistributeMun(companySapCode, lists, thisPlanItem.getDeliveryQuantity()));
        SupDeliveryPlanItem planItem = this.geLlastSupDeliveryPlanItem(companySapCode);
        jitSupRef.setLastDistributionTime(planItem.getCreateTime());
        jitSupRef.setLastDistributeMun(planItem.getDeliveryQuantity());
        return jitSupRef;
    }

    private void sortByDistributionDesc(List<JITSupRef> jitSupRefLists) {
        Collections.sort(jitSupRefLists, new Comparator<JITSupRef>(){

            @Override
            public int compare(JITSupRef o1, JITSupRef o2) {
                if (o1.getCumulativeUndistributeMun().compareTo(o2.getCumulativeUndistributeMun()) > 0) {
                    return -1;
                }
                if (o1.getCumulativeUndistributeMun().compareTo(o2.getCumulativeUndistributeMun()) < 0) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private BigDecimal getCumulativeUndistributeMun(String companySapCode, List<PurchaseOrderItem> lists, BigDecimal thisDestaibuteMun) {
        thisDestaibuteMun = thisDestaibuteMun == null ? BigDecimal.ZERO : thisDestaibuteMun;
        BigDecimal distributableNum = lists.stream().map(purchaseOrderItem -> purchaseOrderItem.getCanDeliveryQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
        BigDecimal distributedNum = ContextUtils.getSupDeliveryPlanItemService().getdistributedNum(companySapCode, this.materialCode, this.factoryCode, null);
        return distributableNum.subtract(distributedNum).add(thisDestaibuteMun);
    }

    private SupDeliveryPlanItem geLlastSupDeliveryPlanItem(String companySapCode) {
        List lists;
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.setOrderByClause("CREATE_TIME DESC");
        SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsJitEqualTo(Constant.YES_INT).andMaterialNoEqualTo(this.materialCode).andFactoryCodeEqualTo(this.factoryCode).andSupCompanySapCodeEqualTo(companySapCode);
        if (this.planId != null) {
            criteria.andPlanIdNotEqualTo(this.planId);
        }
        if ((lists = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example)).size() > 0) {
            return (SupDeliveryPlanItem)lists.get(0);
        }
        return new SupDeliveryPlanItem();
    }

    private SupDeliveryPlanItem getthisDestaibuteMun(String sapCode) {
        if (this.planId != null) {
            SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
            SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
            criteria.andIsJitEqualTo(Constant.YES_INT).andMaterialNoEqualTo(this.materialCode).andFactoryCodeEqualTo(this.factoryCode).andSupCompanySapCodeEqualTo(sapCode).andPlanIdEqualTo(this.planId);
            List lists = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
            if (lists.size() > 0) {
                return (SupDeliveryPlanItem)lists.get(0);
            }
        }
        return new SupDeliveryPlanItem();
    }
}

