/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialExt;
import com.els.base.material.entity.MaterialExtExample;
import com.els.base.plan.command.jit.CompositeDataCommand;
import com.els.base.plan.command.jit.plan.CleanJitPlanCommand;
import com.els.base.plan.command.jit.planItem.CreateJitPlanItemCommand;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.DeliveryPlanExample;
import com.els.base.plan.entity.JITDemandMergeExample;
import com.els.base.plan.entity.JITLeadTime;
import com.els.base.plan.entity.JITLeadTimeExample;
import com.els.base.plan.entity.JITMaterialDemand;
import com.els.base.plan.entity.JITSupRef;
import com.els.base.plan.utils.JitPlanUtils;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.quota.entity.SupplierQuota;
import com.els.liby.quota.entity.SupplierQuotaExample;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateJitPlanByApsCmd
extends AbstractCommand<List<DeliveryPlan>> {
    private static final Logger logger = LoggerFactory.getLogger(CreateJitPlanByApsCmd.class);
    private static final BigDecimal TEMP = new BigDecimal("3600000");
    List<JITMaterialDemand> demands = this.getMaterialDemand();

    @Override
    public List<DeliveryPlan> execute(ICommandInvoker context) {
        this.valid(this.demands);
        this.initDemandTime(this.demands);
        this.initArryvalTime(this.demands);
        Lists.partition(this.demands, (int)100).forEach(demandList -> ContextUtils.getJitMaterialDemandService().addAll((List)demandList));
        List<DeliveryPlan> deliveryPlanLists = JitPlanUtils.mergeDemands(this.demands);
        this.deleteOldUnlockPlan(deliveryPlanLists);
        List<DeliveryPlan> changePlanLists = this.getChangePlan(deliveryPlanLists);
        return changePlanLists;
    }

    private void valid(List<JITMaterialDemand> demands) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        demands.stream().forEach(jitMaterialDemand -> {
            Assert.isNotBlank((String)jitMaterialDemand.getFactoryCode(), (String)"\u5de5\u5382\u4ee3\u7801\u4e3a\u7a7a");
            Assert.isNotBlank((String)jitMaterialDemand.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            Assert.isNotBlank((String)jitMaterialDemand.getConsumeMunber().toString(), (String)"\u6d88\u8017\u6570\u91cf\u4e3a\u7a7a");
            Assert.isNotBlank((String)jitMaterialDemand.getConsumeTime().toString(), (String)"\u6d88\u8017\u95f4\u4e3a\u7a7a");
            jitMaterialDemand.setCreateTime(new Date());
            jitMaterialDemand.setCreateUserId(loginUser.getId());
            jitMaterialDemand.setCreateUserName(loginUser.getUsername());
        });
    }

    private void initDemandTime(List<JITMaterialDemand> demands) {
        for (JITMaterialDemand j : demands) {
            BigDecimal leadTime = this.currentLeadTime(j.getMaterialCode(), j.getFactoryCode());
            if (leadTime == null) {
                j.setDemandTime(j.getConsumeTime());
                continue;
            }
            j.setDemandTime(new Date(j.getConsumeTime().getTime() - (long)leadTime.multiply(TEMP).intValue()));
        }
    }

    public void initArryvalTime(List<JITMaterialDemand> demands) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        demands.stream().forEach(jitMaterialDemand -> {
            String key = jitMaterialDemand.getFactoryCode();
            arrayListMultiMap.put((Object)key, jitMaterialDemand);
        });
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(key -> {
            List demandGroup = arrayListMultiMap.get(key);
            JITDemandMergeExample example = new JITDemandMergeExample();
            example.setOrderByClause(" TO_CHAR(START_TIME, 'hh24:mi:ss') ASC");
            example.createCriteria().andFactoryCodeEqualTo((String)key);
            List mergeList = ContextUtils.getJitDemandMergeService().queryAllObjByExample((IExample)example);
            demandGroup.stream().forEach(j -> JitPlanUtils.initArryValTimeAndLockByMerge(mergeList, j));
        });
    }

    private void deleteOldUnlockPlan(List<DeliveryPlan> deliveryPlanLists) {
        HashSet<String> set = new HashSet<String>();
        for (DeliveryPlan plan : deliveryPlanLists) {
            String key = plan.getFactoryCode() + plan.getMaterialCode() + plan.getArryvalTime();
            if (!set.add(key)) continue;
            CleanJitPlanCommand command = new CleanJitPlanCommand(plan.getMaterialCode(), plan.getFactoryCode(), plan.getArryvalTime());
            this.context.invoke(command);
        }
    }

    private List<DeliveryPlan> getChangePlan(List<DeliveryPlan> deliveryPlanLists) {
        List<DeliveryPlan> changePlanLists = deliveryPlanLists.stream().map(plan -> {
            DeliveryPlanExample example = new DeliveryPlanExample();
            example.createCriteria().andMaterialCodeEqualTo(plan.getMaterialCode()).andFactoryCodeEqualTo(plan.getFactoryCode()).andArryvalTimeEqualTo(plan.getArryvalTime());
            List planList = ContextUtils.getDeliveryPlanService().queryAllObjByExample((IExample)example);
            if (planList.size() == 0) {
                this.savePlanAndPlanItem((DeliveryPlan)plan, this.context);
            } else if (this.lockPlan(planList, (DeliveryPlan)plan, deliveryPlanLists)) {
                return null;
            }
            return plan;
        }).filter(deliveryPlan -> deliveryPlan != null).collect(Collectors.toList());
        return changePlanLists;
    }

    private boolean lockPlan(List<DeliveryPlan> planList, DeliveryPlan plan, List<DeliveryPlan> deliveryPlanLists) {
        planList.stream().filter(deliveryPlan -> {
            boolean isLock = "F".equals(deliveryPlan.getIsLock());
            if (!isLock) {
                CleanJitPlanCommand command = new CleanJitPlanCommand(Arrays.asList(((DeliveryPlan)planList.get(0)).getId()));
                this.context.invoke(command);
            }
            return isLock;
        });
        if (planList.size() == 0) {
            this.savePlanAndPlanItem(plan, this.context);
            return false;
        }
        return this.editLockedPlan(plan, planList, deliveryPlanLists);
    }

    private boolean editLockedPlan(DeliveryPlan plan, List<DeliveryPlan> planList, List<DeliveryPlan> deliveryPlanLists) {
        BigDecimal existedConsumeMunber = planList.stream().map(deliveryPlan -> deliveryPlan.getConsumeMunber()).reduce((x, y) -> x.add((BigDecimal)y)).get();
        if (plan.getConsumeMunber().compareTo(existedConsumeMunber) == 0) {
            return true;
        }
        if (plan.getConsumeMunber().compareTo(existedConsumeMunber) > 0) {
            plan.setConsumeMunber(plan.getConsumeMunber().subtract(existedConsumeMunber));
            this.savePlanAndPlanItem(plan, this.context);
            return false;
        }
        if (plan.getConsumeMunber().compareTo(existedConsumeMunber) < 0) {
            BigDecimal differenceNum = existedConsumeMunber.subtract(plan.getConsumeMunber());
            for (DeliveryPlan p : deliveryPlanLists) {
                if ("F".equals(p.getIsLock())) continue;
                if (differenceNum.compareTo(p.getConsumeMunber()) < 0) {
                    p.setConsumeMunber(p.getConsumeMunber().subtract(differenceNum));
                    break;
                }
                if (differenceNum.compareTo(p.getConsumeMunber()) == 0) {
                    p.setConsumeMunber(BigDecimal.ZERO);
                    break;
                }
                if (differenceNum.compareTo(p.getConsumeMunber()) <= 0) continue;
                differenceNum = differenceNum.subtract(p.getConsumeMunber());
                p.setConsumeMunber(BigDecimal.ZERO);
            }
        }
        return true;
    }

    private void savePlanAndPlanItem(DeliveryPlan plan, ICommandInvoker context) {
        this.DistributeSup(plan, context);
        ContextUtils.getDeliveryPlanService().addObj(plan);
        if (CollectionUtils.isNotEmpty(plan.getPlanItemList())) {
            CreateJitPlanItemCommand planItemCmd = new CreateJitPlanItemCommand(plan);
            context.invoke(planItemCmd);
        }
    }

    private List<JITMaterialDemand> getMaterialDemand() {
        List<Map<String, Object>> lists = ContextUtils.getJitMaterialDemandService().getApsMaterial();
        logger.info("EVENT=\u83b7\u53d6APS\u7269\u6599\u9700\u6c42\u6570\u636e|DATA=%1$s", (Object)new Gson().toJson(lists));
        List<JITMaterialDemand> demandList = lists.stream().map(map -> {
            Material material = this.getMaterial(map.get("ITEMCODE") + "");
            String jitItem = this.getMaterialJitItem(map.get("ITEMCODE") + "", map.get("FACTORY") + "");
            if (StringUtils.isNotBlank((String)jitItem)) {
                JITMaterialDemand demand = new JITMaterialDemand();
                demand.setMaterialCode(map.get("ITEMCODE") + "");
                demand.setMaterialDescribe(material.getDescription());
                demand.setJitItem(jitItem);
                demand.setUnit(material.getBasicUnit());
                demand.setFactoryCode(map.get("FACTORY") + "");
                demand.setFactoryName(this.getFactoryName(demand.getFactoryCode()));
                demand.setConsumeMunber((BigDecimal)map.get("QTY"));
                demand.setConsumeTime((Date)map.get("INVLET"));
                demand.setWayType((BigDecimal)map.get("INVTYPE"));
                return demand;
            }
            return null;
        }).filter(demand -> demand != null).collect(Collectors.toList());
        return demandList;
    }

    private String getMaterialJitItem(String materialCode, String factory) {
        MaterialExtExample example = new MaterialExtExample();
        example.createCriteria().andMaterialCodeEqualTo(materialCode).andFactoryEqualTo(factory);
        List materialExtList = ContextUtils.getMaterialService().queryMaterialExtByExampl(example);
        if (materialExtList.size() > 0) {
            return ((MaterialExt)materialExtList.get(0)).getJitItem();
        }
        return null;
    }

    private String getFactoryName(String factoryCode) {
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andCodeEqualTo(factoryCode).andOrganizationTypeEqualTo("T001W");
        List organizationList = ContextUtils.getOrganizationService().queryAllObjByExample((IExample)example);
        if (organizationList.size() > 0) {
            return ((Organization)organizationList.get(0)).getDescription();
        }
        return null;
    }

    private Material getMaterial(String materialCode) {
        MaterialExample example = new MaterialExample();
        example.createCriteria().andMaterialCodeEqualTo(materialCode);
        List materialList = ContextUtils.getMaterialService().queryAllObjByExample((IExample)example);
        if (materialList.size() > 0) {
            return (Material)materialList.get(0);
        }
        return new Material();
    }

    private BigDecimal currentLeadTime(String materialCode, String factoryCode) {
        JITLeadTimeExample example = new JITLeadTimeExample();
        example.createCriteria().andMaterialCodeEqualTo(materialCode).andFactoryCodeEqualTo(factoryCode);
        List lists = ContextUtils.getJitLeadTimeService().queryAllObjByExample((IExample)example);
        if (lists.size() == 0) {
            example.clear();
            example.createCriteria().andFactoryCodeEqualTo(factoryCode).andMaterialCodeIsNull();
            List factoryLists = ContextUtils.getJitLeadTimeService().queryAllObjByExample((IExample)example);
            if (factoryLists.size() == 0) {
                return null;
            }
            return ((JITLeadTime)factoryLists.get(0)).getTotalTime();
        }
        return ((JITLeadTime)lists.get(0)).getTotalTime();
    }

    private void DistributeSup(DeliveryPlan plan, ICommandInvoker context) {
        Material material = this.getMaterial(plan.getMaterialCode());
        BigDecimal numberRouding = new BigDecimal(material.getPurOrderNumberRouding());
        CompositeDataCommand command = new CompositeDataCommand(plan.getMaterialCode(), plan.getFactoryCode(), null);
        List<JITSupRef> jitSupRefList = context.invoke(command).stream().filter(jitSupRef -> jitSupRef.getCumulativeUndistributeMun() != null && jitSupRef.getCumulativeUndistributeMun().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (jitSupRefList.size() == 1) {
            JitPlanUtils.DistributeSupByOne(plan, (JITSupRef)jitSupRefList.get(0));
        }
        if ((jitSupRefList = jitSupRefList.stream().filter(jitSupRef -> jitSupRef.getQuota() != null).collect(Collectors.toList())).size() > 0) {
            BigDecimal undistributeMun;
            BigDecimal consumeMunber = plan.getConsumeMunber();
            BigDecimal bigDecimal = undistributeMun = ((JITSupRef)jitSupRefList.get(0)).getCumulativeUndistributeMun() == null ? BigDecimal.ZERO : ((JITSupRef)jitSupRefList.get(0)).getCumulativeUndistributeMun();
            if (this.isLessThanDistribution(plan, consumeMunber)) {
                JitPlanUtils.DistributeLessSupByMore(consumeMunber, undistributeMun, numberRouding, (JITSupRef)jitSupRefList.get(0), plan);
            } else {
                JitPlanUtils.DistributeGreaterSupByMore(consumeMunber, undistributeMun, numberRouding, jitSupRefList, plan);
            }
        }
    }

    private boolean isLessThanDistribution(DeliveryPlan plan, BigDecimal consumeMunber) {
        SupplierQuotaExample example = new SupplierQuotaExample();
        example.createCriteria().andMaterialCodeEqualTo(plan.getMaterialCode()).andFactoryCodeEqualTo(plan.getFactoryCode()).andIsEnableEqualTo(Constant.YES_INT);
        List lists = ContextUtils.getSupplierQuotaService().queryAllObjByExample((IExample)example);
        if (lists.size() > 0) {
            BigDecimal distribution = new BigDecimal(((SupplierQuota)lists.get(0)).getDistribution() == null ? 0 : ((SupplierQuota)lists.get(0)).getDistribution());
            return distribution.compareTo(consumeMunber) >= 0;
        }
        return false;
    }
}

