/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.planItem;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Constant;
import com.els.base.plan.command.jit.planItem.CloseOrderBackSapCommand;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.sap.ZSRMRFCGETELIKZ2;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.plan.utils.JitPlanUtils;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class CloseJitPlanItemAndOrderItemCommand
extends AbstractCommand<Map<String, Integer>> {
    private final String SUCCESS = "S";
    private List<PurDeliveryPlanItem> planItems;

    public CloseJitPlanItemAndOrderItemCommand(List<PurDeliveryPlanItem> planItems) {
        this.planItems = planItems;
    }

    @Override
    public Map<String, Integer> execute(ICommandInvoker context) {
        List<String> planItemIds = this.planItems.stream().map(item -> item.getId()).distinct().collect(Collectors.toList());
        JitPlanUtils.closePlanAndOrderValid(planItemIds);
        CloseOrderBackSapCommand command = new CloseOrderBackSapCommand(this.planItems);
        List<ZSRMRFCGETELIKZ2> responeData = context.invoke(command);
        ArrayList<PurDeliveryPlanItem> closeSuccessPlans = new ArrayList<PurDeliveryPlanItem>();
        ArrayList<PurDeliveryPlanItem> closeFailPlans = new ArrayList<PurDeliveryPlanItem>();
        this.divideData(closeSuccessPlans, closeFailPlans, this.planItems, responeData);
        if (CollectionUtils.isNotEmpty(closeSuccessPlans)) {
            this.updateCloseSuccessPlan(closeSuccessPlans);
        }
        if (CollectionUtils.isNotEmpty(closeFailPlans)) {
            this.updateCloseFailPlan(closeFailPlans);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("success", closeSuccessPlans.size());
        result.put("fail", closeFailPlans.size());
        return result;
    }

    private void updateCloseFailPlan(List<PurDeliveryPlanItem> closeFailPlans) {
        List planItemIds = closeFailPlans.stream().map(data -> data.getId()).distinct().collect(Collectors.toList());
        PurDeliveryPlanItemExample purExample = new PurDeliveryPlanItemExample();
        purExample.createCriteria().andIdIn(planItemIds);
        PurDeliveryPlanItem purDeliveryPlanItem = new PurDeliveryPlanItem();
        purDeliveryPlanItem.setUsedStatus(DeliveryPlanUesdStatusEnum.COLSE_FAIL.getValue());
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(purDeliveryPlanItem, purExample);
        SupDeliveryPlanItemExample supExample = new SupDeliveryPlanItemExample();
        supExample.createCriteria().andIdIn(planItemIds);
        SupDeliveryPlanItem supDeliveryPlanItem = new SupDeliveryPlanItem();
        supDeliveryPlanItem.setUsedStatus(DeliveryPlanUesdStatusEnum.COLSE_FAIL.getValue());
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(supDeliveryPlanItem, supExample);
    }

    private void updateCloseSuccessPlan(List<PurDeliveryPlanItem> closeSuccessPlans) {
        List<String> planItemIds = closeSuccessPlans.stream().map(data -> data.getId()).distinct().collect(Collectors.toList());
        List<String> orderItemIds = closeSuccessPlans.stream().map(data -> data.getPurOrderItemId()).distinct().collect(Collectors.toList());
        JitPlanUtils.closePlanItem(planItemIds);
        this.closeOrderItemIds(orderItemIds);
    }

    private void closeOrderItemIds(List<String> orderItemIds) {
        PurchaseOrderItemExample purExample = new PurchaseOrderItemExample();
        purExample.createCriteria().andIdIn((List)orderItemIds);
        PurchaseOrderItem purOrderItem = new PurchaseOrderItem();
        purOrderItem.setFinishFlag("Y");
        purOrderItem.setIsCanDelivery(Constant.NO_INT);
        ContextUtils.getPurchaseOrderItemService().modifyByExample(purOrderItem, purExample);
        SupplierOrderItemExample supExample = new SupplierOrderItemExample();
        supExample.createCriteria().andIdIn((List)orderItemIds);
        SupplierOrderItem supOrderItem = new SupplierOrderItem();
        supOrderItem.setFinishFlag("Y");
        supOrderItem.setIsCanDelivery(Constant.NO_INT);
        ContextUtils.getSupplierOrderItemService().modifyByExample(supOrderItem, supExample);
    }

    private void divideData(List<PurDeliveryPlanItem> closeSuccessPlans, List<PurDeliveryPlanItem> closeFailPlans, List<PurDeliveryPlanItem> planItems, List<ZSRMRFCGETELIKZ2> responeData) {
        List successKeys = responeData.stream().filter(data -> data.getTYPE().equals("S")).map(data -> data.getEBELN() + "_" + data.getEBELP()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(successKeys)) {
            closeFailPlans.addAll(planItems);
            return;
        }
        if (successKeys.size() == responeData.size()) {
            closeSuccessPlans.addAll(planItems);
            return;
        }
        planItems.stream().forEach(item -> {
            String key = item.getPurOrderNo() + "_" + item.getPurOrderItemNo();
            if (successKeys.contains(key)) {
                closeSuccessPlans.add((PurDeliveryPlanItem)item);
            } else {
                closeFailPlans.add((PurDeliveryPlanItem)item);
            }
        });
    }
}

