/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.planItem;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.plan.command.jit.plan.CreateJitChangeRecordCmd;
import com.els.base.plan.command.jit.plan.ModifyJitPlanAllocatedCmd;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class CreateJitPlanItemCommand
extends AbstractCommand<List<SupDeliveryPlanItem>> {
    private DeliveryPlan deliveryPlan;

    public CreateJitPlanItemCommand(DeliveryPlan deliveryPlan) {
        this.deliveryPlan = deliveryPlan;
    }

    @Override
    public List<SupDeliveryPlanItem> execute(ICommandInvoker context) {
        this.valid(this.deliveryPlan);
        List<SupDeliveryPlanItem> supDeliveryPlanItemList = this.initSupDeliveryPlanItem(this.deliveryPlan);
        CreateJitChangeRecordCmd command = new CreateJitChangeRecordCmd(supDeliveryPlanItemList);
        context.invoke(command);
        if (CollectionUtils.isNotEmpty(supDeliveryPlanItemList)) {
            this.addSupDeliveryPlanItem(supDeliveryPlanItemList);
            this.addPurDeliveryPlanItem(supDeliveryPlanItemList);
        }
        ModifyJitPlanAllocatedCmd cmd = new ModifyJitPlanAllocatedCmd(supDeliveryPlanItemList);
        context.invoke(cmd);
        return supDeliveryPlanItemList;
    }

    private void addSupDeliveryPlanItem(List<SupDeliveryPlanItem> supDeliveryPlanItemList) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andIsJitEqualTo(Constant.YES_INT).andUsedStatusEqualTo("N").andDeliveryDateEqualTo(supDeliveryPlanItemList.get(0).getDeliveryDate()).andMaterialNoEqualTo(supDeliveryPlanItemList.get(0).getMaterialNo()).andFactoryCodeEqualTo(supDeliveryPlanItemList.get(0).getFactoryCode());
        ContextUtils.getSupDeliveryPlanItemService().deleteByExample(example);
        ContextUtils.getSupDeliveryPlanItemService().addAll(supDeliveryPlanItemList);
    }

    private void addPurDeliveryPlanItem(List<SupDeliveryPlanItem> supDeliveryPlanItemList) {
        List purDeliveryPlanItemList = supDeliveryPlanItemList.stream().map(supDeliveryPlanItem -> {
            PurDeliveryPlanItem purDeliveryPlanItem = new PurDeliveryPlanItem();
            BeanUtils.copyProperties((Object)supDeliveryPlanItem, (Object)purDeliveryPlanItem);
            return purDeliveryPlanItem;
        }).collect(Collectors.toList());
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andIsJitEqualTo(Constant.YES_INT).andUsedStatusEqualTo("N").andDeliveryDateEqualTo(supDeliveryPlanItemList.get(0).getDeliveryDate());
        ContextUtils.getPurDeliveryPlanItemService().deleteByExample(example);
        ContextUtils.getPurDeliveryPlanItemService().addAll(purDeliveryPlanItemList);
    }

    private List<SupDeliveryPlanItem> initSupDeliveryPlanItem(DeliveryPlan deliveryPlan) {
        this.initSupDeliveryPlanItem(deliveryPlan, deliveryPlan.getPlanItemList());
        return deliveryPlan.getPlanItemList();
    }

    private void initSupDeliveryPlanItem(DeliveryPlan deliveryPlan, List<SupDeliveryPlanItem> planItemList) {
        MaterialExample example = new MaterialExample();
        planItemList.forEach(item -> {
            example.clear();
            item.setMaterialNo(deliveryPlan.getMaterialCode());
            item.setMaterialDesc(deliveryPlan.getMaterialDescride());
            item.setFactoryCode(deliveryPlan.getFactoryCode());
            item.setFactoryName(deliveryPlan.getFactoryName());
            item.setDeliveryDate(deliveryPlan.getArryvalTime());
            item.setConsumeMunber(deliveryPlan.getConsumeMunber());
            item.setJitItem(deliveryPlan.getJitItem());
            item.setIsJit(Constant.YES_INT);
            item.setIsEnable(item.getIsEnable() == null ? Constant.YES_INT : item.getIsEnable());
            item.setPlanId(deliveryPlan.getId());
            item.setSendStatus(item.getSendStatus() == null ? "N" : item.getSendStatus());
            item.setPlanSendStatus(item.getPlanSendStatus() == null ? "N" : item.getPlanSendStatus());
            item.setIsLock(deliveryPlan.getIsLock());
            item.setOrderUnit(deliveryPlan.getUnit());
            item.setCreateTime(new Date());
            item.setOnwayQuantity(BigDecimal.ZERO);
            item.setReceivedQuantity(BigDecimal.ZERO);
            item.setIsCanDelivery(Constant.YES_INT);
            item.setUsedStatus("N");
            item.setPurUserId(deliveryPlan.getPurUserId());
            item.setPurUserName(deliveryPlan.getPurUserName());
            example.createCriteria().andMaterialCodeEqualTo(deliveryPlan.getMaterialCode());
            List materials = ContextUtils.getMaterialService().queryAllObjByExample((IExample)example);
            if (CollectionUtils.isNotEmpty((Collection)materials)) {
                item.setMaterialGroup(((Material)materials.get(0)).getMaterialGroup());
                item.setExternalMaterialGroup(((Material)materials.get(0)).getExternalMaterialGroup());
            }
        });
    }

    private void valid(DeliveryPlan deliveryPlan) {
        Assert.isNotBlank((String)deliveryPlan.getMaterialCode(), (String)"\u7269\u6599\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deliveryPlan.getFactoryCode(), (String)"\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

