/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.planItem;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.plan.command.jit.plan.ModifyJitPlanAllocatedCmd;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class ModifyItemByImportCommand
extends AbstractCommand {
    private DeliveryPlan deliveryPlan;

    public ModifyItemByImportCommand(DeliveryPlan deliveryPlan) {
        this.deliveryPlan = deliveryPlan;
    }

    public List<SupDeliveryPlanItem> execute(ICommandInvoker context) {
        List<SupDeliveryPlanItem> supDeliveryPlanItemList = this.initSupDeliveryPlanItem(this.deliveryPlan);
        supDeliveryPlanItemList.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                this.addSupDeliveryPlanItem((SupDeliveryPlanItem)item);
                this.addPurDeliveryPlanItem((SupDeliveryPlanItem)item);
            } else {
                this.updateSupDeliveryPlanItem((SupDeliveryPlanItem)item);
                this.updatePurDeliveryPlanItem((SupDeliveryPlanItem)item);
            }
        });
        this.updateItemConsumeMunber(this.deliveryPlan);
        this.ModifyJitPlanAllocated(this.deliveryPlan.getId());
        return supDeliveryPlanItemList;
    }

    private void updateItemConsumeMunber(DeliveryPlan deliveryPlan) {
        ContextUtils.getSupDeliveryPlanItemService().updateConsumeMunber(deliveryPlan.getId(), deliveryPlan.getConsumeMunber());
        ContextUtils.getPurDeliveryPlanItemService().updateConsumeMunber(deliveryPlan.getId(), deliveryPlan.getConsumeMunber());
    }

    private void ModifyJitPlanAllocated(String id) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPlanIdEqualTo(id);
        List planItems = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        ModifyJitPlanAllocatedCmd cmd = new ModifyJitPlanAllocatedCmd(planItems);
        this.context.invoke(cmd);
    }

    private void addSupDeliveryPlanItem(SupDeliveryPlanItem item) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andIsJitEqualTo(Constant.YES_INT);
        criteria.andUsedStatusEqualTo("N");
        criteria.andDeliveryDateEqualTo(item.getDeliveryDate());
        criteria.andMaterialNoEqualTo(item.getMaterialNo());
        criteria.andFactoryCodeEqualTo(item.getFactoryCode());
        criteria.andSupCompanySapCodeEqualTo(item.getSupCompanySapCode());
        ContextUtils.getSupDeliveryPlanItemService().deleteByExample(example);
        ContextUtils.getSupDeliveryPlanItemService().addObj(item);
    }

    private void addPurDeliveryPlanItem(SupDeliveryPlanItem item) {
        PurDeliveryPlanItem purDeliveryPlanItem = new PurDeliveryPlanItem();
        BeanUtils.copyProperties((Object)item, (Object)purDeliveryPlanItem);
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        PurDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andIsJitEqualTo(Constant.YES_INT);
        criteria.andUsedStatusEqualTo("N");
        criteria.andDeliveryDateEqualTo(item.getDeliveryDate());
        criteria.andMaterialNoEqualTo(item.getMaterialNo());
        criteria.andFactoryCodeEqualTo(item.getFactoryCode());
        criteria.andSupCompanySapCodeEqualTo(item.getSupCompanySapCode());
        ContextUtils.getPurDeliveryPlanItemService().deleteByExample(example);
        ContextUtils.getPurDeliveryPlanItemService().addObj(purDeliveryPlanItem);
    }

    private void updatePurDeliveryPlanItem(SupDeliveryPlanItem item) {
        SupDeliveryPlanItem updateItem = new SupDeliveryPlanItem();
        updateItem.setId(item.getId());
        updateItem.setDeliveryQuantity(item.getDeliveryQuantity());
        updateItem.setPlanId(item.getPlanId());
        updateItem.setDeliveryDate(item.getDeliveryDate());
        updateItem.setConsumeMunber(item.getConsumeMunber());
        updateItem.setIsCanDelivery(item.getIsCanDelivery());
        updateItem.setUsedStatus(item.getUsedStatus());
        ContextUtils.getSupDeliveryPlanItemService().modifyObj(updateItem);
    }

    private void updateSupDeliveryPlanItem(SupDeliveryPlanItem item) {
        PurDeliveryPlanItem updateItem = new PurDeliveryPlanItem();
        updateItem.setId(item.getId());
        updateItem.setDeliveryQuantity(item.getDeliveryQuantity());
        updateItem.setPlanId(item.getPlanId());
        updateItem.setDeliveryDate(item.getDeliveryDate());
        updateItem.setConsumeMunber(item.getConsumeMunber());
        updateItem.setIsCanDelivery(item.getIsCanDelivery());
        updateItem.setUsedStatus(item.getUsedStatus());
        ContextUtils.getPurDeliveryPlanItemService().modifyObj(updateItem);
    }

    private List<SupDeliveryPlanItem> initSupDeliveryPlanItem(DeliveryPlan deliveryPlan) {
        this.initSupDeliveryPlanItem(deliveryPlan, deliveryPlan.getPlanItemList());
        return deliveryPlan.getPlanItemList();
    }

    private void initSupDeliveryPlanItem(DeliveryPlan deliveryPlan, List<SupDeliveryPlanItem> planItemList) {
        planItemList.forEach(item -> {
            item.setPlanId(deliveryPlan.getId());
            item.setDeliveryDate(deliveryPlan.getArryvalTime());
            item.setConsumeMunber(deliveryPlan.getConsumeMunber());
            item.setIsLock(deliveryPlan.getIsLock());
            item.setPurUserId(deliveryPlan.getPurUserId());
            item.setPurUserName(deliveryPlan.getPurUserName());
            item.setIsJit(Constant.YES_INT);
            item.setIsEnable(item.getIsEnable() == null ? Constant.YES_INT : item.getIsEnable());
            item.setSendStatus(item.getSendStatus() == null ? "N" : item.getSendStatus());
            item.setPlanSendStatus(item.getPlanSendStatus() == null ? "N" : item.getPlanSendStatus());
            if (StringUtils.isNotBlank((String)item.getId())) {
                return;
            }
            item.setCreateTime(new Date());
            item.setPurUserId(this.getPurUser().getId());
            item.setPurUserName(this.getPurUser().getNickName());
            item.setOnwayQuantity(BigDecimal.ZERO);
            item.setReceivedQuantity(BigDecimal.ZERO);
            item.setIsCanDelivery(Constant.YES_INT);
            item.setUsedStatus("N");
        });
    }
}

