/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.utils.ChangeReasonEnum;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class NoneJitPlanPurConfirmCmd
extends AbstractCommand<List<PurDeliveryPlanItem>> {
    private static final long serialVersionUID = 1L;
    private List<PurDeliveryPlanItem> planList;

    public NoneJitPlanPurConfirmCmd(List<PurDeliveryPlanItem> planList) {
        this.planList = planList;
    }

    @Override
    public List<PurDeliveryPlanItem> execute(ICommandInvoker context) {
        this.valid(this.planList);
        return this.confirmNoneJitPlanList(this.planList);
    }

    private void valid(List<PurDeliveryPlanItem> planList) {
        Assert.isNotEmpty(planList, (String)"\u8981\u786e\u8ba4\u7684\u8ba2\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        for (PurDeliveryPlanItem plan : planList) {
            Assert.isNotBlank((String)plan.getPurOrderNo(), (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getPurOrderItemNo(), (String)"\u8ba2\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getPurOrderItemId(), (String)"\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
            if (PlanChangeStatusEnum.PUR_CONFIRM.getValue().equals(plan.getChangeStatus())) continue;
            throw new CommonException(String.format("\u4ea4\u8d27\u8ba1\u5212 [%s][%s] \u786e\u8ba4\u7684\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38", plan.getPurOrderNo(), plan.getPurOrderItemNo()));
        }
        List orderNoList = planList.stream().map(PurDeliveryPlanItem::getPurOrderNo).distinct().collect(Collectors.toList());
        List orderItemNoList = planList.stream().map(PurDeliveryPlanItem::getPurOrderItemNo).distinct().collect(Collectors.toList());
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderNoIn(orderNoList).andPurOrderItemNoIn(orderItemNoList).andIsJitEqualTo(Constant.YES_INT);
        List tmpPlanList = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)tmpPlanList)) {
            throw new CommonException(String.format("\u65e0\u6cd5\u53d8\u66f4JIT\u7269\u6599\u7684\u9001\u8d27\u901a\u77e5\u5355,[%s][%s]", ((PurDeliveryPlanItem)tmpPlanList.get(0)).getPurOrderNo(), ((PurDeliveryPlanItem)tmpPlanList.get(0)).getPurOrderItemNo()));
        }
        example.clear();
        example.createCriteria().andPurOrderNoIn(orderNoList).andPurOrderItemNoIn(orderItemNoList).andSupConfirmStatusNotEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        tmpPlanList = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)tmpPlanList)) {
            String errMsg = String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s]\u786e\u8ba4\u5931\u8d25\uff0c\u56e0\u4e3a\u4f9b\u5e94\u5546\u672a\u786e\u8ba4", ((PurDeliveryPlanItem)tmpPlanList.get(0)).getPurOrderNo(), ((PurDeliveryPlanItem)tmpPlanList.get(0)).getPurOrderItemNo());
            throw new CommonException(errMsg);
        }
    }

    private List<PurDeliveryPlanItem> confirmNoneJitPlanList(List<PurDeliveryPlanItem> planList) {
        Map<String, List<PurDeliveryPlanItem>> orderNoAndPlanList = planList.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderNo));
        Set<String> orderNoSet = orderNoAndPlanList.keySet();
        for (String orderNo : orderNoSet) {
            this.confirmNoneJitPlanList(orderNo, orderNoAndPlanList.get(orderNo));
        }
        return planList;
    }

    private List<PurDeliveryPlanItem> confirmNoneJitPlanList(String orderNo, List<PurDeliveryPlanItem> planList) {
        Map<String, List<PurDeliveryPlanItem>> orderItemNoAndPlanList = planList.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderItemNo));
        Set<String> orderItemNoSet = orderItemNoAndPlanList.keySet();
        for (String orderItemNo : orderItemNoSet) {
            List<PurDeliveryPlanItem> noneJitPlanLis = orderItemNoAndPlanList.get(orderItemNo);
            this.updateStatus(noneJitPlanLis);
        }
        return planList;
    }

    private void updateStatus(List<PurDeliveryPlanItem> noneJitPlanLis) {
        Date confirmTime = new Date();
        for (PurDeliveryPlanItem tmpPurPlan : noneJitPlanLis) {
            tmpPurPlan.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            tmpPurPlan.setPurUserId(this.getPurUser().getId());
            tmpPurPlan.setPurUserName(this.getPurUser().getNickName());
            tmpPurPlan.setChangeStatus(PlanChangeStatusEnum.PUR_CONFIRM.getValue());
            tmpPurPlan.setConfirmTime(confirmTime);
            if (!ChangeReasonEnum.PUR.getValue().equals(tmpPurPlan.getChangeReason())) continue;
            tmpPurPlan.setConfirmDeliveryDate(tmpPurPlan.getDeliveryDate());
        }
    }
}

