/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.PurchaseOrderChangeUtils;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderIsEnableEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class NoneJitPlanResetCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrder order;

    public NoneJitPlanResetCmd(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.order);
        for (PurchaseOrderItem item : this.order.getItems()) {
            SupplierOrderItem oldSupItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(item.getId());
            if (oldSupItem != null && Constant.NO_INT.equals(oldSupItem.getIsEnable()) && Constant.NO_INT.equals(item.getIsEnable()) || oldSupItem != null && "Y".equals(oldSupItem.getFinishFlag()) && "Y".equals(item.getFinishFlag()) || oldSupItem != null && !PurchaseOrderChangeUtils.isChangeDeliveryDate(item, oldSupItem)) continue;
            this.spiltUnfinishedPlanItem(item.getId());
            this.deleteUnSendPlanItem(item.getId());
            if ("Y".equals(this.order.getReturnFlag())) continue;
            this.addPlanItem(item);
        }
        return null;
    }

    private void spiltUnfinishedPlanItem(String id) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderItemIdEqualTo(id).andOnwayQuantityGreaterThan(BigDecimal.ZERO).andIsCanDeliveryEqualTo(Constant.YES_INT);
        example.or().andPurOrderItemIdEqualTo(id).andReceivedQuantityGreaterThan(BigDecimal.ZERO).andIsCanDeliveryEqualTo(Constant.YES_INT);
        List planItemList = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)planItemList)) {
            return;
        }
        for (PurDeliveryPlanItem planItem : planItemList) {
            BigDecimal onwayQuantity = planItem.getOnwayQuantity();
            onwayQuantity = onwayQuantity == null ? BigDecimal.ZERO : onwayQuantity;
            BigDecimal receiveQuantity = planItem.getReceivedQuantity();
            receiveQuantity = receiveQuantity == null ? BigDecimal.ZERO : receiveQuantity;
            PurDeliveryPlanItem temp = new PurDeliveryPlanItem();
            temp.setId(planItem.getId());
            temp.setDeliveryQuantity(onwayQuantity.add(receiveQuantity));
            temp.setIsCanDelivery(Constant.NO_INT);
            temp.setUsedStatus(DeliveryPlanUesdStatusEnum.ALL_USED.getValue());
            ContextUtils.getPurDeliveryPlanItemService().modifyObj(temp);
        }
    }

    private void addPlanItem(PurchaseOrderItem item) {
        if (!PurchaseOrderIsEnableEnum.ENABLE.getValue().equals(item.getIsEnable()) || Constant.YES_INT.equals(item.getIsJit()) || "Y".equals(item.getFinishFlag()) || BigDecimal.ZERO.compareTo(item.getCanDeliveryQuantity()) >= 0) {
            return;
        }
        PurDeliveryPlanItem planItem = DeliveryPlanUtils.buildPlanItem(item, this.order);
        planItem.setSendStatus("N");
        planItem.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        planItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        planItem.setChangeStatus(PlanChangeStatusEnum.PUR_CHANGE.getValue());
        planItem.setDeliveryQuantity(item.getCanDeliveryQuantity());
        planItem.setPurOrderStatus(this.order.getOrderStatus());
        ContextUtils.getPurDeliveryPlanItemService().addObj(planItem);
    }

    private void valid(PurchaseOrder order) {
        Assert.isNotNull((Object)order, (String)"\u8ba2\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(order.getItems(), (String)"\u8ba2\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        order.getItems().forEach(this::valid);
    }

    private void deleteUnSendPlanItem(String itemId) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderItemIdEqualTo(itemId).andIsCanDeliveryEqualTo(Constant.YES_INT);
        ContextUtils.getPurDeliveryPlanItemService().deleteByExample(example);
    }

    private void valid(PurchaseOrderItem orderItem) {
        Assert.isNotBlank((String)orderItem.getId(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)orderItem.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)orderItem.getDeliveredDate(), (String)"\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)orderItem.getFactory(), (String)"\u8ba2\u5355\u884c\u5de5\u5382\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)orderItem.getQuantity());
    }
}

