/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.ChangeReasonEnum;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;

public class ImportSupForUnConfirmOrderCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private SupplierOrder order;
    private List<SupDeliveryPlanItem> list;

    public ImportSupForUnConfirmOrderCmd(SupplierOrder order, List<SupDeliveryPlanItem> list) {
        this.order = order;
        this.list = list;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Map<String, List<SupDeliveryPlanItem>> orderItemNoAndPlanList = this.list.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurOrderItemNo));
        ArrayList<String> orderItemNoList = new ArrayList<String>();
        orderItemNoList.addAll(orderItemNoAndPlanList.keySet());
        orderItemNoList.sort(String::compareTo);
        orderItemNoList.forEach(orderItemNo -> {
            SupplierOrderItem orderItem = this.queryItem(this.order, (String)orderItemNo);
            List planItemList = (List)orderItemNoAndPlanList.get(orderItemNo);
            this.validPlanItemList(orderItem, planItemList);
            this.importPlanItemForOrderItem(this.order, orderItem, planItemList);
        });
        return null;
    }

    private SupplierOrderItem queryItem(SupplierOrder order, String orderItemNo) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.createCriteria().andOrderNoEqualTo(order.getOrderNo()).andOrderItemNoEqualTo(orderItemNo);
        List itemList = ContextUtils.getSupplierOrderItemService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)itemList, (String)String.format("\u8ba2\u5355\u884c\u9879\u76ee\u4e0d\u5b58\u5728[%s][%s]", order.getOrderNo(), orderItemNo));
        return (SupplierOrderItem)itemList.get(0);
    }

    private void validPlanItemList(SupplierOrderItem orderItem, List<SupDeliveryPlanItem> planItemList) {
        BigDecimal sumQuantity = planItemList.stream().map(SupDeliveryPlanItem::getDeliveryQuantity).reduce(BigDecimal::add).get();
        if (orderItem.getCanDeliveryQuantity().compareTo(sumQuantity) > 0) {
            BigDecimal q = orderItem.getCanDeliveryQuantity().subtract(sumQuantity);
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf \u6bd4\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u5c11 [%s]", orderItem.getOrderNo(), orderItem.getOrderItemNo(), q.toString()));
        }
        if (orderItem.getCanDeliveryQuantity().compareTo(sumQuantity) < 0) {
            BigDecimal q = sumQuantity.subtract(orderItem.getCanDeliveryQuantity());
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf \u6bd4\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u591a [%s]", orderItem.getOrderNo(), orderItem.getOrderItemNo(), q.toString()));
        }
    }

    private void importPlanItemForOrderItem(SupplierOrder order, SupplierOrderItem orderItem, List<SupDeliveryPlanItem> list) {
        List<PurDeliveryPlanItem> currentPlanItemList = this.queryPlanItem(orderItem.getOrderNo(), orderItem.getOrderItemNo());
        Assert.isNotNull(currentPlanItemList, (String)String.format("\u8ba2\u5355\u884c[%s][%s]\u6ca1\u6709\u8ba1\u5212", orderItem.getOrderNo(), orderItem.getOrderItemNo()));
        if (DeliveryPlanUtils.isEqualBewteenPurAndSup(currentPlanItemList, list)) {
            this.confirmPlan(orderItem, currentPlanItemList, list);
            this.confirmOrderItem(orderItem);
        } else {
            this.refusePlan(currentPlanItemList.get(0), list);
            this.refuseOrderItem(orderItem);
        }
    }

    private void confirmOrderItem(SupplierOrderItem orderItem) {
        SupplierOrderItem temp = new SupplierOrderItem();
        temp.setId(orderItem.getId());
        temp.setIsRefuseDeliveredDate(Constant.NO_INT);
        ContextUtils.getSupplierOrderItemService().modifyObj(temp);
    }

    private void confirmPlan(SupplierOrderItem orderItem, List<PurDeliveryPlanItem> purPlanItemList, List<SupDeliveryPlanItem> supPlanItemList) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPurOrderNoEqualTo(orderItem.getOrderNo()).andPurOrderItemNoEqualTo(orderItem.getOrderItemNo());
        ContextUtils.getSupDeliveryPlanItemService().deleteByExample(example);
        Date now = new Date();
        List newSupPlanItemList = purPlanItemList.stream().map(purPlanItem -> {
            SupDeliveryPlanItem supPlanItem = new SupDeliveryPlanItem();
            BeanUtils.copyProperties((Object)purPlanItem, (Object)supPlanItem);
            supPlanItem.setChangeStatus(PlanChangeStatusEnum.SUP_CONFIRM.getValue());
            supPlanItem.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            supPlanItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            supPlanItem.setSupRemark(this.findSupPlan((PurDeliveryPlanItem)purPlanItem, supPlanItemList).getSupRemark());
            supPlanItem.setSupUserName(this.getSupUser().getId());
            supPlanItem.setSupUserName(this.getSupUser().getNickName());
            supPlanItem.setConfirmTime(now);
            if (ChangeReasonEnum.PUR.getValue().equals(purPlanItem.getChangeReason())) {
                supPlanItem.setConfirmDeliveryDate(purPlanItem.getDeliveryDate());
            }
            return supPlanItem;
        }).collect(Collectors.toList());
        ContextUtils.getSupDeliveryPlanItemService().addAll(newSupPlanItemList);
    }

    private SupDeliveryPlanItem findSupPlan(PurDeliveryPlanItem purPlanItem, List<SupDeliveryPlanItem> supPlanItemList) {
        String date = DateFormatUtils.format((Date)purPlanItem.getDeliveryDate(), (String)"yyyy-MM-dd");
        return supPlanItemList.stream().filter(supPlanItem -> DateFormatUtils.format((Date)supPlanItem.getDeliveryDate(), (String)"yyyy-MM-dd").equals(date) && supPlanItem.getDeliveryQuantity().compareTo(purPlanItem.getDeliveryQuantity()) == 0 && supPlanItem.getPurOrderNo().equals(purPlanItem.getPurOrderNo()) && supPlanItem.getPurOrderItemNo().equals(purPlanItem.getPurOrderItemNo())).findAny().get();
    }

    private void refuseOrderItem(SupplierOrderItem orderItem) {
        SupplierOrderItem temp = new SupplierOrderItem();
        temp.setId(orderItem.getId());
        temp.setIsRefuseDeliveredDate(Constant.YES_INT);
        temp.setOrderStatus(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
        ContextUtils.getSupplierOrderItemService().modifyObj(temp);
    }

    private void refusePlan(PurDeliveryPlanItem purDeliveryPlanItem, List<SupDeliveryPlanItem> supPlanList) {
        Assert.isNotEmpty(supPlanList, (String)"\u62d2\u7edd\u7684\u4f9b\u5e94\u5546\u8ba1\u5212\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        List orderNoList = supPlanList.stream().map(SupDeliveryPlanItem::getPurOrderNo).distinct().collect(Collectors.toList());
        List orderItemNoList = supPlanList.stream().map(SupDeliveryPlanItem::getPurOrderItemNo).distinct().collect(Collectors.toList());
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPurOrderNoIn(orderNoList).andPurOrderItemNoIn(orderItemNoList);
        ContextUtils.getSupDeliveryPlanItemService().deleteByExample(example);
        List refusePlanList = supPlanList.stream().map(planItem -> {
            SupDeliveryPlanItem temp = new SupDeliveryPlanItem();
            BeanUtils.copyProperties((Object)purDeliveryPlanItem, (Object)temp);
            temp.setDeliveryDate(planItem.getDeliveryDate());
            temp.setDeliveryQuantity(planItem.getDeliveryQuantity());
            temp.setSupRemark(planItem.getSupRemark());
            temp.setChangeReason(planItem.getChangeReason());
            temp.setChangeStatus(PlanChangeStatusEnum.SUP_CHANGE.getValue());
            temp.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            temp.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            temp.setSupUserId(this.getSupUser().getId());
            temp.setSupUserName(this.getSupUser().getNickName());
            temp.setId(null);
            return temp;
        }).collect(Collectors.toList());
        ContextUtils.getSupDeliveryPlanItemService().addAll(refusePlanList);
    }

    private List<PurDeliveryPlanItem> queryPlanItem(String orderNo, String orderItemNo) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderNoEqualTo(orderNo).andPurOrderItemNoEqualTo(orderItemNo);
        return ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
    }
}

