/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.log;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.ChangeReasonEnum;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderLog;
import com.els.base.purchase.entity.PurchaseOrderLogExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderOperationTypeEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class CreateOperationLogCommand
extends AbstractCommand<String>
implements Runnable {
    private static final long serialVersionUID = 1L;
    PurchaseOrder purchaseOrder;
    PurchaseOrderOperationTypeEnum operationType;
    SupplierOrder supplierOrder;
    private List<PurDeliveryPlanItem> purPlanItemList;
    private String logOperateId = UUIDGenerator.generateUUID();
    private List<PurchaseOrderItem> purOrderItemList;

    public CreateOperationLogCommand(PurchaseOrder order, PurchaseOrderOperationTypeEnum operationType) {
        this.purchaseOrder = order;
        this.operationType = operationType;
    }

    public CreateOperationLogCommand(SupplierOrder supplierOrder, PurchaseOrderOperationTypeEnum operationType) {
        this.supplierOrder = supplierOrder;
        this.operationType = operationType;
    }

    public CreateOperationLogCommand(List<PurDeliveryPlanItem> purPlanItemList, PurchaseOrderOperationTypeEnum operationType) {
        this.purPlanItemList = purPlanItemList;
        this.operationType = operationType;
    }

    public CreateOperationLogCommand(PurchaseOrderOperationTypeEnum operationType) {
        this.operationType = operationType;
    }

    public void setPurOrderItemList(List<PurchaseOrderItem> purOrderItemList) {
        this.purOrderItemList = purOrderItemList;
    }

    @Override
    public String execute(ICommandInvoker context) {
        ContextUtils.getThreadPoolTaskExecutor().execute((Runnable)this);
        return null;
    }

    @Override
    public void run() {
        try {
            this.createLog();
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u91c7\u8d2d\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
    }

    private void insertLog(List<PurchaseOrderLog> logList) {
        if (CollectionUtils.isEmpty(logList)) {
            return;
        }
        Date now = new Date();
        logList.forEach(log -> {
            log.setCreateTime(now);
            log.setId(null);
        });
        ContextUtils.getPurchaseOrderLogService().addAll(logList);
    }

    private void createLog() {
        if (this.operationType == null) {
            throw new CommonException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (this.operationType) {
            case CREATE_ORDER: 
            case SENT_TO_SUP: 
            case MODIFY_ORDER: {
                this.createForAddOrEditPurchase(this.purchaseOrder);
                return;
            }
            case CONFIRM: {
                this.createForConfirm(this.supplierOrder);
                return;
            }
            case REFUSE: {
                this.createForRefuse(this.supplierOrder);
                return;
            }
            case PLAN_CHANGE: 
            case PLAN_CONFIRM: {
                this.createForPurPlanChange(this.purPlanItemList);
                return;
            }
            case CONFIRM_TEMP_PRICE: {
                this.createForConfirmPrice(this.purOrderItemList);
                return;
            }
        }
        throw new CommonException(String.format("\u64cd\u4f5c\u7c7b\u578b[%s]\u65e0\u6cd5\u8bc6\u522b", this.operationType.getValue()));
    }

    private void createForConfirmPrice(List<PurchaseOrderItem> purOrderItemList) {
        if (CollectionUtils.isEmpty(purOrderItemList)) {
            return;
        }
        List<PurchaseOrderLog> logs = purOrderItemList.stream().map(item -> {
            PurchaseOrderLog log = new PurchaseOrderLog();
            BeanUtils.copyProperties((Object)item, (Object)log);
            log.setChangeType(this.operationType.getValue());
            log.setPurOrderId(item.getOrderId());
            log.setPurOrderItemId(item.getId());
            log.setRemark(item.getPurRemark());
            log.setLogOperateId(this.logOperateId);
            log.setFactoryCode(item.getFactory());
            log.setFactoryName(item.getFactoryName());
            log.setLogOperateType(ChangeReasonEnum.PUR.getValue());
            log.setIsCheck(Constant.YES_INT);
            if (this.getPurUser() != null) {
                log.setUserId(this.getPurUser().getId());
                log.setUserName(this.getPurUser().getNickName());
            }
            return log;
        }).collect(Collectors.toList());
        this.insertLog(logs);
    }

    private void createForPurPlanChange(List<PurDeliveryPlanItem> planItemList) {
        if (CollectionUtils.isEmpty(planItemList)) {
            return;
        }
        List<PurchaseOrderLog> logs = planItemList.stream().map(planItem -> {
            PurchaseOrderLog log = new PurchaseOrderLog();
            BeanUtils.copyProperties((Object)planItem, (Object)log);
            log.setLogOperateId(this.logOperateId);
            log.setPurOrderId(planItem.getPurOrderId());
            log.setPurOrderItemId(planItem.getPurOrderItemId());
            log.setOrderNo(planItem.getPurOrderNo());
            log.setOrderItemNo(planItem.getPurOrderItemNo());
            log.setPlanItemId(planItem.getId());
            if (PlanChangeStatusEnum.PUR_CHANGE.getValue().equals(planItem.getChangeStatus()) || PlanChangeStatusEnum.SUP_CHANGE.getValue().equals(planItem.getChangeStatus())) {
                log.setChangeType(PurchaseOrderOperationTypeEnum.PLAN_CHANGE.getValue());
                log.setRemark(planItem.getPurRemark());
                log.setIsCheck(Constant.YES_INT);
            } else if (PlanChangeStatusEnum.PUR_CONFIRM.getValue().equals(planItem.getChangeStatus()) || PlanChangeStatusEnum.SUP_CONFIRM.getValue().equals(planItem.getChangeStatus())) {
                log.setChangeType(PurchaseOrderOperationTypeEnum.PLAN_CONFIRM.getValue());
                log.setIsCheck(Constant.NO_INT);
            }
            if ((PlanChangeStatusEnum.PUR_CHANGE.getValue().equals(planItem.getChangeStatus()) || PlanChangeStatusEnum.PUR_CONFIRM.getValue().equals(planItem.getChangeStatus())) && this.getPurUser() != null) {
                log.setUserId(this.getPurUser().getId());
                log.setUserName(this.getPurUser().getNickName());
                log.setLogOperateType(ChangeReasonEnum.PUR.getValue());
            }
            if ((PlanChangeStatusEnum.SUP_CHANGE.getValue().equals(planItem.getChangeStatus()) || PlanChangeStatusEnum.SUP_CONFIRM.getValue().equals(planItem.getChangeStatus())) && this.getSupUser() != null) {
                log.setUserId(this.getSupUser().getId());
                log.setUserName(this.getSupUser().getNickName());
                log.setLogOperateType(ChangeReasonEnum.SUP.getValue());
            }
            return log;
        }).filter(this.toDuplicate()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(logs)) {
            return;
        }
        if (((PurchaseOrderLog)logs.get(0)).getLogOperateType().equals(ChangeReasonEnum.PUR.getValue())) {
            this.updateLastesOperate(ChangeReasonEnum.PUR.getValue(), planItemList);
            this.updatePlanReplyTime(ChangeReasonEnum.SUP.getValue(), planItemList);
            this.insertLog(logs);
        } else {
            this.updateLastesOperate(ChangeReasonEnum.SUP.getValue(), planItemList);
            this.updatePlanReplyTime(ChangeReasonEnum.PUR.getValue(), planItemList);
            this.insertLog(logs);
        }
    }

    private void updatePlanReplyTime(String logOperateType, List<PurDeliveryPlanItem> planItemList) {
        if (CollectionUtils.isEmpty(planItemList)) {
            return;
        }
        List orderItemIdList = planItemList.stream().map(PurDeliveryPlanItem::getPurOrderItemId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderItemIdList)) {
            return;
        }
        PurchaseOrderLogExample example = new PurchaseOrderLogExample();
        example.createCriteria().andPurOrderItemIdIn(orderItemIdList).andLogOperateTypeEqualTo(logOperateType).andChangeTypeEqualTo(PurchaseOrderOperationTypeEnum.PLAN_CHANGE.getValue()).andIsCheckEqualTo(Constant.YES_INT).andReplyTimeIsNull();
        PurchaseOrderLog tmp2 = new PurchaseOrderLog();
        tmp2.setReplyTime(new Date());
        ContextUtils.getPurchaseOrderLogService().modifyByExample(tmp2, example);
    }

    private void updateLastesOperate(String logOperateType, List<PurDeliveryPlanItem> planItemList) {
        if (CollectionUtils.isEmpty(planItemList)) {
            return;
        }
        List ordreItemIdList = planItemList.stream().map(PurDeliveryPlanItem::getPurOrderItemId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ordreItemIdList)) {
            return;
        }
        PurchaseOrderLogExample example = new PurchaseOrderLogExample();
        example.createCriteria().andPurOrderItemIdIn(ordreItemIdList).andLogOperateTypeEqualTo(logOperateType).andChangeTypeEqualTo(PurchaseOrderOperationTypeEnum.PLAN_CHANGE.getValue()).andIsCheckEqualTo(Constant.YES_INT).andReplyTimeIsNull();
        PurchaseOrderLog tmp2 = new PurchaseOrderLog();
        tmp2.setIsCheck(Constant.NO_INT);
        ContextUtils.getPurchaseOrderLogService().modifyByExample(tmp2, example);
    }

    private Predicate<? super PurchaseOrderLog> toDuplicate() {
        HashSet orderItemNo = new HashSet();
        return log -> orderItemNo.add(log.getPlanItemId());
    }

    private void createForRefuse(SupplierOrder supplierOrder) {
        List<SupDeliveryPlanItem> supPlanItemList;
        List<PurchaseOrderLog> planItemChangeLogs;
        PurchaseOrderLog log = new PurchaseOrderLog();
        BeanUtils.copyProperties((Object)supplierOrder, (Object)log);
        log.setChangeType(this.operationType.getValue());
        log.setLogOperateId(this.logOperateId);
        log.setPurOrderId(supplierOrder.getId());
        log.setLogOperateType(ChangeReasonEnum.SUP.getValue());
        log.setIsRefuseDeliveredDate(null);
        log.setIsRefusePrice(null);
        log.setIsRefuseQuantity(null);
        log.setIsCheck(Constant.YES_INT);
        log.setReplyTime(null);
        if (this.getSupUser() != null) {
            log.setUserId(this.getSupUser().getId());
            log.setUserName(this.getSupUser().getNickName());
        } else {
            log.setUserId(supplierOrder.getSupUserId());
            log.setUserId(supplierOrder.getSupUserName());
        }
        ArrayList<PurchaseOrderLog> logs = new ArrayList<PurchaseOrderLog>();
        logs.add(log);
        List<SupplierOrderItem> items = supplierOrder.getItems().stream().filter(item -> !PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(item.getOrderStatus())).collect(Collectors.toList());
        List<PurchaseOrderLog> orderItemChangeLogs = this.createForRefuseItems(items);
        if (CollectionUtils.isNotEmpty(orderItemChangeLogs)) {
            logs.addAll(orderItemChangeLogs);
        }
        if (CollectionUtils.isNotEmpty(planItemChangeLogs = this.createForSupPlanChange(supPlanItemList = supplierOrder.getPlanItemList().stream().filter(planItem -> PlanChangeStatusEnum.SUP_CHANGE.getValue().equals(planItem.getChangeStatus())).collect(Collectors.toList())))) {
            logs.addAll(planItemChangeLogs);
        }
        this.updateOrderReplyTime(supplierOrder);
        this.insertLog(logs);
    }

    private List<PurchaseOrderLog> createForSupPlanChange(List<SupDeliveryPlanItem> supPlanItemList) {
        if (CollectionUtils.isEmpty(supPlanItemList)) {
            return null;
        }
        List logs = supPlanItemList.stream().map(planItem -> {
            PurchaseOrderLog log = new PurchaseOrderLog();
            BeanUtils.copyProperties((Object)planItem, (Object)log);
            log.setLogOperateId(this.logOperateId);
            log.setPurOrderId(planItem.getPurOrderId());
            log.setPurOrderItemId(planItem.getPurOrderItemId());
            log.setOrderNo(planItem.getPurOrderNo());
            log.setOrderItemNo(planItem.getPurOrderItemNo());
            log.setPlanItemId(planItem.getId());
            log.setUserId(this.getSupUser().getId());
            log.setUserName(this.getSupUser().getNickName());
            log.setChangeType(PurchaseOrderOperationTypeEnum.PLAN_CHANGE.getValue());
            log.setLogOperateType(ChangeReasonEnum.SUP.getValue());
            log.setRemark(planItem.getPurRemark());
            log.setIsCheck(Constant.YES_INT);
            return log;
        }).collect(Collectors.toList());
        return logs.stream().filter(this.toDuplicate()).collect(Collectors.toList());
    }

    private List<PurchaseOrderLog> createForRefuseItems(List<SupplierOrderItem> items) {
        if (CollectionUtils.isEmpty(items)) {
            return null;
        }
        return items.stream().map(item -> {
            PurchaseOrderLog log = new PurchaseOrderLog();
            BeanUtils.copyProperties((Object)item, (Object)log);
            log.setChangeType(PurchaseOrderOperationTypeEnum.REFUSE_ORDER_ITEM.getValue());
            log.setPurOrderId(item.getOrderId());
            log.setPurOrderItemId(item.getId());
            log.setRemark(item.getSupRemark());
            log.setLogOperateId(this.logOperateId);
            log.setFactoryCode(item.getFactory());
            log.setFactoryName(item.getFactoryName());
            log.setLogOperateType(ChangeReasonEnum.SUP.getValue());
            log.setIsCheck(Constant.YES_INT);
            if (this.getSupUser() != null) {
                log.setUserId(this.getSupUser().getId());
                log.setUserName(this.getSupUser().getNickName());
            }
            return log;
        }).collect(Collectors.toList());
    }

    private void createForConfirm(SupplierOrder supplierOrder) {
        PurchaseOrderLog log = new PurchaseOrderLog();
        BeanUtils.copyProperties((Object)supplierOrder, (Object)log);
        log.setChangeType(this.operationType.getValue());
        log.setPurOrderId(supplierOrder.getId());
        log.setLogOperateId(this.logOperateId);
        log.setLogOperateType(ChangeReasonEnum.SUP.getValue());
        log.setIsCheck(Constant.YES_INT);
        log.setReplyTime(null);
        if (this.getSupUser() != null) {
            log.setUserId(this.getSupUser().getId());
            log.setUserName(this.getSupUser().getNickName());
        } else {
            log.setUserId(supplierOrder.getSupUserId());
            log.setUserId(supplierOrder.getSupUserName());
        }
        this.updateOrderReplyTime(supplierOrder);
        this.insertLog(Arrays.asList(log));
    }

    private void updateOrderReplyTime(SupplierOrder supplierOrder) {
        ArrayList<Integer> changeTypeList = new ArrayList<Integer>();
        changeTypeList.add(PurchaseOrderOperationTypeEnum.SENT_TO_SUP.getValue());
        changeTypeList.add(PurchaseOrderOperationTypeEnum.CREATE_ORDER.getValue());
        changeTypeList.add(PurchaseOrderOperationTypeEnum.MODIFY_ORDER.getValue());
        changeTypeList.add(PurchaseOrderOperationTypeEnum.PLAN_CHANGE.getValue());
        PurchaseOrderLogExample example = new PurchaseOrderLogExample();
        PurchaseOrderLogExample.Criteria criteria = example.createCriteria().andPurOrderIdEqualTo(supplierOrder.getId()).andIsCheckEqualTo(Constant.YES_INT).andLogOperateTypeEqualTo(ChangeReasonEnum.PUR.getValue()).andReplyTimeIsNull().andChangeTypeIn(changeTypeList);
        example.setOrderByClause("ID DESC");
        List logList = ContextUtils.getPurchaseOrderLogService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)logList)) {
            return;
        }
        criteria.andLogOperateIdEqualTo(((PurchaseOrderLog)logList.get(0)).getLogOperateId());
        PurchaseOrderLog tmp = new PurchaseOrderLog();
        tmp.setReplyTime(new Date());
        ContextUtils.getPurchaseOrderLogService().modifyByExample(tmp, example);
    }

    private void createForAddOrEditPurchase(PurchaseOrder purchaseOrder) {
        PurchaseOrderLog log = new PurchaseOrderLog();
        BeanUtils.copyProperties((Object)purchaseOrder, (Object)log);
        log.setChangeType(this.operationType.getValue());
        log.setPurOrderId(purchaseOrder.getId());
        log.setIsRefuseDeliveredDate(null);
        log.setIsRefusePrice(null);
        log.setIsRefuseQuantity(null);
        log.setLogOperateId(this.logOperateId);
        log.setLogOperateType(ChangeReasonEnum.PUR.getValue());
        if (this.getPurUser() != null) {
            log.setUserId(this.getPurUser().getId());
            log.setUserName(this.getPurUser().getNickName());
        } else {
            log.setUserId(purchaseOrder.getPurPlanerId());
            log.setUserName(purchaseOrder.getPurPlanerName());
        }
        ArrayList<PurchaseOrderLog> logs = new ArrayList<PurchaseOrderLog>();
        logs.add(log);
        if (!this.isNeedConfirm(purchaseOrder)) {
            log.setIsCheck(Constant.NO_INT);
            this.insertLog(logs);
            return;
        }
        log.setIsCheck(Constant.YES_INT);
        List<PurchaseOrderItem> unConfirmItemList = purchaseOrder.getItems().stream().filter(item -> {
            this.logger.debug(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue() + ":" + item.getOrderStatus());
            return PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue().equals(item.getOrderStatus());
        }).collect(Collectors.toList());
        List<PurchaseOrderLog> itemLogs = this.createForUnconfirmItem(unConfirmItemList);
        if (CollectionUtils.isNotEmpty(itemLogs)) {
            logs.addAll(itemLogs);
        }
        this.updateLastesOperate(purchaseOrder);
        this.insertLog(logs);
    }

    private void updateLastesOperate(PurchaseOrder purchaseOrder) {
        ArrayList<Integer> changeTypeList = new ArrayList<Integer>();
        changeTypeList.add(PurchaseOrderOperationTypeEnum.SENT_TO_SUP.getValue());
        changeTypeList.add(PurchaseOrderOperationTypeEnum.CREATE_ORDER.getValue());
        changeTypeList.add(PurchaseOrderOperationTypeEnum.MODIFY_ORDER.getValue());
        PurchaseOrderLogExample example = new PurchaseOrderLogExample();
        example.createCriteria().andPurOrderIdEqualTo(purchaseOrder.getId()).andLogOperateTypeEqualTo(ChangeReasonEnum.PUR.getValue()).andChangeTypeIn(changeTypeList).andIsCheckEqualTo(Constant.YES_INT).andReplyTimeIsNull();
        List logList = ContextUtils.getPurchaseOrderLogService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)logList)) {
            return;
        }
        PurchaseOrderLog tmp2 = new PurchaseOrderLog();
        tmp2.setIsCheck(Constant.NO_INT);
        List logIdsList = logList.stream().map(PurchaseOrderLog::getId).collect(Collectors.toList());
        PurchaseOrderLogExample example2 = new PurchaseOrderLogExample();
        example2.createCriteria().andIdIn(logIdsList);
        ContextUtils.getPurchaseOrderLogService().modifyByExample(tmp2, example2);
    }

    private List<PurchaseOrderLog> createForUnconfirmItem(List<PurchaseOrderItem> purOrderItemList) {
        List<PurchaseOrderLog> logs = purOrderItemList.stream().map(item -> {
            PurchaseOrderLog log = new PurchaseOrderLog();
            BeanUtils.copyProperties((Object)item, (Object)log);
            log.setChangeType(this.operationType.getValue());
            log.setPurOrderId(item.getOrderId());
            log.setPurOrderItemId(item.getId());
            log.setRemark(item.getPurRemark());
            log.setLogOperateId(this.logOperateId);
            log.setFactoryCode(item.getFactory());
            log.setFactoryName(item.getFactoryName());
            log.setLogOperateType(ChangeReasonEnum.PUR.getValue());
            log.setIsCheck(Constant.YES_INT);
            if (this.getPurUser() != null) {
                log.setUserId(this.getPurUser().getId());
                log.setUserName(this.getPurUser().getNickName());
            } else {
                log.setUserId(this.purchaseOrder.getPurPlanerId());
                log.setUserName(this.purchaseOrder.getPurPlanerName());
            }
            return log;
        }).collect(Collectors.toList());
        return logs;
    }

    private boolean isNeedConfirm(PurchaseOrder purchaseOrder) {
        Integer orderStatus = purchaseOrder.getOrderStatus();
        if (orderStatus == null && StringUtils.isNotBlank((String)purchaseOrder.getId())) {
            PurchaseOrder tmpOrder = (PurchaseOrder)ContextUtils.getPurchaseOrderService().queryObjById(purchaseOrder.getId());
            orderStatus = tmpOrder.getOrderStatus();
        }
        return PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue().equals(orderStatus);
    }
}

