/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.utils.DeliveryOperateEnum;
import com.els.base.purchase.command.order.UpdateIsCanDeliveryCmd;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyOrderItemOnWayQuantityCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    public static Logger logger = LoggerFactory.getLogger(ModifyOrderItemOnWayQuantityCmd.class);
    private String orderItemId;
    private DeliveryOperateEnum type;
    private BigDecimal quantity;

    public ModifyOrderItemOnWayQuantityCmd(String orderItemId, DeliveryOperateEnum type, BigDecimal quantity) {
        Assert.isNotBlank((String)orderItemId, (String)"\u8ba2\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)((Object)type), (String)"\u4fee\u6539\u8ba2\u5355\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)quantity, (String)"\u4fee\u6539\u8ba2\u5355\u7684\u7684\u6570\u91cf");
        this.orderItemId = orderItemId;
        this.type = type;
        this.quantity = quantity;
    }

    @Override
    public String execute(ICommandInvoker context) {
        logger.info("EVENT=\u4fee\u6539\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570|\u64cd\u4f5c\u7c7b\u578b={}|orderItemId={}|\u53d8\u66f4\u6570\u91cf={}", new Object[]{this.type, this.orderItemId, this.quantity});
        PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(this.orderItemId);
        SupplierOrderItem supplierOrderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(this.orderItemId);
        switch (this.type) {
            case DELIVERY_ORDER_CANCEL: 
            case DELIVERY_ORDER_DELETE: 
            case DELIVERY_ORDER_RECEIVE: {
                this.subtractQuantity(purchaseOrderItem, supplierOrderItem, this.quantity.multiply(new BigDecimal(-1)));
                return null;
            }
            case DELIVERY_ORDER_ADD: 
            case DELIVERY_ORDER_MODIFY: {
                this.subtractQuantity(purchaseOrderItem, supplierOrderItem, this.quantity);
                return null;
            }
        }
        return null;
    }

    private void subtractQuantity(PurchaseOrderItem purchaseOrderItem, SupplierOrderItem supplierOrderItem, BigDecimal quantity) {
        ContextUtils.getPurOrderItemExtService().addDeliveredQuantity(purchaseOrderItem.getId(), quantity);
        ContextUtils.getPurOrderItemExtService().addOnwayQuantity(purchaseOrderItem.getId(), quantity);
        UpdateIsCanDeliveryCmd updateIsCanDeliveryCmd = new UpdateIsCanDeliveryCmd(purchaseOrderItem.getId());
        this.context.invoke(updateIsCanDeliveryCmd);
    }
}

