/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.plan.command.nonejit.sup.NoneJitPlanSendToPurCmd;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.plan.utils.PlanDataSourceEnum;
import com.els.base.purchase.command.log.CreateOperationLogCommand;
import com.els.base.purchase.command.order.sup.ConfirmOrderItemCommand;
import com.els.base.purchase.command.order.sup.ConfirmTheWholeOrderCommand;
import com.els.base.purchase.command.order.sup.RefuseOrderItemCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.BusinessTypeEnum;
import com.els.base.purchase.utils.IsRefuseStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderOperationTypeEnum;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RefusePartOfOrderCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private SupplierOrder supplierOrder;

    public RefusePartOfOrderCommand(SupplierOrder order) {
        this.supplierOrder = order;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.supplierOrder);
        if (this.allConfirm(this.supplierOrder)) {
            ConfirmTheWholeOrderCommand cmd = new ConfirmTheWholeOrderCommand(this.supplierOrder);
            cmd.copyProperties(this);
            context.invoke(cmd);
        } else {
            this.handlerPartRefuseOrder(this.supplierOrder);
            CreateOperationLogCommand createLogCmd = new CreateOperationLogCommand(this.supplierOrder, PurchaseOrderOperationTypeEnum.REFUSE);
            createLogCmd.copyProperties(this);
            this.context.invoke(createLogCmd);
        }
        return null;
    }

    private boolean allConfirm(SupplierOrder supplierOrder) {
        int confirmItemCount = 0;
        for (SupplierOrderItem item : supplierOrder.getItems()) {
            if (!PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(item.getOrderStatus())) continue;
            ++confirmItemCount;
        }
        return confirmItemCount == supplierOrder.getItems().size();
    }

    private boolean isAllRefuse(SupplierOrder supplierOrder) {
        int confirmItemCount = 0;
        for (SupplierOrderItem item : supplierOrder.getItems()) {
            if (!PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(item.getOrderStatus())) continue;
            ++confirmItemCount;
        }
        return confirmItemCount == 0;
    }

    private void handlerPartRefuseOrder(SupplierOrder supplierOrder) {
        this.partRefuseOrderItem(supplierOrder);
        this.partRefuseOrder(supplierOrder);
        this.updatePlanOrderStatus(supplierOrder);
        this.sendMessage(supplierOrder);
    }

    private void partRefuseOrderItem(SupplierOrder supplierOrder) {
        for (SupplierOrderItem supplierOrderItem : supplierOrder.getItems()) {
            if (PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(supplierOrderItem.getOrderStatus())) {
                this.confirmOrderItem(supplierOrder, supplierOrderItem);
                continue;
            }
            RefuseOrderItemCommand refuseOrderItemCommand = new RefuseOrderItemCommand(supplierOrderItem, supplierOrder);
            refuseOrderItemCommand.copyProperties(this);
            this.context.invoke(refuseOrderItemCommand);
        }
    }

    private void updatePlanOrderStatus(SupplierOrder supplierOrder) {
        for (SupDeliveryPlanItem planItem : supplierOrder.getPlanItemList()) {
            planItem.setPurOrderStatus(this.getOrderItemStatus(supplierOrder.getItems(), planItem.getPurOrderItemId()));
        }
        NoneJitPlanSendToPurCmd planSendToPurCmd = new NoneJitPlanSendToPurCmd(supplierOrder.getPlanItemList(), PlanDataSourceEnum.UI);
        planSendToPurCmd.copyProperties(this);
        this.context.invoke(planSendToPurCmd);
    }

    private Integer getOrderItemStatus(List<SupplierOrderItem> items, String purOrderItemId) {
        return items.stream().filter(item -> item.getId().equals(purOrderItemId)).map(SupplierOrderItem::getOrderStatus).findAny().orElseGet(() -> PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
    }

    private void partRefuseOrder(SupplierOrder supplierOrder) {
        Integer orderStatus = PurchaseOrderConfirmStatusEnum.PART_REFUSE.getValue();
        if (this.isAllRefuse(supplierOrder)) {
            orderStatus = PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue();
        }
        supplierOrder.setOrderStatus(orderStatus);
        supplierOrder.setIsRefusePrice(this.isRefusePirce(supplierOrder));
        supplierOrder.setIsRefuseDeliveredDate(this.isRefuseDeliveredDate(supplierOrder));
        supplierOrder.setIsRefuseQuantity(this.isRefuseQuantity(supplierOrder));
        supplierOrder.setSupUserId(this.getSupUser().getId());
        supplierOrder.setSupUserName(this.getSupUser().getNickName());
        supplierOrder.setLastUpdateTime(new Date());
        supplierOrder.setReplyTime(new Date());
        ContextUtils.getSupplierOrderService().modifyObj(supplierOrder);
        PurchaseOrder record = new PurchaseOrder();
        record.setOrderStatus(orderStatus);
        record.setIsRefusePrice(supplierOrder.getIsRefusePrice());
        record.setIsRefuseDeliveredDate(supplierOrder.getIsRefuseDeliveredDate());
        record.setIsRefuseQuantity(supplierOrder.getIsRefuseQuantity());
        record.setSupUserId(this.getSupUser().getId());
        record.setSupUserName(this.getSupUser().getNickName());
        record.setLastUpdateTime(new Date());
        record.setId(supplierOrder.getId());
        record.setSupRemark(supplierOrder.getSupRemark());
        record.setPurUserId(supplierOrder.getPurUserId());
        record.setPurUserName(supplierOrder.getPurUserName());
        record.setReplyTime(new Date());
        ContextUtils.getPurchaseOrderService().modifyObj(record);
    }

    private void confirmOrderItem(SupplierOrder supplierOrder, SupplierOrderItem supplierOrderItem) {
        ConfirmOrderItemCommand command = new ConfirmOrderItemCommand(supplierOrderItem, supplierOrder);
        command.copyProperties(this);
        this.context.invoke(command);
    }

    private Integer isRefuseQuantity(SupplierOrder supplierOrder) {
        boolean isRefuse = supplierOrder.getItems().stream().filter(supplierOrderItem -> !PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(supplierOrderItem.getOrderStatus())).anyMatch(supplierOrderItem -> Constant.YES_INT.equals(supplierOrderItem.getIsRefuseQuantity()));
        return isRefuse ? Constant.YES_INT : Constant.NO_INT;
    }

    private Integer isRefuseDeliveredDate(SupplierOrder supplierOrder2) {
        boolean isRefuse = this.supplierOrder.getItems().stream().filter(supplierOrderItem -> !PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(supplierOrderItem.getOrderStatus())).anyMatch(supplierOrderItem -> Constant.YES_INT.equals(supplierOrderItem.getIsRefuseDeliveredDate()));
        return isRefuse ? Constant.YES_INT : Constant.NO_INT;
    }

    private Integer isRefusePirce(SupplierOrder supplierOrder) {
        boolean isRefuse = supplierOrder.getItems().stream().filter(supplierOrderItem -> !PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(supplierOrderItem.getOrderStatus())).anyMatch(supplierOrderItem -> Constant.YES_INT.equals(supplierOrderItem.getIsRefusePrice()));
        return isRefuse ? Constant.YES_INT : Constant.NO_INT;
    }

    private void sendMessage(SupplierOrder supplierOrder) {
        Message message;
        boolean isSendToPurer = supplierOrder.getItems().stream().anyMatch(item -> IsRefuseStatusEnum.REFUSE.getValue().equals(item.getIsRefusePrice()));
        if (isSendToPurer && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{supplierOrder.getPurUserId()})) {
            message = Message.init((Object)supplierOrder).setCompanyCode(supplierOrder.getSupCompanySrmCode()).setSenderId(supplierOrder.getSupUserId()).addReceiverId(supplierOrder.getPurUserId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(BusinessTypeEnum.PO_PART_BACK.getCode());
            MessageSendUtils.sendMessage((Message)message);
        }
        message = Message.init((Object)supplierOrder).setCompanyCode(supplierOrder.getSupCompanySrmCode()).setSenderId(supplierOrder.getSupUserId()).addReceiverId(supplierOrder.getPurPlanerId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(BusinessTypeEnum.PO_PART_BACK.getCode());
        MessageSendUtils.sendMessage((Message)message);
    }

    private void valid(SupplierOrder order) {
        Assert.isNotNull((Object)order, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        if (!PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue().equals(order.getOrderStatus())) {
            throw new CommonException(String.format("\u8ba2\u5355[%s]\u5df2\u56de\u7b7e\uff0c\u4e0d\u7528\u91cd\u590d\u64cd\u4f5c", order.getOrderNo()));
        }
        if (order.getSupRemark() != null && order.getSupRemark().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (CollectionUtils.isEmpty(order.getItems())) {
            throw new CommonException("\u884c\u6570\u636e\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u884c\u6570\u636e"});
        }
        for (SupplierOrderItem item : order.getItems()) {
            Assert.isNotBlank((String)item.getId(), (String)"\u8ba2\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
            if (!PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(item.getOrderStatus()) && !PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(item.getOrderStatus())) {
                throw new CommonException("\u8ba2\u5355\u884c\u7684\u786e\u8ba4\u5f02\u5e38\uff0c\u65e2\u4e0d\u662f\u786e\u8ba4\uff0c\u4e5f\u4e0d\u662f\u62d2\u7edd");
            }
            if (IsRefuseStatusEnum.REFUSE.getValue().equals(item.getIsRefusePrice())) {
                Assert.isNotBlank((String)order.getPurUserId(), (String)"\u56e0\u4e3a\u4ef7\u683c\u9000\u56de\u7684\u8ba2\u5355\uff0c\u91c7\u8d2d\u5458\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.checkIsPlanRefuse(item, order.getPlanItemList());
        }
        SupplierOrder temp = (SupplierOrder)ContextUtils.getSupplierOrderService().queryObjById(order.getId());
        if (PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(temp.getOrderStatus()) || PurchaseOrderConfirmStatusEnum.PART_REFUSE.getValue().equals(temp.getOrderStatus())) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u5df2\u7ecf\u53d1\u9001\u51fa\u53bb\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u9001");
        }
        ContextUtils.getSupplierOrderService().isHaveNewOrder(order.getId());
    }

    private void checkIsPlanRefuse(SupplierOrderItem item, List<SupDeliveryPlanItem> planItemList) {
        boolean isRefuse;
        List<SupDeliveryPlanItem> planList = planItemList.stream().filter(planItem -> planItem.getPurOrderNo().equals(item.getOrderNo()) && planItem.getPurOrderItemNo().equals(item.getOrderItemNo())).collect(Collectors.toList());
        if (PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(item.getOrderStatus()) && (isRefuse = planList.stream().anyMatch(planItem -> PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(planItem.getSupConfirmStatus()) && PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue().equals(planItem.getPurConfirmStatus())))) {
            throw new CommonException(String.format("\u8ba2\u5355\u884c [%s] \u786e\u8ba4\u5931\u8d25\uff0c\u56e0\u4e3a\u4ea4\u8d27\u8ba1\u5212\u5df2\u7ecf\u901a\u8fc7\u5bfc\u5165\uff0c\u53d1\u751f\u53d8\u66f4\u3002", item.getOrderItemNo()));
        }
        if (IsRefuseStatusEnum.REFUSE.getValue().equals(item.getIsRefuseDeliveredDate())) {
            PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
            example.createCriteria().andPurOrderNoEqualTo(item.getOrderNo()).andPurOrderItemNoEqualTo(item.getOrderItemNo());
            List purPlanList = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
            boolean isNotChange = DeliveryPlanUtils.isEqualBewteenPurAndSupIgnoreReason(purPlanList, planList);
            if (isNotChange) {
                String msg = String.format("\u8ba2\u5355\u884c[%s][%s]\u7684\u62d2\u7edd\u4ea4\u671f\uff0c\u9700\u8981\u63d0\u4f9b\u65b0\u7684\u5408\u9002\u4ea4\u671f", item.getOrderNo(), item.getOrderItemNo());
                throw new CommonException(msg);
            }
        }
    }
}

