/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.purchase.command.order.sup.RefuseOrderItemCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.utils.BusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class RefuseTheWholeOrderCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private SupplierOrder supplierOrder;

    public RefuseTheWholeOrderCommand(SupplierOrder order) {
        this.supplierOrder = order;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.supplierOrder);
        this.refuseItems(this.supplierOrder);
        this.refuseOrder(this.supplierOrder);
        this.refusePlan(this.supplierOrder);
        this.sendMessage();
        return null;
    }

    private void refusePlan(SupplierOrder supplierOrder) {
        PurDeliveryPlanItemExample purExample = new PurDeliveryPlanItemExample();
        purExample.createCriteria().andPurOrderIdEqualTo(supplierOrder.getId()).andIsJitEqualTo(Constant.NO_INT);
        PurDeliveryPlanItem purItem = new PurDeliveryPlanItem();
        purItem.setPurOrderStatus(supplierOrder.getOrderStatus());
        purItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(purItem, purExample);
        SupDeliveryPlanItemExample supExample = new SupDeliveryPlanItemExample();
        supExample.createCriteria().andPurOrderIdEqualTo(supplierOrder.getId()).andIsJitEqualTo(Constant.NO_INT).andDeliveryOrderIdIsNull();
        SupDeliveryPlanItem supItem = new SupDeliveryPlanItem();
        supItem.setPurOrderStatus(supplierOrder.getOrderStatus());
        supItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(supItem, supExample);
    }

    private void refuseItems(SupplierOrder supplierOrder) {
        if (CollectionUtils.isEmpty(supplierOrder.getItems())) {
            SupplierOrderItemExample exampleItem = new SupplierOrderItemExample();
            exampleItem.createCriteria().andSupCompanyIdEqualTo(supplierOrder.getSupCompanyId()).andOrderIdEqualTo(supplierOrder.getId());
            List supplierOrderItems = ContextUtils.getSupplierOrderItemService().queryAllObjByExample((IExample)exampleItem);
            supplierOrderItems.forEach(item -> {
                item.setOrderStatus(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
                item.setSupUserId(this.getSupUser().getId());
                item.setSupUserName(this.getSupUser().getNickName());
                item.setUpdateTime(new Date());
            });
            supplierOrder.setItems(supplierOrderItems);
        }
        for (SupplierOrderItem supplierOrderItem : supplierOrder.getItems()) {
            RefuseOrderItemCommand refuseOrderItemCommand = new RefuseOrderItemCommand(supplierOrderItem, supplierOrder);
            refuseOrderItemCommand.copyProperties(this);
            this.context.invoke(refuseOrderItemCommand);
        }
    }

    private void refuseOrder(SupplierOrder supplierOrder) {
        SupplierOrder tmpSuplierOrder = new SupplierOrder();
        SupplierOrder hisOrder = this.queryHisOrder(supplierOrder.getId());
        if (hisOrder != null) {
            tmpSuplierOrder = hisOrder;
        }
        Date refuseDate = new Date();
        tmpSuplierOrder.setId(supplierOrder.getId());
        tmpSuplierOrder.setSupRemark(supplierOrder.getSupRemark());
        tmpSuplierOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
        tmpSuplierOrder.setSupUserId(this.getSupUser().getId());
        tmpSuplierOrder.setSupUserName(this.getSupUser().getNickName());
        tmpSuplierOrder.setLastUpdateTime(refuseDate);
        tmpSuplierOrder.setIsRefusePrice(Constant.YES_INT);
        tmpSuplierOrder.setIsRefuseDeliveredDate(Constant.YES_INT);
        tmpSuplierOrder.setIsRefuseQuantity(Constant.YES_INT);
        tmpSuplierOrder.setReplyTime(new Date());
        ContextUtils.getSupplierOrderService().modifyObj(tmpSuplierOrder);
        PurchaseOrder tmpPurchaseOrder = new PurchaseOrder();
        tmpPurchaseOrder.setId(supplierOrder.getId());
        tmpPurchaseOrder.setSupRemark(supplierOrder.getSupRemark());
        tmpPurchaseOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
        tmpPurchaseOrder.setSupUserId(this.getSupUser().getId());
        tmpPurchaseOrder.setSupUserName(this.getSupUser().getNickName());
        tmpPurchaseOrder.setLastUpdateTime(refuseDate);
        tmpPurchaseOrder.setIsRefusePrice(Constant.YES_INT);
        tmpPurchaseOrder.setIsRefuseDeliveredDate(Constant.YES_INT);
        tmpPurchaseOrder.setIsRefuseQuantity(Constant.YES_INT);
        tmpPurchaseOrder.setPurUserId(supplierOrder.getPurUserId());
        tmpPurchaseOrder.setPurUserName(supplierOrder.getPurUserName());
        tmpPurchaseOrder.setReplyTime(new Date());
        ContextUtils.getPurchaseOrderService().modifyObj(tmpPurchaseOrder);
    }

    private void sendMessage() {
        Message message = Message.init((Object)this.supplierOrder).setCompanyCode(this.supplierOrder.getSupCompanySrmCode()).setSenderId(this.supplierOrder.getSupUserId()).addReceiverId(this.supplierOrder.getPurPlanerId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(BusinessTypeEnum.PO_ALL_BACK.getCode());
        MessageSendUtils.sendMessage((Message)message);
    }

    private SupplierOrder queryHisOrder(String id) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        values.add(PurchaseOrderConfirmStatusEnum.PART_REFUSE.getValue());
        SupplierOrderExample example = new SupplierOrderExample();
        example.createCriteria().andIdEqualTo(id).andOrderStatusIn(values);
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        PageView<SupplierOrder> pageView = ContextUtils.getSupplierOrderService().queryAllHisOrderByExample(example);
        if (pageView == null || CollectionUtils.isEmpty((Collection)pageView.getQueryResult())) {
            return null;
        }
        return (SupplierOrder)pageView.getQueryResult().get(0);
    }

    private void valid(SupplierOrder order) {
        SupplierOrder temp = (SupplierOrder)ContextUtils.getSupplierOrderService().queryObjById(order.getId());
        if (!PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue().equals(temp.getOrderStatus())) {
            throw new CommonException(String.format("\u8ba2\u5355[%s]\u5df2\u56de\u7b7e\uff0c\u4e0d\u7528\u91cd\u590d\u62d2\u7edd", temp.getOrderNo()));
        }
        if (order.getSupRemark() != null && order.getSupRemark().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (CollectionUtils.isNotEmpty(order.getItems())) {
            this.validOrderItem(order, order.getItems());
        }
        ContextUtils.getSupplierOrderService().isHaveNewOrder(order.getId());
    }

    private void validOrderItem(SupplierOrder order, List<SupplierOrderItem> items) {
        for (SupplierOrderItem item : items) {
            Assert.isNotBlank((String)item.getId(), (String)"\u8ba2\u5355\u884cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

