/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.utils;

import com.els.base.purchase.entity.PurOrderItemExt;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.service.PurOrderItemExtService;
import com.els.base.purchase.utils.PurchaseOrderDeliveryStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderIsEnableEnum;
import com.els.base.utils.SpringContextHolder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PurchaseOrderUtils {
    private static final Logger logger = LoggerFactory.getLogger(PurchaseOrderUtils.class);

    public static Integer isAllItemEnable(List<PurchaseOrderItem> items) {
        int deleteCount = 0;
        int freezeCount = 0;
        for (PurchaseOrderItem item : items) {
            if (PurchaseOrderIsEnableEnum.DELETED.getValue().equals(item.getIsEnable())) {
                ++deleteCount;
            }
            if (!PurchaseOrderIsEnableEnum.FREEZE.getValue().equals(item.getIsEnable())) continue;
            ++freezeCount;
        }
        if (deleteCount == items.size()) {
            return PurchaseOrderIsEnableEnum.DELETED.getValue();
        }
        if (freezeCount == items.size()) {
            return PurchaseOrderIsEnableEnum.FREEZE.getValue();
        }
        if (freezeCount + deleteCount >= items.size()) {
            return PurchaseOrderIsEnableEnum.FREEZE.getValue();
        }
        return PurchaseOrderIsEnableEnum.ENABLE.getValue();
    }

    public static Integer isAllItemFinish(List<PurchaseOrderItem> items) {
        int finishItemCount = 0;
        for (PurchaseOrderItem item : items) {
            if (!"Y".equals(item.getFinishFlag())) continue;
            ++finishItemCount;
        }
        if (finishItemCount == 0) {
            return PurchaseOrderDeliveryStatusEnum.RECEVIED_NONE.getValue();
        }
        if (finishItemCount == items.size()) {
            return PurchaseOrderDeliveryStatusEnum.RECEIVED_ALL.getValue();
        }
        return PurchaseOrderDeliveryStatusEnum.RECEIVED_PART.getValue();
    }

    public static PurOrderItemExt getPurchaseItemExt(String itemId) {
        PurOrderItemExtService service = (PurOrderItemExtService)SpringContextHolder.getOneBean(PurOrderItemExtService.class);
        PurOrderItemExt ext = service.queryByItemId(itemId);
        return ext;
    }
}

