/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.command.CreateCommand;
import com.els.base.delivery.command.WriteBackToErpCommand;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.purchase.entity.SupplierOrderItem;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SendCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private DeliveryOrder deliveryOrder;
    private Date dateTime;

    public SendCommand(DeliveryOrder deliveryOrder) {
        this.deliveryOrder = deliveryOrder;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid();
        if (StringUtils.isBlank((String)this.deliveryOrder.getId())) {
            CreateCommand createCmd = new CreateCommand(this.deliveryOrder);
            createCmd.copyProperties(this);
            context.invoke(createCmd);
        }
        DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
        deliveryOrderItemExample.createCriteria().andDeliveryOrderIdEqualTo(this.deliveryOrder.getId());
        DeliveryOrderItem tmpItem = new DeliveryOrderItem();
        tmpItem.setDeliveryStatus(DeliveryStatusEnum.ONWAY.getValue());
        ContextUtils.getDeliveryOrderItemService().updateDeliveryOrderItem(tmpItem, deliveryOrderItemExample);
        DeliveryOrder tmp = new DeliveryOrder();
        tmp.setId(this.deliveryOrder.getId());
        tmp.setDeliveryDate(new Date());
        tmp.setDeliveryStatus(DeliveryStatusEnum.ONWAY.getValue());
        if (this.getSupUser() != null) {
            this.deliveryOrder.setUserId(this.getSupUser().getId());
            this.deliveryOrder.setUserName(this.getSupUser().getNickName());
        }
        ContextUtils.getDeliveryOrderService().modifyAndAddHis(tmp, "\u53d1\u9001\u53d1\u8d27\u5355");
        this.context.invoke(new WriteBackToErpCommand(this.deliveryOrder.getId()));
        return null;
    }

    private void valid() {
        if (this.dateTime == null) {
            try {
                this.dateTime = DateUtils.parseDate((String)"2018-12-04 13:11", (String[])new String[]{"yyyy-MM-dd HH:mm"});
            }
            catch (ParseException e) {
                this.logger.warn("\u65f6\u95f4\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            }
        }
        if (this.deliveryOrder.getDeliveryStatus() != null && !DeliveryStatusEnum.UN_SENT.getValue().equals(this.deliveryOrder.getDeliveryStatus()) && this.dateTime != null && this.deliveryOrder.getCreateTime() != null && this.dateTime.compareTo(this.deliveryOrder.getCreateTime()) < 0) {
            throw new CommonException("\u8be5\u53d1\u8d27\u5355\u5df2\u7ecf\u53d1\u8d27\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d27", "cannot_repeat_shipment");
        }
        List<DeliveryOrderItem> items = this.deliveryOrder.getItems();
        if (CollectionUtils.isEmpty(items)) {
            items = ContextUtils.getDeliveryOrderItemService().queryByDeliveryOrderId(this.deliveryOrder.getId());
            Assert.isNotEmpty(items, (String)String.format("\u9001\u8d27\u5355[%s]\u7f3a\u5c11\u884c\u6570\u636e", this.deliveryOrder.getDeliveryOrderNo()));
            this.deliveryOrder.setItems(items);
        }
        if (this.dateTime != null && this.deliveryOrder.getCreateTime() != null && this.dateTime.compareTo(this.deliveryOrder.getCreateTime()) > 0) {
            return;
        }
        for (DeliveryOrderItem item : this.deliveryOrder.getItems()) {
            SupplierOrderItem orderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(item.getPurOrderItemId());
            if (BigDecimal.ZERO.compareTo(orderItem.getCanDeliveryQuantity()) <= 0) continue;
            String errMsg = String.format("\u8ba2\u5355\u4fe1\u606f\u5df2\u53d8\u66f4\uff0c\u8be5\u9001\u8d27\u5355\u4e2d\u7269\u6599[%s] \u8ba2\u5355[%s-%s]\u4fe1\u606f\u5df2\u8fc7\u671f\uff0c\u8bf7\u5220\u9664\u8be5\u9001\u8d27\u5355\u540e\uff0c\u91cd\u65b0\u5efa\u5355\u3002", orderItem.getMaterialCode(), orderItem.getOrderNo(), orderItem.getOrderItemNo());
            throw new CommonException(errMsg, "delivery_gt_candelivery", new Object[]{errMsg});
        }
    }
}

