/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.PurOrderItemExtMapper;
import com.els.base.purchase.entity.PurOrderItemExt;
import com.els.base.purchase.entity.PurOrderItemExtExample;
import com.els.base.purchase.service.PurOrderItemExtService;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultPurOrderItemExtService")
public class PurOrderItemExtServiceImpl
implements PurOrderItemExtService {
    @Resource
    protected PurOrderItemExtMapper purOrderItemExtMapper;

    @Override
    @CacheEvict(value={"purOrderItemExt"}, allEntries=true)
    public void addObj(PurOrderItemExt t) {
        this.purOrderItemExtMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"purOrderItemExt"}, allEntries=true)
    public void modifyObj(PurOrderItemExt t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purOrderItemExtMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"purOrderItemExt"}, keyGenerator="redisKeyGenerator")
    public PurOrderItemExt queryByItemId(String itemId) {
        PurOrderItemExtExample example = new PurOrderItemExtExample();
        example.createCriteria().andOrderItemIdEqualTo(itemId);
        List<PurOrderItemExt> list = this.purOrderItemExtMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u7684\u6536\u8d27/\u53d1\u8d27\u62d3\u5c55\u4fe1\u606f\u51fa\u73b0\u91cd\u590d");
        }
        return list.get(0);
    }

    @Override
    @CacheEvict(value={"purOrderItemExt"}, allEntries=true)
    public void addDeliveredQuantity(String itemId, BigDecimal quantity) {
        this.purOrderItemExtMapper.addDeliveredQuantity(itemId, quantity);
    }

    @Override
    @CacheEvict(value={"purOrderItemExt"}, allEntries=true)
    public void addOnwayQuantity(String itemId, BigDecimal quantity) {
        int result = this.purOrderItemExtMapper.addOnwayQuantity(itemId, quantity);
        if (result <= 0) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u7684\u5728\u9014\u6570\u91cf\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
    }

    @Override
    @CacheEvict(value={"purOrderItemExt"}, allEntries=true)
    public void addReceivedQuantity(String itemId, BigDecimal quantity) {
        this.purOrderItemExtMapper.addReceivedQuantity(itemId, quantity);
    }

    @Override
    @CacheEvict(value={"purOrderItemExt"}, allEntries=true)
    public void addReturnQuantity(String itemId, BigDecimal quantity) {
        this.purOrderItemExtMapper.addReturnQuantity(itemId, quantity);
    }

    @Override
    @CacheEvict(value={"purOrderItemExt"}, allEntries=true)
    public void addPlanQuantity(String itemId, BigDecimal quantity) {
        this.purOrderItemExtMapper.addPlanQuantity(itemId, quantity);
    }

    @Override
    @CacheEvict(value={"purOrderItemExt"}, allEntries=true)
    public List<PurOrderItemExt> queryAllObjByExample(PurOrderItemExtExample example) {
        return this.purOrderItemExtMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"purOrderItemExt"}, allEntries=true)
    public int updateByExampleSelective(PurOrderItemExt itemExt, PurOrderItemExtExample example) {
        return this.purOrderItemExtMapper.updateByExample(itemExt, example);
    }
}

