/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.PurchaseOrderLogMapper;
import com.els.base.purchase.entity.PurchaseOrderLog;
import com.els.base.purchase.entity.PurchaseOrderLogExample;
import com.els.base.purchase.service.PurchaseOrderLogService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseOrderLogService")
public class PurchaseOrderLogServiceImpl
implements PurchaseOrderLogService {
    @Resource
    protected PurchaseOrderLogMapper purchaseOrderLogMapper;

    @CacheEvict(value={"purchaseOrderLog"}, allEntries=true)
    public void addObj(PurchaseOrderLog t) {
        this.purchaseOrderLogMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseOrderLog"}, allEntries=true)
    public void addAll(List<PurchaseOrderLog> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseOrderLogMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseOrderLog"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseOrderLogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseOrderLog"}, allEntries=true)
    public void deleteByExample(PurchaseOrderLogExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseOrderLogMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseOrderLog"}, allEntries=true)
    public void modifyObj(PurchaseOrderLog t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseOrderLogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseOrderLog"}, keyGenerator="redisKeyGenerator")
    public PurchaseOrderLog queryObjById(String id) {
        return this.purchaseOrderLogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseOrderLog"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrderLog> queryAllObjByExample(PurchaseOrderLogExample example) {
        return this.purchaseOrderLogMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseOrderLog"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseOrderLog> queryObjByPage(PurchaseOrderLogExample example) {
        PageView<PurchaseOrderLog> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseOrderLogMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"purchaseOrderLog"}, allEntries=true)
    public void modifyByExample(PurchaseOrderLog purchaseOrderLog, PurchaseOrderLogExample example) {
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        this.purchaseOrderLogMapper.updateByExampleSelective(purchaseOrderLog, example);
    }

    @Override
    @Cacheable(value={"purchaseOrderLog"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseOrderLog> queryOrderAndPlanItemBeyond(String supCompanySapCode, String factoryCode, Date startTime, Date endTime) {
        return this.purchaseOrderLogMapper.queryOrderAndPlanItemBeyond(supCompanySapCode, factoryCode, startTime, endTime);
    }

    @Override
    @Cacheable(value={"purchaseOrderLog"}, keyGenerator="redisKeyGenerator")
    public int countByExample(PurchaseOrderLogExample example) {
        return this.purchaseOrderLogMapper.countByExample(example);
    }
}

